document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');

    if (!menuToggle || !sidebar || !overlay) {
        console.error('Elementos do menu não encontrados');
        return;
    }

    function toggleMenu() {
        sidebar.classList.toggle('sidebar-open');
        overlay.classList.toggle('active');
        document.body.style.overflow = sidebar.classList.contains('sidebar-open') ? 'hidden' : '';
    }

    // Event listeners
    menuToggle.addEventListener('click', function(e) {
        e.preventDefault();
        toggleMenu();
    });

    overlay.addEventListener('click', function(e) {
        e.preventDefault();
        toggleMenu();
    });

    // Fechar menu ao clicar em um link
    document.querySelectorAll('.sidebar-item').forEach(function(link) {
        link.addEventListener('click', function() {
            if (window.innerWidth <= 768) {
                toggleMenu();
            }
        });
    });

    // Fechar menu ao redimensionar
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768 && sidebar.classList.contains('sidebar-open')) {
            toggleMenu();
        }
    });
}); 