<?php

namespace App\Filament\User\Resources\ModeloResource\Pages;

use App\Filament\User\Resources\ModeloResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;


class CreateModelo extends CreateRecord
{
    protected static string $resource = ModeloResource::class;

    public function getTitle(): string
    {
        return 'Novo Modelo';
    }   

    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Modelo')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Modelo criado!')
            ->body('O novo modelo foi cadastrado com sucesso')
            ->duration(5000);
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    } 
    
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

}

