<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

$id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
if (!$id) {
    header('Location: index.php');
    exit;
}

// Buscar dados do cliente
$stmt = $pdo->prepare("SELECT * FROM clients WHERE id = ?");
$stmt->execute([$id]);
$client = $stmt->fetch();

if (!$client) {
    header('Location: index.php');
    exit;
}

// Processar formulário de edição
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $phone = filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_STRING);
    $monthly_fee = filter_input(INPUT_POST, 'monthly_fee', FILTER_SANITIZE_STRING);
    $monthly_fee = str_replace('.', '', $monthly_fee);
    $monthly_fee = str_replace(',', '.', $monthly_fee);

    try {
        $stmt = $pdo->prepare("UPDATE clients SET name = ?, email = ?, phone = ?, monthly_fee = ? WHERE id = ?");
        $stmt->execute([$name, $email, $phone, $monthly_fee, $id]);
        
        header('Location: index.php?success=updated');
        exit;
    } catch (PDOException $e) {
        header('Location: index.php?error=update_failed');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Cliente - Sistema Financeiro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    <?php include '../includes/navbar.php'; ?>

    <div id="content" class="py-4 px-4">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Editar Cliente</h4>
                    <form action="edit.php?id=<?php echo $id; ?>" method="POST">
                        <div class="mb-3">
                            <label for="name" class="form-label">Nome</label>
                            <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($client['name']); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($client['email']); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="phone" class="form-label">Telefone</label>
                            <input type="tel" class="form-control phone-mask" id="phone" name="phone" value="<?php echo htmlspecialchars($client['phone']); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="monthly_fee" class="form-label">Mensalidade</label>
                            <input type="text" class="form-control money-mask" id="monthly_fee" name="monthly_fee" value="<?php echo number_format($client['monthly_fee'], 2, ',', '.'); ?>" required>
                        </div>
                        <div class="d-flex justify-content-end gap-2">
                            <a href="index.php" class="btn btn-secondary">Cancelar</a>
                            <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        $(document).ready(function() {
            // Máscaras
            $('.phone-mask').mask('(00) 00000-0000');
            $('.money-mask').mask('#.##0,00', {reverse: true});
        });
    </script>
</body>
</html>
