<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

$id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
if (!$id) {
    header('Location: index.php');
    exit;
}

try {
    // Verificar se existem movimentos relacionados
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM movements WHERE client_id = ?");
    $stmt->execute([$id]);
    $hasMovements = $stmt->fetch()['count'] > 0;

    if ($hasMovements) {
        header('Location: index.php?error=has_movements');
        exit;
    }

    // Excluir o cliente
    $stmt = $pdo->prepare("DELETE FROM clients WHERE id = ?");
    $stmt->execute([$id]);
    
    header('Location: index.php?success=deleted');
    exit;
} catch (PDOException $e) {
    header('Location: index.php?error=delete_failed');
    exit;
}
