<?php $__env->startSection('content'); ?>

<style>
    /* Otimização global de espaço para modais no PDV */
    .modal .modal-header {
        padding: 0.5rem 1rem;
    }
    
    .modal .modal-body {
        padding: 0.75rem 1rem;
    }
    
    .modal .modal-footer {
        padding: 0.5rem 1rem;
    }
    
    .modal .form-control, 
    .modal .form-select, 
    .modal select, 
    .modal input {
        padding: 0.25rem 0.5rem;
        height: calc(1.75rem + 2px);
    }
    
    .modal .btn:not(.btn-lg) {
        padding: 0.25rem 0.75rem;
    }
    
    .modal .form-group {
        margin-bottom: 0.5rem;
    }
    
    .modal .row > [class*="col-"] {
        margin-bottom: 0.5rem;
    }
    
    /* Tabelas compactas nos modais */
    .modal .table th, 
    .modal .table td {
        padding: 0.4rem 0.5rem;
    }
</style>

<?php echo Form::open()
->post()
->route('frontbox.store')->id('form-pdv'); ?>

<div class="pl-lg-4">
    <?php if(request()->has('pagamento_sucesso')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <strong><i class="ri-checkbox-circle-line me-2"></i> Recebimento processado com sucesso!</strong>
        <p class="mb-0">As contas foram baixadas no sistema.</p>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>
    <?php echo $__env->make('front_box._forms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo Form::close(); ?>


<?php echo $__env->make('modals._novo_cliente', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._sangria_caixa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._suprimento_caixa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._finalizar_venda', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
$(document).ready(function() {
    console.log("PDV v1 iniciado - Preparando interface...");
    
    // Verificar se todos os modais estão disponíveis
    if ($('#finalizar_venda').length === 0) {
        console.error("Modal finalizar_venda não encontrado!");
    } else {
        console.log("Modal finalizar_venda encontrado e pronto");
    }
    
    // Certificar-se de que os modais funcionam corretamente
    $('.modal').modal({
        keyboard: false,
        backdrop: 'static',
        show: false
    });
    
    // Garantir que o botão de finalizar venda abra o modal correto
    // Usando event delegation para garantir que funcione mesmo com elementos carregados dinamicamente
    $(document).on('click', '#finalizar_venda_tab', function(e) {
        e.preventDefault();
        console.log("Botão finalizar_venda_tab clicado via delegate");
        $('#finalizar_venda').modal('show');
    });
    
    // Botão alternativo para finalizar
    $(document).on('click', '#btn-finalizar', function(e) {
        e.preventDefault();
        console.log("Botão btn-finalizar clicado via delegate");
        $('#finalizar_venda').modal('show');
    });
    
    // Botões dentro do modal
    $('#btn_nao_fiscal, .btn-fiscal').on('click', function() {
        console.log("Botão de documento selecionado");
        // Aqui normalmente teria o código para processar o tipo de documento
    });
    
    console.log("PDV v1 inicializado com sucesso");
});

// Modificar a função que adiciona produto ao PDV para verificar estoque corretamente
function adicionarProdutoPDV(codigo, quantidade) {
    // Mostrar ícone de carregamento
    $('#loading').show();
    
    $.ajax({
        url: '<?php echo e(route("api.pdv.produto.find")); ?>',
        type: 'POST',
        data: {
            termo: codigo,
            quantidade: quantidade,
            local_id: '<?php echo e($local_id); ?>',
            empresa_id: '<?php echo e(request()->empresa_id); ?>'
        },
        dataType: 'json',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(data) {
            // Processar o produto e adicioná-lo à venda
            adicionarItemVenda(data);
            $('#loading').hide();
        },
        error: function(xhr) {
            $('#loading').hide();
            
            // Tratar o erro (estoque insuficiente, etc)
            if (xhr.status === 422) {
                const response = JSON.parse(xhr.responseText);
                swal('Atenção', response.erro, 'warning');
            } else {
                swal('Erro', 'Produto não encontrado', 'error');
            }
        }
    });
}
</script>

<?php if(session('show_success_modal')): ?>
<script>
    $(document).ready(function() {
        // Modal de pagamento realizado com sucesso
        Swal.fire({
            title: 'Pagamento realizado com sucesso!',
            text: '<?php echo session("success_message") ? session("success_message") : "As contas foram baixadas no sistema."; ?>',
            icon: 'success',
            confirmButtonText: 'OK'
        });
    });
</script>
<?php endif; ?>

<!-- Script para verificar o cookie de recebimento finalizado -->
<script>
$(document).ready(function() {
    // Função para obter valor de cookie
    function getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
        return null;
    }
    
    // Verificar se existe o cookie de recebimento finalizado
    const recebimentoFinalizado = getCookie('recebimento_finalizado');
    if (recebimentoFinalizado === 'true') {
        // Remover o cookie para não mostrar a mensagem novamente
        document.cookie = 'recebimento_finalizado=; path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        
        // Mostrar mensagem de sucesso
        Swal.fire({
            title: 'Recebimento realizado com sucesso!',
            text: 'As contas foram baixadas no sistema.',
            icon: 'success',
            confirmButtonText: 'OK'
        });
        
        // Adicionar também um alerta mais visível na página
        setTimeout(function() {
            const alertHtml = `
                <div id="recebimento-sucesso-alert" class="alert alert-success alert-dismissible fade show" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
                    <strong><i class="ri-checkbox-circle-line me-2"></i> Recebimento processado com sucesso!</strong>
                    <p class="mb-0">As contas foram baixadas no sistema.</p>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `;
            $('body').append(alertHtml);
            
            // Auto-fechar o alerta após 5 segundos
            setTimeout(function() {
                $('#recebimento-sucesso-alert').alert('close');
            }, 5000);
        }, 500);
        
        console.log('Recebimento de contas finalizado com sucesso');
    }
});
</script>

<?php if(isset($itensConsignacao) && is_array($itensConsignacao) && count($itensConsignacao) > 0): ?>
<script>
console.log('PDV JS rodando!');
$(document).ready(function() {
    var itens = <?php echo json_encode($itensConsignacao, 15, 512) ?>;
    console.log('Itens consignação carregados:', itens);
    itens.forEach(function(item) {
        console.log('Tentando adicionar ao PDV:', item);
        var codigo = item.codigo_barras || item.produto_id;
        if(item.quantidade > 0 && codigo) {
            adicionarProdutoPDV(codigo, item.quantidade);
        } else {
            console.warn('Item ignorado (sem quantidade ou identificador):', item);
        }
    });
});
</script>
<?php endif; ?>

<script>
console.log('PDV JS rodando! (forçado no final do arquivo)');
</script>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('front_box.default', 
['title' => !isset($title) ? (isset($pedido) ? isset($isDelivery) ? ('Finalizando Pedido Delivery ' . $pedido->id) : ('Finalizando Comanda ' . $pedido->comanda) : 'Nova Venda - PDV') : $title ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/front_box/create.blade.php ENDPATH**/ ?>