

<?php $__env->startSection('title', 'Comandas'); ?>

<?php $__env->startSection('content'); ?>
<style>
.mesas-lista {
    max-height: 80vh;
    overflow-y: auto;
    display: flex;
    flex-wrap: wrap;
    gap: 4px 10px;
    padding: 10px;
    justify-content: center;
}
.mesa-card {
    width: 170px;
    min-width: 150px;
    cursor: pointer;
    border: 2px solid transparent;
    border-radius: 8px;
    transition: border 0.2s, background 0.2s, box-shadow 0.2s, transform 0.15s;
    display: flex;
    flex-direction: column;
    align-items: center;
}
.mesa-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.12);
    transform: scale(1.06);
    /* border-color: #ffc107; */
    z-index: 2;
}
.mesa-card.selected {
    border: 2px solid #ffc107;
}
.mesa-card.ocupada, .mesa-card.selected.ocupada {
    background: #dc3545 !important;
    color: #fff !important;
    border-color: #dc3545 !important;
}
.carrinho {
    min-width: 260px;
    max-width: 320px;
}

.produto-card {
    cursor: pointer;
    transition: all 0.2s ease;
    border: 1px solid #dee2e6;
    max-width: 180px;
    margin-left: auto;
    margin-right: auto;
    min-height: 120px;
    height: 120px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.produto-card .card-body {
    flex: 1 1 auto;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    height: 100%;
}

.produto-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    border-color: #007bff;
}

.categoria-btn {
    transition: all 0.2s ease;
}

.categoria-btn.active {
    background-color: #007bff;
    color: white;
    border-color: #007bff;
}

.produto-item {
    transition: all 0.3s ease;
}

.produto-item.hidden {
    display: none;
}

.carrinho-largo {
    min-width: 320px;
    max-width: 420px;
}

.input-produto-alinhado {
    max-width: 100%;
    margin-left: auto;
    margin-right: auto;
}

#carrinhoBody {
    padding: 0;
}

#carrinhoProdutosLista {
    flex: 1 1 auto;
    min-height: 0;
    overflow-y: auto;
    padding: 10px 4px 0 10px;
}

.carrinho.card {
    display: flex;
    flex-direction: column;
    height: 680px;
    min-height: 680px;
    max-height: 680px;
}
.carrinho.card .card-body {
    flex: 1 1 auto;
    min-height: 0;
    padding-bottom: 0;
    overflow: hidden;
    display: flex;
    flex-direction: column;
}

.mesa-card .fw-bold.mesa-numero {
    font-size: 2rem;
    line-height: 1.1;
}
.mesa-card .mesa-valor {
    font-size: 1.3rem;
    font-weight: bold;
}
.mesa-card .status-text {
    font-size: 1.3rem;
    font-weight: bold;
}
.mesa-card .status-label {
    font-size: 1.1rem;
    font-weight: bold;
}
#carrinhoTotal .text-success {
    font-size: 1.2rem;
    font-weight: bold;
}
#carrinhoHeader {
    font-weight: bold;
    font-size: 1.0rem;
}
.card-footer {
    flex-shrink: 0;
}
.btn-violeta {
    background-color: #7c3aed;
    color: #fff;
    border: none;
}
.btn-violeta:hover, .btn-violeta:focus {
    background-color: #5b21b6;
    color: #fff;
}
</style>
<div class="container-fluid">
    <div class="row">
        <!-- Coluna Esquerda: Mesas -->
        <div class="col-md-3">
            <h5 class="mt-3 text-center">Mesas/Comandas</h5>
            <div class="mesas-lista">
                <?php $__currentLoopData = $mesas->sortBy('numero'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mesa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mesa-card mesa-item <?php echo e($mesa->status == 'ocupada' ? 'ocupada' : 'bg-primary text-white'); ?> p-2 mb-2"
                        data-id="<?php echo e($mesa->id); ?>" data-status="<?php echo e($mesa->status); ?>" data-numero="<?php echo e(str_pad($mesa->numero, 3, '0', STR_PAD_LEFT)); ?>"
                        onclick="selecionarMesa(<?php echo e($mesa->id); ?>)">
                        <div class="fw-bold mesa-numero"><?php echo e(str_pad($mesa->numero, 3, '0', STR_PAD_LEFT)); ?></div>
                        <div class="status-text mb-1"><?php echo e($mesa->status == 'ocupada' ? 'Ocupado' : 'Livre'); ?></div>
                        <div class="mesa-valor">R$ <span id="valor-mesa-<?php echo e($mesa->id); ?>"><?php echo e(number_format($mesa->total ?? 0, 2, ',', '.')); ?></span></div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <!-- Coluna Central: Categorias e Produtos -->
        <div class="col-md-6">
            <div id="painel-central">
                <h5 class="mt-3">Cardápio</h5>
                
                <!-- Categorias -->
                <div class="mb-3">
                    <h6 class="fw-bold mb-2">Categorias:</h6>
                    <?php if($categorias->count() > 0): ?>
                        <div class="d-flex flex-wrap gap-2">
                            <!-- Botão TODOS sempre primeiro -->
                            <button class="btn btn-outline-secondary btn-sm categoria-btn active" 
                                    onclick="filtrarPorCategoria('')"
                                    data-categoria="">
                                TODOS
                            </button>
                            
                            <!-- Categorias específicas em ordem de prioridade -->
                            <?php
                                $categoriasEspeciais = ['DIVERSOS', 'PERFUMES'];
                                $categoriasNormais = $categorias->filter(function($cat) use ($categoriasEspeciais) {
                                    return !in_array(strtoupper($cat->nome), $categoriasEspeciais);
                                });
                                $categoriasEspeciaisOrdenadas = $categorias->filter(function($cat) use ($categoriasEspeciais) {
                                    return in_array(strtoupper($cat->nome), $categoriasEspeciais);
                                })->sortBy(function($cat) use ($categoriasEspeciais) {
                                    return array_search(strtoupper($cat->nome), $categoriasEspeciais);
                                });
                            ?>
                            
                            <!-- Categorias especiais (DIVERSOS, PERFUMES) -->
                            <?php $__currentLoopData = $categoriasEspeciaisOrdenadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button class="btn btn-outline-primary btn-sm categoria-btn" 
                                        onclick="filtrarPorCategoria(<?php echo e($categoria->id); ?>)"
                                        data-categoria="<?php echo e($categoria->id); ?>">
                                    <?php echo e($categoria->nome); ?>

                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            <!-- Demais categorias -->
                            <?php $__currentLoopData = $categoriasNormais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button class="btn btn-outline-primary btn-sm categoria-btn" 
                                        onclick="filtrarPorCategoria(<?php echo e($categoria->id); ?>)"
                                        data-categoria="<?php echo e($categoria->id); ?>">
                                    <?php echo e($categoria->nome); ?>

                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            Nenhuma categoria cadastrada. <a href="<?php echo e(route('categoria-produtos.create')); ?>">Cadastrar categoria</a>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Formulário Manual de Adição de Produto -->
                <div class="mb-3">
                    <div class="card p-2" style="background: #f8f9fa; border: 1px solid #dee2e6;">
                        <div class="row g-2 align-items-end">
                            <div class="col-md-6">
                                <label class="form-label mb-1">Produto</label>
                                <select id="produto_manual" class="form-control"></select>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label mb-1">Qtd</label>
                                <input type="number" id="quantidade_manual" class="form-control" value="1" min="0.001" step="0.001">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label mb-1">Valor Unit.</label>
                                <input type="text" id="preco_manual" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <button id="btn-adicionar-manual" class="btn btn-success w-100">
                                    <i class="ri-add-circle-line"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Fim do Formulário Manual -->

                <!-- Produtos -->
                <div class="mb-3">
                    <h6 class="fw-bold mb-2">BUSCA RÁPIDA DE PRODUTOS:</h6>
                    <input type="text" class="form-control mb-2 input-produto-alinhado" id="buscaProduto" placeholder="Buscar produto..." onkeyup="filtrarProdutosPorNome()">
                    <?php if($produtos->count() > 0): ?>
                        <div class="row" id="produtosGrid">
                            <?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 mb-2 produto-item" data-categoria="<?php echo e($produto->categoria_id); ?>" data-nome="<?php echo e(strtolower($produto->nome)); ?>">
                                    <div class="card h-100 produto-card" 
                                         onclick="adicionarProduto(<?php echo e($produto->id); ?>, '<?php echo e($produto->nome); ?>', <?php echo e($produto->valor_cardapio ?? $produto->valor_unitario); ?>, 1)">
                                        <div class="card-body p-2 text-center">
                                            <div class="fw-bold small"><?php echo e($produto->nome); ?></div>
                                            <div class="text-primary fw-bold">R$ <?php echo e(number_format($produto->valor_cardapio ?? $produto->valor_unitario, 2, ',', '.')); ?></div>
                                            <div class="text-muted small">
                                                Estoque: <?php echo e($produto->estoque ? number_format($produto->estoque->quantidade, 0, ',', '.') : '0'); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2 d-flex justify-content-center" id="paginacaoContainer">
                            <?php echo e($produtos->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            Nenhum produto cadastrado. <a href="<?php echo e(route('produtos.create')); ?>">Cadastrar produto</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- Coluna Direita: Carrinho -->
        <div class="col-md-3">
            <div class="carrinho card mt-5 ms-2 carrinho-largo">
                <div class="card-header text-center" id="carrinhoHeader">
                    PRODUTOS DA MESA/COMANDA <span id="carrinhoHeaderBadge"></span>
                </div>
                <div class="card-body" id="carrinhoBody">
                    <div id="carrinhoProdutosLista"></div>
                </div>
                <div class="card-footer d-flex flex-column gap-2">
                    <div id="carrinhoTotal" class="fw-bold text-end mb-2"></div>
                    <div class="d-flex gap-2 mb-2">
                        <button class="btn btn-primary btn-sm d-flex align-items-center justify-content-center" style="width:50%" onclick="imprimirConferencia()">
                            <i class="bi bi-printer me-1"></i> Conferência
                        </button>
                        <button class="btn btn-danger btn-sm d-flex align-items-center justify-content-center" style="width:50%" onclick="cancelarCarrinho()">
                            <i class="bi bi-x-circle me-1"></i> Cancelar
                        </button>
                    </div>
                    <div class="d-flex gap-2">
                        <button class="btn btn-success btn-sm d-flex align-items-center justify-content-center" style="width:50%" onclick="finalizarCarrinho()">
                            <i class="bi bi-check-circle me-1"></i> Finalizar
                        </button>
                        <button class="btn btn-secondary btn-sm d-flex align-items-center justify-content-center" style="width:50%" onclick="sairModuloComanda()">
                            <i class="bi bi-box-arrow-right me-1"></i> Sair
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- jQuery CDN (deve vir antes do Select2 e dos scripts customizados) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Bootstrap Icons CDN -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
<script>
let mesaSelecionada = null;
let carrinho = [];
let categoriaAtiva = '';

// Interceptar cliques na paginação para fazer AJAX
document.addEventListener('DOMContentLoaded', function() {
    ativarEventosPaginacao();
    const carrinhoTotal = document.getElementById('carrinhoTotal');
    if (carrinhoTotal) {
        carrinhoTotal.innerHTML = 'Total: <span class="text-success">R$ 0,00</span>';
    }
    $('#produto_manual').select2({
        placeholder: 'Digite o nome ou código do produto',
        minimumInputLength: 1,
        width: '100%',
        ajax: {
            url: '/api/produtos/busca', // Ajuste para sua rota de busca
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return { q: params.term };
            },
            processResults: function(data) {
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.id,
                            text: item.nome,
                            preco: item.valor_cardapio ?? item.valor_unitario
                        };
                    })
                };
            },
            cache: true
        }
    });
    $('#produto_manual').on('select2:select', function(e) {
        var preco = e.params.data.preco;
        if (preco === undefined || preco === null || preco === '') {
            preco = e.params.data.valor_cardapio || e.params.data.valor_unitario || 0;
        }
        // Formatar como moeda brasileira
        $('#preco_manual').val(Number(preco).toLocaleString('pt-BR', {minimumFractionDigits: 2}));
    });
});

$(document).ready(function() {
    $('#btn-adicionar-manual').on('click', function(e) {
        e.preventDefault();
        var produto = $('#produto_manual').select2('data')[0];
        var quantidade = $('#quantidade_manual').val().replace(',', '.');
        quantidade = parseFloat(quantidade);
        var preco = $('#preco_manual').val().replace('.', '').replace(',', '.');
        preco = parseFloat(preco);

        if (!produto || !produto.id) {
            mostrarAlertaComanda('Selecione um produto!');
            return;
        }
        if (!mesaSelecionada) {
            mostrarAlertaComanda('Selecione uma mesa primeiro!');
            return;
        }
        if (isNaN(preco) || preco <= 0) {
            mostrarAlertaComanda('Informe um valor unitário válido!');
            return;
        }
        if (isNaN(quantidade) || quantidade <= 0) {
            mostrarAlertaComanda('Informe uma quantidade válida!');
            return;
        }
        adicionarProduto(
            parseInt(produto.id),
            produto.text,
            preco,
            quantidade
        );
        // Limpar campos após adicionar
        $('#produto_manual').val(null).trigger('change');
        $('#quantidade_manual').val(1);
        $('#preco_manual').val('');
    });
});

function ativarEventosPaginacao() {
    // Intercepta cliques nos links de paginação
    document.addEventListener('click', function(e) {
        if (e.target.matches('.pagination a') || e.target.closest('.pagination a')) {
            e.preventDefault();
            const link = e.target.matches('.pagination a') ? e.target : e.target.closest('.pagination a');
            const url = link.href;
            carregarProdutosViaAjax(url);
        }
    });
}

function carregarProdutosViaAjax(url) {
    // Mostrar loading
    const produtosGrid = document.getElementById('produtosGrid');
    const paginacaoContainer = document.getElementById('paginacaoContainer');
    
    produtosGrid.innerHTML = '<div class="col-12 text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Carregando...</span></div></div>';
    
    // Fazer requisição AJAX
    fetch(url)
        .then(response => {
            if (!response.ok) {
                throw new Error('Erro na requisição: ' + response.status);
            }
            return response.text();
        })
        .then(html => {
            // Criar um elemento temporário para extrair apenas a seção dos produtos
            const tempDiv = document.createElement('div');
            tempDiv.innerHTML = html;
            
            // Extrair apenas a seção dos produtos
            const novoProdutosGrid = tempDiv.querySelector('#produtosGrid');
            if (novoProdutosGrid) {
                produtosGrid.innerHTML = novoProdutosGrid.innerHTML;
            }
            
            // Atualizar a paginação
            const novaPaginacao = tempDiv.querySelector('#paginacaoContainer');
            if (novaPaginacao) {
                paginacaoContainer.innerHTML = novaPaginacao.innerHTML;
            }
            
            // Aplicar filtro de categoria ativo se houver
            if (categoriaAtiva !== '') {
                filtrarPorCategoria(categoriaAtiva);
            }
            
            // Aplicar filtro de busca se houver
            const buscaInput = document.getElementById('buscaProduto');
            if (buscaInput && buscaInput.value) {
                filtrarProdutosPorNome();
            }
            
            // Atualizar URL sem recarregar a página
            window.history.pushState({}, '', url);
            
            // Reativar eventos de clique na paginação
            ativarEventosPaginacao();
        })
        .catch(error => {
            console.error('Erro ao carregar produtos:', error);
            produtosGrid.innerHTML = '<div class="col-12 text-center text-danger">Erro ao carregar produtos. Tente novamente.</div>';
        });
}

function selecionarMesa(id) {
    mesaSelecionada = id;
    document.querySelectorAll('.mesa-card').forEach(card => {
        card.classList.remove('selected');
    });
    const card = document.querySelector('.mesa-card[data-id="'+id+'"]');
    if(card) {
        card.classList.add('selected');
        // Muda status para ocupada e cor para vermelho
        card.classList.add('ocupada');
        card.querySelector('.status-text').innerText = 'Ocupada';
        card.setAttribute('data-status', 'ocupada');
    }
    // NOVO: Buscar itens da comanda via AJAX
    fetch(`/mesa-comandas/${id}/itens`)
        .then(response => response.json())
        .then(itens => {
            carrinho = itens.map(item => ({
                id: item.id,
                produto_id: item.produto_id,
                nome: item.produto ? item.produto.nome : 'Produto',
                valor: parseFloat(item.valor_unitario),
                quantidade: item.quantidade,
                subtotal: parseFloat(item.subtotal)
            }));
            atualizarCarrinho();
        })
        .catch(() => {
            carrinho = [];
            atualizarCarrinho();
        });
    const carrinhoHeader = document.getElementById('carrinhoHeader');
    const carrinhoHeaderBadge = document.getElementById('carrinhoHeaderBadge');
    if (carrinhoHeader && card && carrinhoHeaderBadge) {
        const numeroMesa = card.getAttribute('data-numero');
        carrinhoHeaderBadge.innerHTML = `<span class='badge-comanda bg-primary ms-1'>${numeroMesa}</span>`;
    }
}

function filtrarPorCategoria(categoriaId) {
    // Salvar categoria ativa
    categoriaAtiva = categoriaId;
    
    // Remove classe active de todos os botões
    document.querySelectorAll('.categoria-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    // Adiciona classe active ao botão clicado
    const btnClicado = document.querySelector(`[data-categoria="${categoriaId}"]`);
    if (btnClicado) {
        btnClicado.classList.add('active');
    }
    
    // Filtra os produtos
    document.querySelectorAll('.produto-item').forEach(item => {
        if (categoriaId === '' || item.getAttribute('data-categoria') == categoriaId) {
            item.classList.remove('hidden');
        } else {
            item.classList.add('hidden');
        }
    });
}

function adicionarProduto(produtoId, nome, valor, quantidade) {
    quantidade = parseFloat(quantidade);
    if (!mesaSelecionada) {
        mostrarAlertaComanda('Selecione uma mesa primeiro!');
        return;
    }
    // Verifica se o produto já está no carrinho
    let itemExistente = carrinho.find(item => item.produto_id === produtoId);
    if (itemExistente) {
        // Atualiza quantidade no backend
        fetch(`/itens-comanda/${itemExistente.id}`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                quantidade: itemExistente.quantidade + quantidade,
                valor_unitario: itemExistente.valor,
                subtotal: (itemExistente.quantidade + quantidade) * itemExistente.valor
            })
        })
        .then(response => response.json())
        .then(data => {
            itemExistente.quantidade = data.quantidade;
            itemExistente.subtotal = data.subtotal;
            atualizarCarrinho();
        });
    } else {
        // Cria novo item no backend
        fetch('/itens-comanda', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                mesa_comanda_id: mesaSelecionada,
                produto_id: produtoId,
                quantidade: quantidade,
                valor_unitario: valor,
                subtotal: valor * quantidade
            })
        })
        .then(response => response.json())
        .then(data => {
            carrinho.push({
                id: data.id,
                produto_id: produtoId,
                nome: nome,
                valor: valor,
                quantidade: quantidade,
                subtotal: valor * quantidade
            });
            atualizarCarrinho();
        });
    }
}

function removerProduto(index) {
    const item = carrinho[index];
    if (item && item.id) {
        fetch(`/itens-comanda/${item.id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(() => {
            carrinho.splice(index, 1);
            atualizarCarrinho();
        });
    } else {
        carrinho.splice(index, 1);
        atualizarCarrinho();
    }
}

function alterarQuantidade(index, delta) {
    const item = carrinho[index];
    const novaQuantidade = item.quantidade + delta;
    if (novaQuantidade <= 0) {
        removerProduto(index);
        return;
    }
    if (item && item.id) {
        fetch(`/itens-comanda/${item.id}`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                quantidade: novaQuantidade,
                valor_unitario: item.valor,
                subtotal: novaQuantidade * item.valor
            })
        })
        .then(response => response.json())
        .then(data => {
            item.quantidade = data.quantidade;
            item.subtotal = data.subtotal;
            atualizarCarrinho();
        });
    } else {
        item.quantidade = novaQuantidade;
        item.subtotal = novaQuantidade * item.valor;
        atualizarCarrinho();
    }
}

function formatarValorBR(valor) {
    return valor
        .toFixed(2)
        .replace('.', ',')
        .replace(/\B(?=(\d{3})+(?!\d))/g, '.');
}

function atualizarCarrinho() {
    const carrinhoBody = document.getElementById('carrinhoBody');
    const carrinhoProdutosLista = document.getElementById('carrinhoProdutosLista');
    const carrinhoTotal = document.getElementById('carrinhoTotal');

    let total = 0;
    let html = '';

    if (carrinho.length === 0) {
        if (!mesaSelecionada) {
            carrinhoProdutosLista.innerHTML = '<span id="carrinhoPlaceholder">Selecione uma mesa e adicione produtos.</span>';
        } else {
            carrinhoProdutosLista.innerHTML = '';
        }
        carrinhoTotal.innerHTML = 'Total: <span class="text-success">R$ 0,00</span>';
        // Atualiza valor da mesa para zero
        if (mesaSelecionada) {
            const valorMesaSpan = document.getElementById('valor-mesa-' + mesaSelecionada);
            if (valorMesaSpan) valorMesaSpan.textContent = formatarValorBR(0);
        }
        return;
    }

    carrinho.forEach((item, index) => {
        total += item.subtotal;
        html += `
            <div class="d-flex justify-content-between align-items-center mb-2 p-2 border-bottom">
                <div class="flex-grow-1">
                    <div class="fw-bold small">${item.nome}</div>
                    <div class="text-muted small">R$ ${item.valor.toFixed(2).replace('.', ',')} x ${Number(item.quantidade).toLocaleString('pt-BR', {minimumFractionDigits: 3, maximumFractionDigits: 3})}</div>
                </div>
                <div class="d-flex align-items-center">
                    <button class="btn btn-sm btn-outline-secondary me-1" onclick="alterarQuantidade(${index}, -1)">-</button>
                    <span class="mx-2">${Number(item.quantidade).toLocaleString('pt-BR', {minimumFractionDigits: 3, maximumFractionDigits: 3})}</span>
                    <button class="btn btn-sm btn-outline-secondary me-2" onclick="alterarQuantidade(${index}, 1)">+</button>
                    <button class="btn btn-sm btn-outline-danger" onclick="removerProduto(${index})">×</button>
                </div>
            </div>
        `;
    });

    carrinhoProdutosLista.innerHTML = html;
    carrinhoTotal.innerHTML = `Total: <span class="text-success">R$ ${formatarValorBR(total)}</span>`;
    // Atualiza valor da mesa selecionada
    if (mesaSelecionada) {
        const valorMesaSpan = document.getElementById('valor-mesa-' + mesaSelecionada);
        if (valorMesaSpan) {
            const valor = isNaN(total) ? 0 : total;
            valorMesaSpan.textContent = formatarValorBR(valor);
        }
    }
}

function cancelarCarrinho() {
    Swal.fire({
        title: 'Cancelar Carrinho?',
        text: 'Deseja realmente cancelar o carrinho? Esta ação não pode ser desfeita.',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, cancelar',
        cancelButtonText: 'Não',
        reverseButtons: true,
        allowOutsideClick: false
    }).then((result) => {
        if (result.isConfirmed) {
            if (mesaSelecionada) {
                // Remove todos os itens da comanda no backend
                fetch(`/mesa-comandas/${mesaSelecionada}/itens`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(() => {
                    // Atualiza status da mesa para livre no backend
                    fetch(`/mesa-comandas/${mesaSelecionada}`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ status: 'livre', valor_total: 0 })
                    })
                    .then(() => {
                        carrinho = [];
                        atualizarCarrinho();
                        // Libera a mesa visualmente
                        const card = document.querySelector('.mesa-card[data-id="'+mesaSelecionada+'"]');
                        if (card) {
                            card.classList.remove('selected', 'ocupada');
                            card.classList.add('bg-primary', 'text-white');
                            card.querySelector('.status-text').innerText = 'Livre';
                            card.setAttribute('data-status', 'livre');
                        }
                        mesaSelecionada = null;
                        // Atualiza cabeçalho do carrinho
                        const carrinhoHeaderBadge = document.getElementById('carrinhoHeaderBadge');
                        if (carrinhoHeaderBadge) {
                            carrinhoHeaderBadge.innerHTML = '';
                        }
                    });
                });
            } else {
                carrinho = [];
                atualizarCarrinho();
            }
        }
    });
}

function finalizarCarrinho() {
    if (!mesaSelecionada) {
        mostrarAlertaComanda('Selecione uma mesa primeiro!');
        return;
    }
    
    if (carrinho.length === 0) {
        mostrarAlertaComanda('Adicione produtos ao carrinho!');
        return;
    }
    
    // Aqui você implementaria a lógica para salvar o pedido
    mostrarAlertaComanda('Pedido finalizado! (Implementar lógica de salvamento)');
    console.log('Mesa:', mesaSelecionada);
    console.log('Carrinho:', carrinho);
}

function filtrarProdutosPorNome() {
    const busca = document.getElementById('buscaProduto').value.toLowerCase();
    const produtosGrid = document.getElementById('produtosGrid');
    const produtos = produtosGrid.querySelectorAll('.produto-item');

    produtos.forEach(produto => {
        const nome = produto.getAttribute('data-nome');
        if (nome.includes(busca)) {
            produto.classList.remove('hidden');
        } else {
            produto.classList.add('hidden');
        }
    });
}

function mostrarAlertaComanda(msg) {
    Swal.fire({
        icon: 'warning',
        title: 'Atenção',
        text: msg,
        confirmButtonText: 'OK',
        allowOutsideClick: false
    });
}

function imprimirConferencia() {
    if (!mesaSelecionada) {
        mostrarAlertaComanda('Selecione uma mesa primeiro!');
        return;
    }
    // Verifica status da mesa selecionada
    const card = document.querySelector('.mesa-card[data-id="'+mesaSelecionada+'"]');
    if (!card || card.getAttribute('data-status') !== 'ocupada') {
        mostrarAlertaComanda('A mesa/comanda deve estar aberta (ocupada) para imprimir a conferência!');
        return;
    }
    if (!carrinho || carrinho.length === 0) {
        mostrarAlertaComanda('Adicione itens à comanda antes de imprimir a conferência!');
        return;
    }
    Swal.fire({
        title: 'Imprimir Conferência?',
        text: 'Deseja imprimir a conferência desta comanda?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, imprimir',
        cancelButtonText: 'Cancelar',
        reverseButtons: true,
        allowOutsideClick: false
    }).then((result) => {
        if (result.isConfirmed) {
            window.open(`/mesa-comandas/${mesaSelecionada}/imprimir-conferencia`, '_blank');
        }
    });
}

function sairModuloComanda() {
    window.location.href = '/home';
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/mesa_comandas/index.blade.php ENDPATH**/ ?>