<?php $__env->startSection('css'); ?>
<style>
    body {
        min-height: 100vh;
        margin: 0;
        padding: 0;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #f8fafc;
    }

    .login-container {
        display: flex;
        min-height: 100vh;
        background: #fff;
    }

    /* Lado esquerdo - Formulário */
    .login-left {
        flex: 1;
        max-width: 480px;
        padding: 60px 40px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        background: #fff;
    }

    /* Lado direito - Background com animação de bolhas */
    .login-right {
        flex: 1;
        background: #667eea;
        position: relative;
        overflow: hidden;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    #animatedBg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
    }

    /* Logo SaaS */
    .saas-logo {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 40px;
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
    }

    .saas-logo span {
        color: white;
        font-size: 24px;
        font-weight: bold;
        letter-spacing: -1px;
    }

    .saas-logo img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        border-radius: 50%;
    }

    .login-title {
        font-size: 28px;
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 8px;
        line-height: 1.2;
    }

    .login-subtitle {
        color: #64748b;
        font-size: 16px;
        margin-bottom: 32px;
        line-height: 1.5;
    }

    .form-group {
        margin-bottom: 24px;
    }

    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 500;
        color: #374151;
        margin-bottom: 8px;
    }

    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        font-size: 16px;
        transition: all 0.2s ease;
        background: #fff;
        box-sizing: border-box;
    }

    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    .password-group {
        position: relative;
    }

    .forgot-password {
        color: #667eea;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
    }

    .forgot-password:hover {
        text-decoration: underline;
    }

    .form-check {
        display: flex;
        align-items: center;
        margin-bottom: 24px;
    }

    .form-check-input {
        width: 16px;
        height: 16px;
        margin-right: 8px;
        accent-color: #667eea;
    }

    .form-check-label {
        font-size: 14px;
        color: #6b7280;
    }

    .btn-login {
        width: 100%;
        background: #667eea;
        color: white;
        border: none;
        padding: 14px 24px;
        border-radius: 8px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-login:hover {
        background: #5a67d8;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .btn-login:active {
        transform: translateY(0);
    }

    .signup-link {
        text-align: center;
        margin-top: 32px;
        color: #6b7280;
        font-size: 14px;
    }

    .signup-link a {
        color: #667eea;
        text-decoration: none;
        font-weight: 500;
    }

    .signup-link a:hover {
        text-decoration: underline;
    }

    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .alert-danger {
        background: #fef2f2;
        color: #dc2626;
        border: 1px solid #fecaca;
    }

    .alert-success {
        background: #f0fdf4;
        color: #16a34a;
        border: 1px solid #bbf7d0;
    }

    .alert-info {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #bfdbfe;
    }

    .demo-buttons {
        display: grid;
        gap: 8px;
        margin-top: 12px;
    }

    .btn-demo {
        padding: 8px 16px;
        border-radius: 6px;
        border: none;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .btn-success {
        background: #16a34a;
        color: white;
    }

    .btn-success:hover {
        background: #15803d;
    }

    .btn-dark {
        background: #374151;
        color: white;
    }

    .btn-dark:hover {
        background: #1f2937;
    }

    .support-link {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        color: #667eea;
        text-decoration: none;
        font-size: 14px;
        margin-top: 12px;
    }

    .support-link:hover {
        text-decoration: underline;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .login-container {
            flex-direction: column;
        }
        
        .login-right {
            min-height: 200px;
            order: -1;
        }
        
        .login-left {
            padding: 40px 20px;
        }
        
        .login-title {
            font-size: 24px;
        }
    }

    @media (max-width: 480px) {
        .login-left {
            padding: 20px 16px;
        }
        
        .saas-logo {
            width: 60px;
            height: 60px;
            margin-bottom: 30px;
        }
        
        .saas-logo span {
            font-size: 18px;
        }
        
        .login-title {
            font-size: 22px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "Login <?php echo e(env("APP_NAME")); ?> - Sistema ERP",
    "description": "Acesse sua conta no <?php echo e(env("APP_NAME")); ?> e gerencie sua empresa com o melhor sistema ERP do mercado.",
    "publisher": {
        "@type": "Organization",
        "name": "<?php echo e(env("APP_NAME")); ?>",
        "logo": {
            "@type": "ImageObject",
            "url": "https://<?php echo e(env('APP_URL')); ?>/logo.png"
        }
    },
    "mainEntity": {
        "@type": "WebForm",
        "name": "Formulário de Login <?php echo e(env("APP_NAME")); ?>",
        "description": "Formulário para acessar o sistema <?php echo e(env("APP_NAME")); ?>"
    }
}
</script>

<?php
$login = (isset($_COOKIE['ckLogin'])) ? base64_decode($_COOKIE['ckLogin']) : '';
$pass = (isset($_COOKIE['ckPass'])) ? base64_decode($_COOKIE['ckPass']) : '';
$remember = (isset($_COOKIE['ckRemember'])) ? ($_COOKIE['ckRemember']) : '';
?>

<div class="login-container">
    <!-- Lado esquerdo - Formulário -->
    <div class="login-left">
        <div class="saas-logo">
            <img src="<?php echo e(asset('logo_sem_fundo.png')); ?>" alt="Logo" class="logo-image">
        </div>
        
        <h1 class="login-title">Login</h1>
        <p class="login-subtitle">Digite seu endereço de email e senha para acessar a conta</p>

        <?php if(env("APP_ENV") == "demo"): ?>
        <div class="alert alert-info">
            <p style="margin: 0 0 12px 0; font-weight: 500;">Acesso rápido (demo):</p>
            <div class="demo-buttons">
                <button class="btn-demo btn-success" onclick="login('slym@slym.com', '123456')">Superadmin</button>
                <button class="btn-demo btn-dark" onclick="login('teste@teste.com', '123456')">Administrador</button>
            </div>
            <a href="https://wa.me/5562992912798" class="support-link">
                <i class="ri-whatsapp-line"></i> Suporte
            </a>
        </div>
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
        <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login')); ?>" id="form-login" itemscope itemtype="https://schema.org/LoginAction">
            <?php echo csrf_field(); ?>
            
            <div class="form-group">
                <label for="email" class="form-label">Email</label>
                <input 
                    type="email" 
                    id="email" 
                    name="email" 
                    value="<?php echo e($login); ?>" 
                    required 
                    class="form-control" 
                    placeholder="Digite seu email" 
                    itemprop="email"
                >
            </div>

            <div class="form-group">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                    <label for="password" class="form-label" style="margin-bottom: 0;">Senha</label>
                    <a href="<?php echo e(route('password.request')); ?>" class="forgot-password">Esqueceu sua senha?</a>
                </div>
                <input 
                    type="password" 
                    id="password" 
                    name="password" 
                    value="<?php echo e($pass); ?>" 
                    required 
                    class="form-control" 
                    placeholder="Digite sua senha"
                >
            </div>

            <div class="form-check">
                <input 
                    type="checkbox" 
                    id="checkbox-signin" 
                    name="remember" 
                    class="form-check-input" 
                    <?php echo e($remember ? 'checked' : ''); ?>

                >
                <label class="form-check-label" for="checkbox-signin">lembrar-me</label>
            </div>

            <button class="btn-login" type="submit" itemprop="potentialAction">
                <i class="ri-login-box-line"></i> Acessar
            </button>
        </form>

        <div class="signup-link">
            <a href="<?php echo e(route('register')); ?>" itemprop="significantLink"></a>
        </div>

        <a target="_blank" href="https://wa.me/55<?php echo e(env('APP_FONE')); ?>" class="support-link" itemprop="contactPoint" style="margin-top: 20px;">
            <i class="ri-whatsapp-fill"></i> Fale com o Suporte
        </a>
    </div>

    <!-- Lado direito - Background com animação de bolhas -->
    <div class="login-right">
        <canvas id="animatedBg"></canvas>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    function login(email, senha){
        document.getElementById('email').value = email;
        document.getElementById('password').value = senha;
        document.getElementById('form-login').submit();
    }

    // Animação de bolhas no canvas
    const canvas = document.getElementById('animatedBg');
    const ctx = canvas.getContext('2d');

    function resizeCanvas() {
        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;
    }
    resizeCanvas();
    window.addEventListener('resize', resizeCanvas);

    class Bubble {
        constructor() {
            this.reset();
        }

        reset() {
            this.x = Math.random() * canvas.width;
            this.y = canvas.height + Math.random() * 100;
            this.size = Math.random() * 15 + 10; 
            this.speedY = Math.random() * 0.8 + 0.2;
            this.wobble = 0;
            this.wobbleSpeed = Math.random() * 0.02 + 0.005;
            this.amplitude = Math.random() * 1.5 + 0.5;
            this.opacity = Math.random() * 0.2 + 0.1;
            this.rotationAngle = Math.random() * Math.PI * 2;
            this.rotationSpeed = (Math.random() - 0.5) * 0.02;
            this.exploded = false;
            this.explosionParticles = [];
            this.explosionTime = 0;
        }

        update() {
            if (this.exploded) {
                // Atualizar partículas da explosão
                this.explosionTime++;
                this.explosionParticles.forEach(particle => {
                    particle.x += particle.vx;
                    particle.y += particle.vy;
                    particle.vy += 0.1; // gravidade
                    particle.opacity -= 0.02; // fade out
                });
                
                // Remover partículas com opacidade muito baixa
                this.explosionParticles = this.explosionParticles.filter(p => p.opacity > 0);
                
                // Se todas as partículas desapareceram, resetar a bolha
                if (this.explosionParticles.length === 0) {
                    this.reset();
                }
                return;
            }

            this.y -= this.speedY;
            this.wobble += this.wobbleSpeed;
            this.x += Math.sin(this.wobble) * this.amplitude;
            this.rotationAngle += this.rotationSpeed;

            // Verificar se chegou quase no topo da tela para explodir
            if (this.y <= canvas.height * 0.2 && !this.exploded) {
                this.explode();
            }

            if (this.y < -50) {
                this.reset();
            }
        }

        explode() {
            this.exploded = true;
            this.explosionTime = 0;
            
            // Criar partículas da explosão
            const particleCount = 8 + Math.floor(Math.random() * 5);
            for (let i = 0; i < particleCount; i++) {
                const angle = (Math.PI * 2 * i) / particleCount;
                const speed = Math.random() * 3 + 2;
                
                this.explosionParticles.push({
                    x: this.x,
                    y: this.y,
                    vx: Math.cos(angle) * speed,
                    vy: Math.sin(angle) * speed - 2,
                    size: Math.random() * 4 + 2,
                    opacity: 0.8
                });
            }
        }

        draw() {
            if (this.exploded) {
                // Desenhar partículas da explosão
                this.explosionParticles.forEach(particle => {
                    ctx.save();
                    ctx.globalAlpha = particle.opacity;
                    
                    ctx.beginPath();
                    ctx.arc(particle.x, particle.y, particle.size, 0, Math.PI * 2);
                    
                    const gradient = ctx.createRadialGradient(
                        particle.x, particle.y, 0,
                        particle.x, particle.y, particle.size
                    );
                    gradient.addColorStop(0, `rgba(255, 255, 255, ${particle.opacity})`);
                    gradient.addColorStop(1, `rgba(255, 255, 255, 0)`);
                    
                    ctx.fillStyle = gradient;
                    ctx.fill();
                    
                    ctx.restore();
                });
                return;
            }

            // Desenhar bolha normal
            ctx.save();
            ctx.translate(this.x, this.y);
            ctx.rotate(this.rotationAngle);
            
            ctx.beginPath();
            ctx.arc(0, 0, this.size, 0, Math.PI * 2);
            
            const gradient = ctx.createRadialGradient(0, 0, 0, 0, 0, this.size);
            gradient.addColorStop(0, `rgba(255, 255, 255, ${this.opacity * 0.5})`);
            gradient.addColorStop(0.5, `rgba(255, 255, 255, ${this.opacity * 0.3})`);
            gradient.addColorStop(0.8, `rgba(200, 230, 255, ${this.opacity * 0.4})`);
            gradient.addColorStop(1, `rgba(255, 255, 255, ${this.opacity * 0.1})`);
            
            ctx.fillStyle = gradient;
            ctx.fill();

            ctx.strokeStyle = `rgba(255, 255, 255, ${this.opacity * 0.5})`;
            ctx.lineWidth = 0.5;
            ctx.stroke();
            
            ctx.beginPath();
            ctx.arc(-this.size * 0.3, -this.size * 0.3, this.size * 0.4, 0, Math.PI * 2);
            const reflexGradient = ctx.createRadialGradient(
                -this.size * 0.3, -this.size * 0.3, 0,
                -this.size * 0.3, -this.size * 0.3, this.size * 0.4
            );
            reflexGradient.addColorStop(0, `rgba(255, 255, 255, ${this.opacity * 0.8})`);
            reflexGradient.addColorStop(1, 'rgba(255, 255, 255, 0)');
            ctx.fillStyle = reflexGradient;
            ctx.fill();
            
            ctx.beginPath();
            ctx.arc(this.size * 0.2, this.size * 0.2, this.size * 0.1, 0, Math.PI * 2);
            ctx.fillStyle = `rgba(255, 255, 255, ${this.opacity * 0.6})`;
            ctx.fill();
            
            ctx.restore();
        }
    }

    const bubbles = [];
    const bubbleCount = 15; 
    for (let i = 0; i < bubbleCount; i++) {
        bubbles.push(new Bubble());
    }

    function animate() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        bubbles.forEach(bubble => {
            bubble.update();
            bubble.draw();
        });

        requestAnimationFrame(animate);
    }

    animate();

    // Adicionar evento de teclado para CTRL+R
    document.addEventListener('keydown', function(event) {
        // Verificar se CTRL+R foi pressionado
        if (event.ctrlKey && event.key === 'r') {
            event.preventDefault(); // Prevenir o comportamento padrão do navegador
            window.location.href = '<?php echo e(route("register")); ?>';
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.header_auth', ['title' => 'Login'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/auth/login.blade.php ENDPATH**/ ?>