/*
 Navicat Premium Dump SQL

 Source Server         : localhost_3306
 Source Server Type    : MariaDB
 Source Server Version : 100429 (10.4.29-MariaDB)
 Source Host           : localhost:3306
 Source Schema         : sistema_erp

 Target Server Type    : MariaDB
 Target Server Version : 100429 (10.4.29-MariaDB)
 File Encoding         : 65001

 Date: 12/06/2025 19:51:42
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for acao_logs
-- ----------------------------
DROP TABLE IF EXISTS `acao_logs`;
CREATE TABLE `acao_logs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `local` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `acao` enum('cadastrar','editar','excluir','transmitir','cancelar','corrigir','erro') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `acao_logs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `acao_logs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 8197 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for acesso_logs
-- ----------------------------
DROP TABLE IF EXISTS `acesso_logs`;
CREATE TABLE `acesso_logs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ip` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `acesso_logs_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `acesso_logs_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1319 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for acomodacaos
-- ----------------------------
DROP TABLE IF EXISTS `acomodacaos`;
CREATE TABLE `acomodacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `categoria_id` bigint(20) UNSIGNED NOT NULL,
  `valor_diaria` decimal(12, 2) NOT NULL,
  `capacidade` int(11) NOT NULL,
  `estacionamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `acomodacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `acomodacaos_categoria_id_foreign`(`categoria_id`) USING BTREE,
  CONSTRAINT `acomodacaos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categoria_acomodacaos` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `acomodacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for adicionals
-- ----------------------------
DROP TABLE IF EXISTS `adicionals`;
CREATE TABLE `adicionals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_en` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_es` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `valor` decimal(12, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `adicionals_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `adicionals_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for agendamentos
-- ----------------------------
DROP TABLE IF EXISTS `agendamentos`;
CREATE TABLE `agendamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `data` date NOT NULL,
  `observacao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `inicio` time NOT NULL,
  `termino` time NOT NULL,
  `total` decimal(10, 2) NOT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(10, 2) NULL DEFAULT NULL,
  `valor_comissao` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `prioridade` enum('baixa','media','alta') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'baixa',
  `nfce_id` int(11) NULL DEFAULT NULL,
  `pedido_delivery_id` int(11) NULL DEFAULT NULL,
  `msg_wpp_manha_horario` tinyint(1) NOT NULL DEFAULT 0,
  `msg_wpp_alerta_horario` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `agendamentos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `agendamentos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `agendamentos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `agendamentos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `agendamentos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `agendamentos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for alocacao_centro_custos
-- ----------------------------
DROP TABLE IF EXISTS `alocacao_centro_custos`;
CREATE TABLE `alocacao_centro_custos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conta_pagar_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `conta_receber_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `centro_custo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(16, 7) NOT NULL,
  `porcentagem` decimal(5, 2) NOT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_alocacao_conta_pagar`(`conta_pagar_id`) USING BTREE,
  INDEX `fk_alocacao_conta_receber`(`conta_receber_id`) USING BTREE,
  INDEX `fk_alocacao_centro_custo`(`centro_custo_id`) USING BTREE,
  CONSTRAINT `fk_alocacao_centro_custo` FOREIGN KEY (`centro_custo_id`) REFERENCES `centro_custos` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `fk_alocacao_conta_pagar` FOREIGN KEY (`conta_pagar_id`) REFERENCES `conta_pagars` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `fk_alocacao_conta_receber` FOREIGN KEY (`conta_receber_id`) REFERENCES `conta_recebers` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for anexo_contas
-- ----------------------------
DROP TABLE IF EXISTS `anexo_contas`;
CREATE TABLE `anexo_contas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conta_pagar_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `conta_receber_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome_arquivo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `caminho_arquivo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_arquivo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tamanho_arquivo` int(11) NULL DEFAULT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `anexo_contas_conta_pagar_id_foreign`(`conta_pagar_id`) USING BTREE,
  INDEX `anexo_contas_conta_receber_id_foreign`(`conta_receber_id`) USING BTREE,
  INDEX `anexo_contas_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `anexo_contas_conta_pagar_id_foreign` FOREIGN KEY (`conta_pagar_id`) REFERENCES `conta_pagars` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `anexo_contas_conta_receber_id_foreign` FOREIGN KEY (`conta_receber_id`) REFERENCES `conta_recebers` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `anexo_contas_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for api_configs
-- ----------------------------
DROP TABLE IF EXISTS `api_configs`;
CREATE TABLE `api_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `status` tinyint(1) NOT NULL,
  `permissoes_acesso` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `api_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `api_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for api_logs
-- ----------------------------
DROP TABLE IF EXISTS `api_logs`;
CREATE TABLE `api_logs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefixo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('sucesso','erro') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('create','update','read','delete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `api_logs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `api_logs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for apontamentos
-- ----------------------------
DROP TABLE IF EXISTS `apontamentos`;
CREATE TABLE `apontamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(14, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `apontamentos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `apontamentos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for apuracao_mensal_eventos
-- ----------------------------
DROP TABLE IF EXISTS `apuracao_mensal_eventos`;
CREATE TABLE `apuracao_mensal_eventos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `apuracao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `evento_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(8, 2) NOT NULL,
  `metodo` enum('informado','fixo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `condicao` enum('soma','diminui') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `apuracao_mensal_eventos_apuracao_id_foreign`(`apuracao_id`) USING BTREE,
  INDEX `apuracao_mensal_eventos_evento_id_foreign`(`evento_id`) USING BTREE,
  CONSTRAINT `apuracao_mensal_eventos_apuracao_id_foreign` FOREIGN KEY (`apuracao_id`) REFERENCES `apuracao_mensals` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `apuracao_mensal_eventos_evento_id_foreign` FOREIGN KEY (`evento_id`) REFERENCES `evento_salarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for apuracao_mensals
-- ----------------------------
DROP TABLE IF EXISTS `apuracao_mensals`;
CREATE TABLE `apuracao_mensals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NOT NULL,
  `mes` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ano` int(11) NOT NULL,
  `valor_final` decimal(10, 2) NOT NULL,
  `forma_pagamento` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `conta_pagar_id` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `apuracao_mensals_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `apuracao_mensals_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for bairro_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `bairro_deliveries`;
CREATE TABLE `bairro_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_entrega` decimal(10, 2) NOT NULL,
  `bairro_delivery_super` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `bairro_deliveries_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `bairro_deliveries_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for bairro_delivery_masters
-- ----------------------------
DROP TABLE IF EXISTS `bairro_delivery_masters`;
CREATE TABLE `bairro_delivery_masters`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `bairro_delivery_masters_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `bairro_delivery_masters_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for boletos
-- ----------------------------
DROP TABLE IF EXISTS `boletos`;
CREATE TABLE `boletos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `conta_boleto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `conta_receber_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_documento` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `carteira` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `convenio` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `vencimento` date NOT NULL,
  `valor` decimal(12, 2) NOT NULL,
  `instrucoes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `linha_digitavel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_arquivo` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `juros` decimal(10, 2) NULL DEFAULT NULL,
  `multa` decimal(10, 2) NULL DEFAULT NULL,
  `juros_apos` int(11) NULL DEFAULT NULL,
  `tipo` enum('Cnab400','Cnab240') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `usar_logo` tinyint(1) NOT NULL DEFAULT 0,
  `posto` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_cliente` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_tarifa` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `boletos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `boletos_conta_boleto_id_foreign`(`conta_boleto_id`) USING BTREE,
  INDEX `boletos_conta_receber_id_foreign`(`conta_receber_id`) USING BTREE,
  CONSTRAINT `boletos_conta_boleto_id_foreign` FOREIGN KEY (`conta_boleto_id`) REFERENCES `conta_boletos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `boletos_conta_receber_id_foreign` FOREIGN KEY (`conta_receber_id`) REFERENCES `conta_recebers` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `boletos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for c_te_descargas
-- ----------------------------
DROP TABLE IF EXISTS `c_te_descargas`;
CREATE TABLE `c_te_descargas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `info_id` bigint(20) UNSIGNED NOT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `seg_cod_barras` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `c_te_descargas_info_id_foreign`(`info_id`) USING BTREE,
  CONSTRAINT `c_te_descargas_info_id_foreign` FOREIGN KEY (`info_id`) REFERENCES `info_descargas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for caixas
-- ----------------------------
DROP TABLE IF EXISTS `caixas`;
CREATE TABLE `caixas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor_abertura` decimal(10, 2) NOT NULL,
  `conta_empresa_id` int(11) NULL DEFAULT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `data_fechamento` timestamp NULL DEFAULT NULL,
  `valor_fechamento` decimal(10, 2) NULL DEFAULT NULL,
  `valor_dinheiro` decimal(10, 2) NULL DEFAULT NULL,
  `valor_cheque` decimal(10, 2) NULL DEFAULT NULL,
  `valor_outros` decimal(10, 2) NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `caixas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `caixas_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `caixas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `caixas_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 189 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for carrinho_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `carrinho_deliveries`;
CREATE TABLE `carrinho_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `endereco_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estado` enum('pendente','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_total` decimal(10, 2) NOT NULL,
  `valor_desconto` decimal(10, 2) NOT NULL,
  `cupom` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `fone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_frete` decimal(10, 2) NOT NULL,
  `session_cart_delivery` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `troco_para` decimal(10, 2) NULL DEFAULT NULL,
  `tipo_entrega` enum('delivery','retirada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `funcionario_id_agendamento` int(11) NULL DEFAULT NULL,
  `inicio_agendamento` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `fim_agendamento` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_agendamento` date NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `carrinho_deliveries_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `carrinho_deliveries_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `carrinho_deliveries_endereco_id_foreign`(`endereco_id`) USING BTREE,
  CONSTRAINT `carrinho_deliveries_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `carrinho_deliveries_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `carrinho_deliveries_endereco_id_foreign` FOREIGN KEY (`endereco_id`) REFERENCES `endereco_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for carrinhos
-- ----------------------------
DROP TABLE IF EXISTS `carrinhos`;
CREATE TABLE `carrinhos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `endereco_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estado` enum('pendente','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_total` decimal(10, 2) NOT NULL,
  `tipo_frete` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_frete` decimal(10, 2) NOT NULL,
  `cep` decimal(9, 2) NULL DEFAULT NULL,
  `session_cart` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `carrinhos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `carrinhos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `carrinhos_endereco_id_foreign`(`endereco_id`) USING BTREE,
  CONSTRAINT `carrinhos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `carrinhos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `carrinhos_endereco_id_foreign` FOREIGN KEY (`endereco_id`) REFERENCES `endereco_ecommerces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for carrossel_cardapios
-- ----------------------------
DROP TABLE IF EXISTS `carrossel_cardapios`;
CREATE TABLE `carrossel_cardapios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_en` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_es` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor` decimal(12, 4) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `carrossel_cardapios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `carrossel_cardapios_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `carrossel_cardapios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `carrossel_cardapios_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cash_back_clientes
-- ----------------------------
DROP TABLE IF EXISTS `cash_back_clientes`;
CREATE TABLE `cash_back_clientes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `tipo` enum('venda','pdv') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `venda_id` int(11) NOT NULL,
  `valor_venda` decimal(16, 7) NOT NULL,
  `valor_credito` decimal(16, 7) NOT NULL,
  `valor_percentual` decimal(5, 2) NOT NULL,
  `data_expiracao` date NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cash_back_clientes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `cash_back_clientes_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `cash_back_clientes_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cash_back_clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cash_back_configs
-- ----------------------------
DROP TABLE IF EXISTS `cash_back_configs`;
CREATE TABLE `cash_back_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `valor_percentual` decimal(5, 2) NOT NULL,
  `dias_expiracao` int(11) NOT NULL,
  `valor_minimo_venda` decimal(10, 2) NOT NULL,
  `percentual_maximo_venda` decimal(10, 2) NOT NULL,
  `mensagem_padrao_whatsapp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cash_back_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `cash_back_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_acomodacaos
-- ----------------------------
DROP TABLE IF EXISTS `categoria_acomodacaos`;
CREATE TABLE `categoria_acomodacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_acomodacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `categoria_acomodacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_contas
-- ----------------------------
DROP TABLE IF EXISTS `categoria_contas`;
CREATE TABLE `categoria_contas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cor` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `icone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'pagar, receber, ambos',
  `pai_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_contas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `categoria_contas_pai_id_foreign`(`pai_id`) USING BTREE,
  CONSTRAINT `categoria_contas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `categoria_contas_pai_id_foreign` FOREIGN KEY (`pai_id`) REFERENCES `categoria_contas` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_mercado_livres
-- ----------------------------
DROP TABLE IF EXISTS `categoria_mercado_livres`;
CREATE TABLE `categoria_mercado_livres`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_nuvem_shops
-- ----------------------------
DROP TABLE IF EXISTS `categoria_nuvem_shops`;
CREATE TABLE `categoria_nuvem_shops`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_nuvem_shops_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `categoria_nuvem_shops_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_produtos
-- ----------------------------
DROP TABLE IF EXISTS `categoria_produtos`;
CREATE TABLE `categoria_produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_en` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_es` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cardapio` tinyint(1) NOT NULL DEFAULT 0,
  `delivery` tinyint(1) NOT NULL DEFAULT 0,
  `ecommerce` tinyint(1) NOT NULL DEFAULT 0,
  `reserva` tinyint(1) NOT NULL DEFAULT 0,
  `tipo_pizza` tinyint(1) NOT NULL DEFAULT 0,
  `hash_ecommerce` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `hash_delivery` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `categoria_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `_id_import` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_produtos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `categoria_produtos_categoria_id_foreign`(`categoria_id`) USING BTREE,
  CONSTRAINT `categoria_produtos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categoria_produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `categoria_produtos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 132 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_servicos
-- ----------------------------
DROP TABLE IF EXISTS `categoria_servicos`;
CREATE TABLE `categoria_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `marketplace` tinyint(1) NOT NULL DEFAULT 0,
  `hash_delivery` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_servicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `categoria_servicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categoria_woocommerces
-- ----------------------------
DROP TABLE IF EXISTS `categoria_woocommerces`;
CREATE TABLE `categoria_woocommerces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `categoria_woocommerces_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `categoria_woocommerces_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for centro_custos
-- ----------------------------
DROP TABLE IF EXISTS `centro_custos`;
CREATE TABLE `centro_custos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `pai_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ativo` tinyint(1) NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_centro_custos_empresa`(`empresa_id`) USING BTREE,
  INDEX `fk_centro_custos_pai`(`pai_id`) USING BTREE,
  CONSTRAINT `fk_centro_custos_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT,
  CONSTRAINT `fk_centro_custos_pai` FOREIGN KEY (`pai_id`) REFERENCES `centro_custos` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for chave_nfe_ctes
-- ----------------------------
DROP TABLE IF EXISTS `chave_nfe_ctes`;
CREATE TABLE `chave_nfe_ctes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cte_id` bigint(20) UNSIGNED NOT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `chave_nfe_ctes_cte_id_foreign`(`cte_id`) USING BTREE,
  CONSTRAINT `chave_nfe_ctes_cte_id_foreign` FOREIGN KEY (`cte_id`) REFERENCES `ctes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cidades
-- ----------------------------
DROP TABLE IF EXISTS `cidades`;
CREATE TABLE `cidades`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `codigo` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5571 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ciots
-- ----------------------------
DROP TABLE IF EXISTS `ciots`;
CREATE TABLE `ciots`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mdfe_id` bigint(20) UNSIGNED NOT NULL,
  `cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ciots_mdfe_id_foreign`(`mdfe_id`) USING BTREE,
  CONSTRAINT `ciots_mdfe_id_foreign` FOREIGN KEY (`mdfe_id`) REFERENCES `mdves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `razao_social` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_fantasia` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf_cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `contribuinte` tinyint(1) NOT NULL DEFAULT 0,
  `consumidor_final` tinyint(1) NOT NULL DEFAULT 0,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `token` int(11) NULL DEFAULT NULL,
  `uid` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `senha` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_cashback` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `valor_credito` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `nuvem_shop_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `limite_credito` decimal(10, 2) NULL DEFAULT NULL,
  `lista_preco_id` int(11) NULL DEFAULT NULL,
  `_id_import` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `clientes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `clientes_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `clientes_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 934 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for comissao_vendas
-- ----------------------------
DROP TABLE IF EXISTS `comissao_vendas`;
CREATE TABLE `comissao_vendas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `nfce_id` int(11) NULL DEFAULT NULL,
  `tabela` varchar(14) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `valor_venda` decimal(10, 2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `comissao_vendas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `comissao_vendas_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `comissao_vendas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `comissao_vendas_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for componente_ctes
-- ----------------------------
DROP TABLE IF EXISTS `componente_ctes`;
CREATE TABLE `componente_ctes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cte_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `componente_ctes_cte_id_foreign`(`cte_id`) USING BTREE,
  CONSTRAINT `componente_ctes_cte_id_foreign` FOREIGN KEY (`cte_id`) REFERENCES `ctes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for config_gerals
-- ----------------------------
DROP TABLE IF EXISTS `config_gerals`;
CREATE TABLE `config_gerals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `balanca_valor_peso` enum('peso','valor') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balanca_digito_verificador` int(11) NULL DEFAULT NULL,
  `confirmar_itens_prevenda` tinyint(1) NOT NULL DEFAULT 0,
  `gerenciar_estoque` tinyint(1) NOT NULL DEFAULT 0,
  `agrupar_itens` tinyint(1) NOT NULL DEFAULT 0,
  `notificacoes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `margem_combo` decimal(5, 2) NOT NULL DEFAULT 50.00,
  `percentual_desconto_orcamento` decimal(5, 2) NULL DEFAULT NULL,
  `percentual_lucro_produto` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `tipos_pagamento_pdv` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `senha_manipula_valor` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `abrir_modal_cartao` tinyint(1) NOT NULL DEFAULT 1,
  `tipo_comissao` enum('percentual_vendedor','percentual_margem') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `modelo` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `alerta_sonoro` tinyint(1) NOT NULL DEFAULT 1,
  `cabecalho_pdv` tinyint(1) NOT NULL DEFAULT 1,
  `regime_nfse` int(11) NULL DEFAULT NULL,
  `mercadopago_public_key_pix` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercadopago_access_token_pix` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `definir_vendedor_pdv_off` tinyint(1) NOT NULL DEFAULT 0,
  `acessos_pdv_off` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_menu` enum('vertical','horizontal') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'vertical',
  `largura_cupom` int(11) NOT NULL DEFAULT 72,
  `margem_cupom` int(11) NOT NULL DEFAULT 2,
  `fonte_cupom` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'arial',
  `cupom_imprimir_resumo` tinyint(1) NOT NULL DEFAULT 0,
  `cor_menu` enum('light','brand','dark') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `cor_top_bar` enum('light','brand','dark') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `config_gerals_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `config_gerals_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 17 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for configuracao_agendamentos
-- ----------------------------
DROP TABLE IF EXISTS `configuracao_agendamentos`;
CREATE TABLE `configuracao_agendamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `token_whatsapp` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tempo_descanso_entre_agendamento` int(11) NOT NULL DEFAULT 0,
  `msg_wpp_manha` tinyint(1) NOT NULL DEFAULT 0,
  `msg_wpp_manha_horario` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `msg_wpp_alerta` tinyint(1) NOT NULL DEFAULT 0,
  `msg_wpp_alerta_minutos_antecedencia` int(11) NULL DEFAULT NULL,
  `mensagem_manha` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mensagem_alerta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `configuracao_agendamentos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `configuracao_agendamentos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for configuracao_cardapios
-- ----------------------------
DROP TABLE IF EXISTS `configuracao_cardapios`;
CREATE TABLE `configuracao_cardapios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome_restaurante` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao_restaurante_pt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_restaurante_en` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_restaurante_es` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fav_icon` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefone` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `api_token` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_instagran` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_facebook` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_whatsapp` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `intercionalizar` tinyint(1) NOT NULL DEFAULT 0,
  `valor_pizza` enum('divide','valor_maior') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'divide',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `configuracao_cardapios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `configuracao_cardapios_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `configuracao_cardapios_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `configuracao_cardapios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for configuracao_supers
-- ----------------------------
DROP TABLE IF EXISTS `configuracao_supers`;
CREATE TABLE `configuracao_supers`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cpf_cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `usar_resp_tecnico` tinyint(1) NOT NULL DEFAULT 0,
  `mercadopago_public_key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercadopago_access_token` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `sms_key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_whatsapp` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `usuario_correios` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_acesso_correios` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cartao_postagem_correios` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_correios` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_expira_correios` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dr_correios` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `contrato_correios` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_auth_nfse` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `timeout_nfe` int(11) NOT NULL DEFAULT 8,
  `timeout_nfce` int(11) NOT NULL DEFAULT 8,
  `timeout_cte` int(11) NOT NULL DEFAULT 8,
  `timeout_mdfe` int(11) NOT NULL DEFAULT 8,
  `token_api` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_integra_notas` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `banco_plano` enum('mercado_pago','asaas') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'mercado_pago',
  `asaas_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for configuracoes_financeiras
-- ----------------------------
DROP TABLE IF EXISTS `configuracoes_financeiras`;
CREATE TABLE `configuracoes_financeiras`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `aprovacao_pagamento` tinyint(1) NULL DEFAULT 0,
  `aprovacao_recebimento` tinyint(1) NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `juros_diario` decimal(5, 3) NOT NULL DEFAULT 0.033,
  `multa_atraso` decimal(5, 2) NOT NULL DEFAULT 2.00,
  `carencia_dias` int(11) NOT NULL DEFAULT 0,
  `prazo_padrao_dias` int(11) NOT NULL DEFAULT 30,
  `notificar_vencimento` tinyint(1) NOT NULL DEFAULT 1,
  `dias_notificacao_previa` int(11) NOT NULL DEFAULT 3,
  `texto_padrao_recibo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `instrucoes_padrao_boleto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for consumo_reservas
-- ----------------------------
DROP TABLE IF EXISTS `consumo_reservas`;
CREATE TABLE `consumo_reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reserva_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `frigobar` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `consumo_reservas_reserva_id_foreign`(`reserva_id`) USING BTREE,
  INDEX `consumo_reservas_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `consumo_reservas_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `consumo_reservas_reserva_id_foreign` FOREIGN KEY (`reserva_id`) REFERENCES `reservas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for conta_boletos
-- ----------------------------
DROP TABLE IF EXISTS `conta_boletos`;
CREATE TABLE `conta_boletos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `banco` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `agencia` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `conta` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `titular` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `padrao` tinyint(1) NOT NULL DEFAULT 0,
  `usar_logo` tinyint(1) NOT NULL DEFAULT 0,
  `documento` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `carteira` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `convenio` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `posto` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `sequencial_remessa` int(11) NOT NULL DEFAULT 1,
  `juros` decimal(10, 2) NULL DEFAULT NULL,
  `multa` decimal(10, 2) NULL DEFAULT NULL,
  `juros_apos` int(11) NULL DEFAULT NULL,
  `tipo` enum('Cnab400','Cnab240') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `conta_boletos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `conta_boletos_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `conta_boletos_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_boletos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for conta_empresas
-- ----------------------------
DROP TABLE IF EXISTS `conta_empresas`;
CREATE TABLE `conta_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `banco` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `agencia` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `conta` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `plano_conta_id` int(11) NULL DEFAULT NULL,
  `saldo` decimal(16, 2) NULL DEFAULT NULL,
  `saldo_inicial` decimal(16, 2) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `conta_empresas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `conta_empresas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for conta_pagars
-- ----------------------------
DROP TABLE IF EXISTS `conta_pagars`;
CREATE TABLE `conta_pagars`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `arquivo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_integral` decimal(16, 7) NOT NULL,
  `valor_pago` decimal(16, 7) NULL DEFAULT NULL,
  `data_vencimento` date NOT NULL,
  `data_pagamento` date NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `aprovado_por` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `aprovado_em` datetime NULL DEFAULT NULL,
  `categoria_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `prioridade` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nivel_aprovacao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_aprovacao` datetime NULL DEFAULT NULL,
  `recorrente` tinyint(1) NOT NULL DEFAULT 0,
  `periodicidade` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `total_parcelas` int(11) NULL DEFAULT NULL,
  `parcela_atual` int(11) NULL DEFAULT NULL,
  `parent_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `centro_custo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `conta_pagars_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `conta_pagars_nfe_id_foreign`(`nfe_id`) USING BTREE,
  INDEX `conta_pagars_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  INDEX `conta_pagars_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `conta_pagars_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_pagars_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_pagars_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_pagars_nfe_id_foreign` FOREIGN KEY (`nfe_id`) REFERENCES `nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 239 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for conta_receber_historicos
-- ----------------------------
DROP TABLE IF EXISTS `conta_receber_historicos`;
CREATE TABLE `conta_receber_historicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conta_receber_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `desconto` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `juros` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `multa` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `tipo_movimento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_pagamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_movimento` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_conta_receber_historicos_conta_receber_id`(`conta_receber_id`) USING BTREE,
  INDEX `fk_conta_receber_historicos_usuario_id`(`usuario_id`) USING BTREE,
  CONSTRAINT `fk_conta_receber_historicos_conta_receber_id` FOREIGN KEY (`conta_receber_id`) REFERENCES `conta_recebers` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `fk_conta_receber_historicos_usuario_id` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 558 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for conta_recebers
-- ----------------------------
DROP TABLE IF EXISTS `conta_recebers`;
CREATE TABLE `conta_recebers`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nfce_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `arquivo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_integral` decimal(16, 7) NOT NULL,
  `valor_recebido` decimal(16, 7) NULL DEFAULT NULL,
  `desconto_aplicado` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `data_vencimento` date NOT NULL,
  `data_recebimento` date NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `aprovado_por` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `aprovado_em` datetime NULL DEFAULT NULL,
  `alocacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_reagendamento` date NULL DEFAULT NULL,
  `valor_reagendamento` decimal(10, 2) NULL DEFAULT NULL,
  `recorrente` tinyint(1) NOT NULL DEFAULT 0,
  `periodicidade` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `total_parcelas` int(11) NULL DEFAULT NULL,
  `parcela_atual` int(11) NULL DEFAULT NULL,
  `parent_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `centro_custo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `data_vencimento_original` date NULL DEFAULT NULL,
  `data_nova_vencimento` date NULL DEFAULT NULL,
  `juros_aplicados` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `multa_aplicada` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `categoria_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `conta_recebers_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `conta_recebers_nfe_id_foreign`(`nfe_id`) USING BTREE,
  INDEX `conta_recebers_nfce_id_foreign`(`nfce_id`) USING BTREE,
  INDEX `conta_recebers_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `conta_recebers_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `conta_recebers_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_recebers_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_recebers_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_recebers_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `conta_recebers_nfe_id_foreign` FOREIGN KEY (`nfe_id`) REFERENCES `nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1325 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for contador_empresas
-- ----------------------------
DROP TABLE IF EXISTS `contador_empresas`;
CREATE TABLE `contador_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `contador_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `contador_empresas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `contador_empresas_contador_id_foreign`(`contador_id`) USING BTREE,
  CONSTRAINT `contador_empresas_contador_id_foreign` FOREIGN KEY (`contador_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `contador_empresas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for contigencias
-- ----------------------------
DROP TABLE IF EXISTS `contigencias`;
CREATE TABLE `contigencias`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `tipo` enum('SVCAN','SVCRS','OFFLINE') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `motivo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_retorno` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` enum('NFe','NFCe','CTe','MDFe') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `contigencias_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `contigencias_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for convenios
-- ----------------------------
DROP TABLE IF EXISTS `convenios`;
CREATE TABLE `convenios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `convenios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `convenios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cotacaos
-- ----------------------------
DROP TABLE IF EXISTS `cotacaos`;
CREATE TABLE `cotacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NOT NULL,
  `responsavel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `hash_link` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referencia` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao_resposta` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `valor_total` decimal(10, 2) NULL DEFAULT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `estado` enum('nova','respondida','aprovada','rejeitada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `escolhida` tinyint(1) NOT NULL DEFAULT 0,
  `data_resposta` timestamp NULL DEFAULT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `valor_frete` decimal(10, 2) NULL DEFAULT NULL,
  `observacao_frete` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `previsao_entrega` date NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cotacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `cotacaos_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  CONSTRAINT `cotacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cotacaos_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for credito_clientes
-- ----------------------------
DROP TABLE IF EXISTS `credito_clientes`;
CREATE TABLE `credito_clientes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(12, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `credito_clientes_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `credito_clientes_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for crm_anotacao_notas
-- ----------------------------
DROP TABLE IF EXISTS `crm_anotacao_notas`;
CREATE TABLE `crm_anotacao_notas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `crm_anotacao_id` bigint(20) UNSIGNED NOT NULL,
  `nota` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `crm_anotacao_notas_crm_anotacao_id_foreign`(`crm_anotacao_id`) USING BTREE,
  CONSTRAINT `crm_anotacao_notas_crm_anotacao_id_foreign` FOREIGN KEY (`crm_anotacao_id`) REFERENCES `crm_anotacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for crm_anotacaos
-- ----------------------------
DROP TABLE IF EXISTS `crm_anotacaos`;
CREATE TABLE `crm_anotacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` int(11) NULL DEFAULT NULL,
  `registro_id` int(11) NULL DEFAULT NULL,
  `tipo_registro` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` enum('positivo','bom','negativo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `conclusao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `assunto` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alerta` tinyint(1) NOT NULL,
  `data_retorno` date NULL DEFAULT NULL,
  `data_entrega` date NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `crm_anotacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `crm_anotacaos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `crm_anotacaos_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  CONSTRAINT `crm_anotacaos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `crm_anotacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `crm_anotacaos_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cte_os
-- ----------------------------
DROP TABLE IF EXISTS `cte_os`;
CREATE TABLE `cte_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `emitente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tomador_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `municipio_envio` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `municipio_inicio` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `municipio_fim` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `veiculo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `modal` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cst` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00',
  `perc_icms` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `valor_transporte` decimal(10, 2) NOT NULL,
  `valor_receber` decimal(10, 2) NOT NULL,
  `descricao_servico` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `quantidade_carga` decimal(12, 4) NOT NULL,
  `natureza_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tomador` int(11) NOT NULL,
  `sequencia_cce` int(11) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_emissao` int(11) NOT NULL DEFAULT 0,
  `chave` varchar(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado_emissao` enum('novo','aprovado','cancelado','rejeitado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_emissao` timestamp NULL DEFAULT NULL,
  `data_viagem` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `horario_viagem` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `recibo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cte_os_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `cte_os_emitente_id_foreign`(`emitente_id`) USING BTREE,
  INDEX `cte_os_tomador_id_foreign`(`tomador_id`) USING BTREE,
  INDEX `cte_os_municipio_envio_foreign`(`municipio_envio`) USING BTREE,
  INDEX `cte_os_municipio_inicio_foreign`(`municipio_inicio`) USING BTREE,
  INDEX `cte_os_municipio_fim_foreign`(`municipio_fim`) USING BTREE,
  INDEX `cte_os_veiculo_id_foreign`(`veiculo_id`) USING BTREE,
  INDEX `cte_os_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `cte_os_natureza_id_foreign`(`natureza_id`) USING BTREE,
  CONSTRAINT `cte_os_emitente_id_foreign` FOREIGN KEY (`emitente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_municipio_envio_foreign` FOREIGN KEY (`municipio_envio`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_municipio_fim_foreign` FOREIGN KEY (`municipio_fim`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_municipio_inicio_foreign` FOREIGN KEY (`municipio_inicio`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_tomador_id_foreign` FOREIGN KEY (`tomador_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cte_os_veiculo_id_foreign` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ctes
-- ----------------------------
DROP TABLE IF EXISTS `ctes`;
CREATE TABLE `ctes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `remetente_id` bigint(20) UNSIGNED NOT NULL,
  `destinatario_id` bigint(20) UNSIGNED NOT NULL,
  `recebedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `expedidor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `veiculo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `natureza_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tomador` int(11) NOT NULL,
  `municipio_envio` bigint(20) UNSIGNED NOT NULL,
  `municipio_inicio` bigint(20) UNSIGNED NOT NULL,
  `municipio_fim` bigint(20) UNSIGNED NOT NULL,
  `logradouro_tomador` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_tomador` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro_tomador` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep_tomador` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `municipio_tomador` bigint(20) UNSIGNED NOT NULL,
  `valor_transporte` decimal(10, 2) NOT NULL,
  `valor_receber` decimal(10, 2) NOT NULL,
  `valor_carga` decimal(10, 2) NOT NULL,
  `produto_predominante` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_prevista_entrega` date NOT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `sequencia_cce` int(11) NOT NULL DEFAULT 0,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `recibo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_serie` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` int(11) NOT NULL,
  `estado` enum('novo','rejeitado','cancelado','aprovado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `motivo_rejeicao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `retira` tinyint(1) NOT NULL,
  `detalhes_retira` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `modal` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ambiente` int(11) NOT NULL,
  `tpDoc` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descOutros` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nDoc` int(11) NOT NULL,
  `vDocFisc` decimal(10, 2) NOT NULL,
  `globalizado` int(11) NOT NULL,
  `cst` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00',
  `perc_icms` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_red_bc` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `status_pagamento` tinyint(1) NOT NULL DEFAULT 0,
  `cfop` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `api` tinyint(1) NOT NULL DEFAULT 0,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ctes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `ctes_remetente_id_foreign`(`remetente_id`) USING BTREE,
  INDEX `ctes_destinatario_id_foreign`(`destinatario_id`) USING BTREE,
  INDEX `ctes_recebedor_id_foreign`(`recebedor_id`) USING BTREE,
  INDEX `ctes_expedidor_id_foreign`(`expedidor_id`) USING BTREE,
  INDEX `ctes_veiculo_id_foreign`(`veiculo_id`) USING BTREE,
  INDEX `ctes_natureza_id_foreign`(`natureza_id`) USING BTREE,
  INDEX `ctes_municipio_envio_foreign`(`municipio_envio`) USING BTREE,
  INDEX `ctes_municipio_inicio_foreign`(`municipio_inicio`) USING BTREE,
  INDEX `ctes_municipio_fim_foreign`(`municipio_fim`) USING BTREE,
  INDEX `ctes_municipio_tomador_foreign`(`municipio_tomador`) USING BTREE,
  CONSTRAINT `ctes_destinatario_id_foreign` FOREIGN KEY (`destinatario_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_expedidor_id_foreign` FOREIGN KEY (`expedidor_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_municipio_envio_foreign` FOREIGN KEY (`municipio_envio`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_municipio_fim_foreign` FOREIGN KEY (`municipio_fim`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_municipio_inicio_foreign` FOREIGN KEY (`municipio_inicio`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_municipio_tomador_foreign` FOREIGN KEY (`municipio_tomador`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_recebedor_id_foreign` FOREIGN KEY (`recebedor_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_remetente_id_foreign` FOREIGN KEY (`remetente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ctes_veiculo_id_foreign` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cupom_desconto_clientes
-- ----------------------------
DROP TABLE IF EXISTS `cupom_desconto_clientes`;
CREATE TABLE `cupom_desconto_clientes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cupom_id` bigint(20) UNSIGNED NOT NULL,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cupom_desconto_clientes_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `cupom_desconto_clientes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `cupom_desconto_clientes_cupom_id_foreign`(`cupom_id`) USING BTREE,
  INDEX `cupom_desconto_clientes_pedido_id_foreign`(`pedido_id`) USING BTREE,
  CONSTRAINT `cupom_desconto_clientes_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cupom_desconto_clientes_cupom_id_foreign` FOREIGN KEY (`cupom_id`) REFERENCES `cupom_descontos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cupom_desconto_clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cupom_desconto_clientes_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedido_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cupom_descontos
-- ----------------------------
DROP TABLE IF EXISTS `cupom_descontos`;
CREATE TABLE `cupom_descontos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_desconto` enum('valor','percentual') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor` decimal(10, 4) NOT NULL,
  `valor_minimo_pedido` decimal(12, 4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `expiracao` date NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cupom_descontos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `cupom_descontos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `cupom_descontos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `cupom_descontos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for despesa_fretes
-- ----------------------------
DROP TABLE IF EXISTS `despesa_fretes`;
CREATE TABLE `despesa_fretes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `frete_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_despesa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `conta_pagar_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `despesa_fretes_frete_id_foreign`(`frete_id`) USING BTREE,
  INDEX `despesa_fretes_tipo_despesa_id_foreign`(`tipo_despesa_id`) USING BTREE,
  INDEX `despesa_fretes_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  CONSTRAINT `despesa_fretes_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `despesa_fretes_frete_id_foreign` FOREIGN KEY (`frete_id`) REFERENCES `fretes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `despesa_fretes_tipo_despesa_id_foreign` FOREIGN KEY (`tipo_despesa_id`) REFERENCES `tipo_despesa_fretes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for destaque_market_places
-- ----------------------------
DROP TABLE IF EXISTS `destaque_market_places`;
CREATE TABLE `destaque_market_places`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor` decimal(12, 4) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `destaque_market_places_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `destaque_market_places_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `destaque_market_places_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `destaque_market_places_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `destaque_market_places_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `destaque_market_places_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for devolucoes
-- ----------------------------
DROP TABLE IF EXISTS `devolucoes`;
CREATE TABLE `devolucoes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `venda_id` bigint(20) UNSIGNED NOT NULL,
  `tipo_venda` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_total` decimal(10, 2) NOT NULL,
  `tipo_pagamento` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_devolucao` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_troca` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'True para troca, False para devolução simples',
  `valor_diferenca` decimal(10, 2) NULL DEFAULT NULL COMMENT 'Diferença entre valores na troca. Positivo: cliente recebe, Negativo: cliente paga',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `devolucoes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `devolucoes_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `devolucoes_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `devolucoes_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `devolucoes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `devolucoes_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for dia_semanas
-- ----------------------------
DROP TABLE IF EXISTS `dia_semanas`;
CREATE TABLE `dia_semanas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `dia` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `dia_semanas_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `dia_semanas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `dia_semanas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `dia_semanas_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for difals
-- ----------------------------
DROP TABLE IF EXISTS `difals`;
CREATE TABLE `difals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pICMSUFDest` decimal(6, 2) NOT NULL,
  `pICMSInter` decimal(6, 2) NOT NULL,
  `pICMSInterPart` decimal(6, 2) NOT NULL,
  `pFCPUFDest` decimal(6, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `difals_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `difals_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ecommerce_configs
-- ----------------------------
DROP TABLE IF EXISTS `ecommerce_configs`;
CREATE TABLE `ecommerce_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `loja_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao_breve` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `telefone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_facebook` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_whatsapp` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_instagram` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `frete_gratis_valor` decimal(10, 2) NULL DEFAULT NULL,
  `mercadopago_public_key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mercadopago_access_token` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitar_retirada` tinyint(1) NOT NULL DEFAULT 0,
  `notificacao_novo_pedido` tinyint(1) NOT NULL DEFAULT 1,
  `desconto_padrao_boleto` decimal(4, 2) NULL DEFAULT NULL,
  `desconto_padrao_pix` decimal(4, 2) NULL DEFAULT NULL,
  `desconto_padrao_cartao` decimal(4, 2) NULL DEFAULT NULL,
  `tipos_pagamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `politica_privacidade` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `termos_condicoes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `dados_deposito` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ecommerce_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `ecommerce_configs_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `ecommerce_configs_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ecommerce_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for email_configs
-- ----------------------------
DROP TABLE IF EXISTS `email_configs`;
CREATE TABLE `email_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `host` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `senha` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `porta` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cripitografia` enum('ssl','tls') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `smtp_auth` tinyint(1) NOT NULL,
  `smtp_debug` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `email_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `email_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for empresas
-- ----------------------------
DROP TABLE IF EXISTS `empresas`;
CREATE TABLE `empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_fantasia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `aut_xml` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `celular` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `arquivo` blob NULL DEFAULT NULL,
  `senha` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `complemento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `natureza_id_pdv` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfe_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfe_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_nfe` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfce_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfce_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_nfce` int(11) NULL DEFAULT NULL,
  `numero_ultima_cte_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_cte_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_cte` int(11) NULL DEFAULT NULL,
  `numero_ultima_mdfe_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_mdfe_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_mdfe` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfse` int(11) NULL DEFAULT NULL,
  `numero_serie_nfse` int(11) NULL DEFAULT NULL,
  `csc` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `csc_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ambiente` int(11) NOT NULL,
  `tributacao` enum('MEI','Simples Nacional','Regime Normal','Simples Nacional, excesso sublimite de receita bruta') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_nfse` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tipo_contador` tinyint(1) NOT NULL DEFAULT 0,
  `limite_cadastro_empresas` int(11) NOT NULL DEFAULT 0,
  `percentual_comissao` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_ap_cred` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `empresa_selecionada` int(11) NULL DEFAULT NULL,
  `exclusao_icms_pis_cofins` tinyint(1) NOT NULL DEFAULT 0,
  `observacao_padrao_nfe` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao_padrao_nfce` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mensagem_aproveitamento_credito` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `empresas_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `empresas_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 22 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for endereco_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `endereco_deliveries`;
CREATE TABLE `endereco_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `bairro_id` bigint(20) UNSIGNED NOT NULL,
  `rua` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referencia` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `latitude` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `longitude` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('casa','trabalho') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `padrao` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `endereco_deliveries_cidade_id_foreign`(`cidade_id`) USING BTREE,
  INDEX `endereco_deliveries_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `endereco_deliveries_bairro_id_foreign`(`bairro_id`) USING BTREE,
  CONSTRAINT `endereco_deliveries_bairro_id_foreign` FOREIGN KEY (`bairro_id`) REFERENCES `bairro_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `endereco_deliveries_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `endereco_deliveries_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for endereco_ecommerces
-- ----------------------------
DROP TABLE IF EXISTS `endereco_ecommerces`;
CREATE TABLE `endereco_ecommerces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `rua` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referencia` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `padrao` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `endereco_ecommerces_cidade_id_foreign`(`cidade_id`) USING BTREE,
  INDEX `endereco_ecommerces_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `endereco_ecommerces_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `endereco_ecommerces_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for escritorio_contabils
-- ----------------------------
DROP TABLE IF EXISTS `escritorio_contabils`;
CREATE TABLE `escritorio_contabils`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `razao_social` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_fantasia` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnpj` varchar(19) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `crc` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `token_sieg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `envio_xml_automatico` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `escritorio_contabils_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `escritorio_contabils_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `escritorio_contabils_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `escritorio_contabils_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for estoques
-- ----------------------------
DROP TABLE IF EXISTS `estoques`;
CREATE TABLE `estoques`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(14, 4) NOT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `estoques_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `estoques_produto_variacao_id_foreign`(`produto_variacao_id`) USING BTREE,
  CONSTRAINT `estoques_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `estoques_produto_variacao_id_foreign` FOREIGN KEY (`produto_variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2080 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for evento_salarios
-- ----------------------------
DROP TABLE IF EXISTS `evento_salarios`;
CREATE TABLE `evento_salarios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('semanal','mensal','anual') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` enum('informado','fixo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `condicao` enum('soma','diminui') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_valor` enum('fixo','percentual') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `evento_salarios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `evento_salarios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `failed_jobs_uuid_unique`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_contas_recebers
-- ----------------------------
DROP TABLE IF EXISTS `fatura_contas_recebers`;
CREATE TABLE `fatura_contas_recebers`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conta_receber_id` bigint(20) UNSIGNED NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `tipo_pagamento` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '01-Dinheiro, 03-Cartão Crédito, etc...',
  `valor` decimal(10, 2) NOT NULL,
  `data_vencimento` date NULL DEFAULT NULL,
  `obs` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `conta_receber_id`(`conta_receber_id`) USING BTREE,
  INDEX `empresa_id`(`empresa_id`) USING BTREE,
  CONSTRAINT `fatura_contas_recebers_conta_receber_id_foreign` FOREIGN KEY (`conta_receber_id`) REFERENCES `conta_recebers` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `fatura_contas_recebers_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 494 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_cotacaos
-- ----------------------------
DROP TABLE IF EXISTS `fatura_cotacaos`;
CREATE TABLE `fatura_cotacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cotacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_vencimento` date NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fatura_cotacaos_cotacao_id_foreign`(`cotacao_id`) USING BTREE,
  CONSTRAINT `fatura_cotacaos_cotacao_id_foreign` FOREIGN KEY (`cotacao_id`) REFERENCES `cotacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_nfces
-- ----------------------------
DROP TABLE IF EXISTS `fatura_nfces`;
CREATE TABLE `fatura_nfces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfce_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_vencimento` date NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `taxa_percentual` decimal(10, 2) NULL DEFAULT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fatura_nfces_nfce_id_foreign`(`nfce_id`) USING BTREE,
  CONSTRAINT `fatura_nfces_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3257 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_nves
-- ----------------------------
DROP TABLE IF EXISTS `fatura_nves`;
CREATE TABLE `fatura_nves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_vencimento` date NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `taxa_percentual` decimal(10, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fatura_nves_nfe_id_foreign`(`nfe_id`) USING BTREE,
  CONSTRAINT `fatura_nves_nfe_id_foreign` FOREIGN KEY (`nfe_id`) REFERENCES `nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 268 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_pre_vendas
-- ----------------------------
DROP TABLE IF EXISTS `fatura_pre_vendas`;
CREATE TABLE `fatura_pre_vendas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pre_venda_id` bigint(20) UNSIGNED NOT NULL,
  `valor_parcela` decimal(16, 7) NOT NULL,
  `tipo_pagamento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `vencimento` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fatura_pre_vendas_pre_venda_id_foreign`(`pre_venda_id`) USING BTREE,
  CONSTRAINT `fatura_pre_vendas_pre_venda_id_foreign` FOREIGN KEY (`pre_venda_id`) REFERENCES `pre_vendas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fatura_reservas
-- ----------------------------
DROP TABLE IF EXISTS `fatura_reservas`;
CREATE TABLE `fatura_reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reserva_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_vencimento` date NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fatura_reservas_reserva_id_foreign`(`reserva_id`) USING BTREE,
  CONSTRAINT `fatura_reservas_reserva_id_foreign` FOREIGN KEY (`reserva_id`) REFERENCES `reservas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for financeiro_contadors
-- ----------------------------
DROP TABLE IF EXISTS `financeiro_contadors`;
CREATE TABLE `financeiro_contadors`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `contador_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `percentual_comissao` decimal(5, 2) NOT NULL,
  `valor_comissao` decimal(10, 2) NOT NULL,
  `total_venda` decimal(10, 2) NOT NULL,
  `mes` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ano` int(11) NOT NULL,
  `tipo_pagamento` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status_pagamento` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `financeiro_contadors_contador_id_foreign`(`contador_id`) USING BTREE,
  CONSTRAINT `financeiro_contadors_contador_id_foreign` FOREIGN KEY (`contador_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for financeiro_planos
-- ----------------------------
DROP TABLE IF EXISTS `financeiro_planos`;
CREATE TABLE `financeiro_planos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `revenda_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `plano_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `valor_repasse` decimal(10, 2) NULL DEFAULT NULL,
  `tipo_pagamento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_pagamento` enum('pendente','recebido','cancelado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `plano_empresa_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `financeiro_planos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `financeiro_planos_plano_id_foreign`(`plano_id`) USING BTREE,
  INDEX `fk_financeiro_planos_revenda_id`(`revenda_id`) USING BTREE,
  CONSTRAINT `financeiro_planos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `financeiro_planos_plano_id_foreign` FOREIGN KEY (`plano_id`) REFERENCES `planos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_financeiro_planos_revenda_id` FOREIGN KEY (`revenda_id`) REFERENCES `revendas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for formato_armacao_oticas
-- ----------------------------
DROP TABLE IF EXISTS `formato_armacao_oticas`;
CREATE TABLE `formato_armacao_oticas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `formato_armacao_oticas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `formato_armacao_oticas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fornecedors
-- ----------------------------
DROP TABLE IF EXISTS `fornecedors`;
CREATE TABLE `fornecedors`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `razao_social` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_fantasia` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpf_cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `contribuinte` tinyint(1) NOT NULL DEFAULT 0,
  `consumidor_final` tinyint(1) NOT NULL DEFAULT 0,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `_id_import` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fornecedors_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `fornecedors_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `fornecedors_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fornecedors_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 84 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for frete_anexos
-- ----------------------------
DROP TABLE IF EXISTS `frete_anexos`;
CREATE TABLE `frete_anexos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `frete_id` bigint(20) UNSIGNED NOT NULL,
  `arquivo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `frete_anexos_frete_id_foreign`(`frete_id`) USING BTREE,
  CONSTRAINT `frete_anexos_frete_id_foreign` FOREIGN KEY (`frete_id`) REFERENCES `fretes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fretes
-- ----------------------------
DROP TABLE IF EXISTS `fretes`;
CREATE TABLE `fretes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `veiculo_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `estado` enum('em_carregamento','em_viagem','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `total` decimal(12, 2) NOT NULL,
  `total_despesa` decimal(12, 2) NULL DEFAULT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(10, 2) NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `conta_receber_id` int(11) NULL DEFAULT NULL,
  `cidade_carregamento` bigint(20) UNSIGNED NOT NULL,
  `cidade_descarregamento` bigint(20) UNSIGNED NOT NULL,
  `distancia_km` decimal(10, 2) NULL DEFAULT NULL,
  `data_inicio` date NULL DEFAULT NULL,
  `data_fim` date NULL DEFAULT NULL,
  `horario_inicio` time NULL DEFAULT NULL,
  `horario_fim` time NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fretes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `fretes_veiculo_id_foreign`(`veiculo_id`) USING BTREE,
  INDEX `fretes_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `fretes_cidade_carregamento_foreign`(`cidade_carregamento`) USING BTREE,
  INDEX `fretes_cidade_descarregamento_foreign`(`cidade_descarregamento`) USING BTREE,
  CONSTRAINT `fretes_cidade_carregamento_foreign` FOREIGN KEY (`cidade_carregamento`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fretes_cidade_descarregamento_foreign` FOREIGN KEY (`cidade_descarregamento`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fretes_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fretes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fretes_veiculo_id_foreign` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for frigobars
-- ----------------------------
DROP TABLE IF EXISTS `frigobars`;
CREATE TABLE `frigobars`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `acomodacao_id` bigint(20) UNSIGNED NOT NULL,
  `modelo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `frigobars_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `frigobars_acomodacao_id_foreign`(`acomodacao_id`) USING BTREE,
  CONSTRAINT `frigobars_acomodacao_id_foreign` FOREIGN KEY (`acomodacao_id`) REFERENCES `acomodacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `frigobars_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionamento_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `funcionamento_deliveries`;
CREATE TABLE `funcionamento_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `inicio` time NOT NULL,
  `fim` time NOT NULL,
  `dia` enum('segunda','terca','quarta','quinta','sexta','sabado','domingo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionamento_deliveries_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `funcionamento_deliveries_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionamentos
-- ----------------------------
DROP TABLE IF EXISTS `funcionamentos`;
CREATE TABLE `funcionamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `inicio` time NOT NULL,
  `fim` time NOT NULL,
  `dia_id` enum('segunda','terca','quarta','quinta','sexta','sabado','domingo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionamentos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `funcionamentos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionario_eventos
-- ----------------------------
DROP TABLE IF EXISTS `funcionario_eventos`;
CREATE TABLE `funcionario_eventos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NOT NULL,
  `evento_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `condicao` enum('soma','diminui') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` enum('informado','fixo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionario_eventos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `funcionario_eventos_evento_id_foreign`(`evento_id`) USING BTREE,
  CONSTRAINT `funcionario_eventos_evento_id_foreign` FOREIGN KEY (`evento_id`) REFERENCES `evento_salarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionario_eventos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionario_os
-- ----------------------------
DROP TABLE IF EXISTS `funcionario_os`;
CREATE TABLE `funcionario_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ordem_servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionario_os_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `funcionario_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  INDEX `funcionario_os_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `funcionario_os_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionario_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionario_os_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionario_servicos
-- ----------------------------
DROP TABLE IF EXISTS `funcionario_servicos`;
CREATE TABLE `funcionario_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionario_servicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `funcionario_servicos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `funcionario_servicos_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `funcionario_servicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionario_servicos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionario_servicos_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for funcionarios
-- ----------------------------
DROP TABLE IF EXISTS `funcionarios`;
CREATE TABLE `funcionarios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpf_cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `comissao` decimal(10, 2) NULL DEFAULT NULL,
  `salario` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `codigo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `funcionarios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `funcionarios_cidade_id_foreign`(`cidade_id`) USING BTREE,
  INDEX `funcionarios_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `funcionarios_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionarios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `funcionarios_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for galeria_produtos
-- ----------------------------
DROP TABLE IF EXISTS `galeria_produtos`;
CREATE TABLE `galeria_produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `galeria_produtos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `galeria_produtos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for hospede_reservas
-- ----------------------------
DROP TABLE IF EXISTS `hospede_reservas`;
CREATE TABLE `hospede_reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reserva_id` bigint(20) UNSIGNED NOT NULL,
  `descricao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_completo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf` varchar(14) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `telefone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `hospede_reservas_reserva_id_foreign`(`reserva_id`) USING BTREE,
  INDEX `hospede_reservas_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `hospede_reservas_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `hospede_reservas_reserva_id_foreign` FOREIGN KEY (`reserva_id`) REFERENCES `reservas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ibpts
-- ----------------------------
DROP TABLE IF EXISTS `ibpts`;
CREATE TABLE `ibpts`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `versao` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for info_descargas
-- ----------------------------
DROP TABLE IF EXISTS `info_descargas`;
CREATE TABLE `info_descargas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mdfe_id` bigint(20) UNSIGNED NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `tp_unid_transp` int(11) NOT NULL,
  `id_unid_transp` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade_rateio` decimal(5, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `info_descargas_mdfe_id_foreign`(`mdfe_id`) USING BTREE,
  INDEX `info_descargas_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `info_descargas_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `info_descargas_mdfe_id_foreign` FOREIGN KEY (`mdfe_id`) REFERENCES `mdves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for interrupcoes
-- ----------------------------
DROP TABLE IF EXISTS `interrupcoes`;
CREATE TABLE `interrupcoes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `inicio` time NOT NULL,
  `fim` time NOT NULL,
  `dia_id` enum('segunda','terca','quarta','quinta','sexta','sabado','domingo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `motivo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `interrupcoes_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `interrupcoes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `interrupcoes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `interrupcoes_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for inutilizacaos
-- ----------------------------
DROP TABLE IF EXISTS `inutilizacaos`;
CREATE TABLE `inutilizacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `numero_inicial` int(11) NOT NULL,
  `numero_final` int(11) NOT NULL,
  `numero_serie` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` enum('55','65') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `justificativa` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` enum('novo','aprovado','rejeitado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `inutilizacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `inutilizacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for inventarios
-- ----------------------------
DROP TABLE IF EXISTS `inventarios`;
CREATE TABLE `inventarios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `inicio` date NOT NULL,
  `fim` date NOT NULL,
  `data_ajuste` datetime NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `referencia` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `inventarios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `inventarios_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `inventarios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `inventarios_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_adicional_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `item_adicional_deliveries`;
CREATE TABLE `item_adicional_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_pedido_id` bigint(20) UNSIGNED NOT NULL,
  `adicional_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_adicional_deliveries_item_pedido_id_foreign`(`item_pedido_id`) USING BTREE,
  INDEX `item_adicional_deliveries_adicional_id_foreign`(`adicional_id`) USING BTREE,
  CONSTRAINT `item_adicional_deliveries_adicional_id_foreign` FOREIGN KEY (`adicional_id`) REFERENCES `adicionals` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_adicional_deliveries_item_pedido_id_foreign` FOREIGN KEY (`item_pedido_id`) REFERENCES `item_pedido_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_adicionals
-- ----------------------------
DROP TABLE IF EXISTS `item_adicionals`;
CREATE TABLE `item_adicionals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_pedido_id` bigint(20) UNSIGNED NOT NULL,
  `adicional_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_adicionals_item_pedido_id_foreign`(`item_pedido_id`) USING BTREE,
  INDEX `item_adicionals_adicional_id_foreign`(`adicional_id`) USING BTREE,
  CONSTRAINT `item_adicionals_adicional_id_foreign` FOREIGN KEY (`adicional_id`) REFERENCES `adicionals` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_adicionals_item_pedido_id_foreign` FOREIGN KEY (`item_pedido_id`) REFERENCES `item_pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_agendamentos
-- ----------------------------
DROP TABLE IF EXISTS `item_agendamentos`;
CREATE TABLE `item_agendamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `agendamento_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` int(11) NOT NULL,
  `valor` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_agendamentos_servico_id_foreign`(`servico_id`) USING BTREE,
  INDEX `item_agendamentos_agendamento_id_foreign`(`agendamento_id`) USING BTREE,
  CONSTRAINT `item_agendamentos_agendamento_id_foreign` FOREIGN KEY (`agendamento_id`) REFERENCES `agendamentos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_agendamentos_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_carrinho_adicional_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `item_carrinho_adicional_deliveries`;
CREATE TABLE `item_carrinho_adicional_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_carrinho_id` bigint(20) UNSIGNED NOT NULL,
  `adicional_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_carrinho_adicional_deliveries_item_carrinho_id_foreign`(`item_carrinho_id`) USING BTREE,
  INDEX `item_carrinho_adicional_deliveries_adicional_id_foreign`(`adicional_id`) USING BTREE,
  CONSTRAINT `item_carrinho_adicional_deliveries_adicional_id_foreign` FOREIGN KEY (`adicional_id`) REFERENCES `adicionals` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinho_adicional_deliveries_item_carrinho_id_foreign` FOREIGN KEY (`item_carrinho_id`) REFERENCES `item_carrinho_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_carrinho_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `item_carrinho_deliveries`;
CREATE TABLE `item_carrinho_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `carrinho_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tamanho_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 3) NOT NULL,
  `observacao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_carrinho_deliveries_carrinho_id_foreign`(`carrinho_id`) USING BTREE,
  INDEX `item_carrinho_deliveries_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_carrinho_deliveries_servico_id_foreign`(`servico_id`) USING BTREE,
  INDEX `item_carrinho_deliveries_tamanho_id_foreign`(`tamanho_id`) USING BTREE,
  CONSTRAINT `item_carrinho_deliveries_carrinho_id_foreign` FOREIGN KEY (`carrinho_id`) REFERENCES `carrinho_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinho_deliveries_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinho_deliveries_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinho_deliveries_tamanho_id_foreign` FOREIGN KEY (`tamanho_id`) REFERENCES `tamanho_pizzas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_carrinhos
-- ----------------------------
DROP TABLE IF EXISTS `item_carrinhos`;
CREATE TABLE `item_carrinhos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `carrinho_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 3) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_carrinhos_carrinho_id_foreign`(`carrinho_id`) USING BTREE,
  INDEX `item_carrinhos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_carrinhos_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_carrinhos_carrinho_id_foreign` FOREIGN KEY (`carrinho_id`) REFERENCES `carrinhos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinhos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_carrinhos_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_conta_empresas
-- ----------------------------
DROP TABLE IF EXISTS `item_conta_empresas`;
CREATE TABLE `item_conta_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conta_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `caixa_id` int(11) NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(16, 2) NULL DEFAULT NULL,
  `saldo_atual` decimal(16, 2) NULL DEFAULT NULL,
  `tipo` enum('entrada','saida') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_conta_empresas_conta_id_foreign`(`conta_id`) USING BTREE,
  CONSTRAINT `item_conta_empresas_conta_id_foreign` FOREIGN KEY (`conta_id`) REFERENCES `conta_empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_cotacaos
-- ----------------------------
DROP TABLE IF EXISTS `item_cotacaos`;
CREATE TABLE `item_cotacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cotacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor_unitario` decimal(12, 3) NULL DEFAULT NULL,
  `quantidade` decimal(12, 3) NOT NULL,
  `sub_total` decimal(12, 3) NULL DEFAULT NULL,
  `observacao` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_cotacaos_cotacao_id_foreign`(`cotacao_id`) USING BTREE,
  INDEX `item_cotacaos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_cotacaos_cotacao_id_foreign` FOREIGN KEY (`cotacao_id`) REFERENCES `cotacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_cotacaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_dimensao_nves
-- ----------------------------
DROP TABLE IF EXISTS `item_dimensao_nves`;
CREATE TABLE `item_dimensao_nves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor_unitario_m2` decimal(12, 2) NOT NULL,
  `largura` decimal(12, 2) NOT NULL,
  `altura` decimal(12, 2) NOT NULL,
  `quantidade` decimal(12, 2) NOT NULL,
  `m2_total` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `espessura` decimal(12, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_dimensao_nves_item_nfe_id_foreign`(`item_nfe_id`) USING BTREE,
  CONSTRAINT `item_dimensao_nves_item_nfe_id_foreign` FOREIGN KEY (`item_nfe_id`) REFERENCES `item_nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_ibpts
-- ----------------------------
DROP TABLE IF EXISTS `item_ibpts`;
CREATE TABLE `item_ibpts`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ibpt_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `codigo` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nacional_federal` decimal(5, 2) NOT NULL,
  `importado_federal` decimal(5, 2) NOT NULL,
  `estadual` decimal(5, 2) NOT NULL,
  `municipal` decimal(5, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_ibpts_ibpt_id_foreign`(`ibpt_id`) USING BTREE,
  CONSTRAINT `item_ibpts_ibpt_id_foreign` FOREIGN KEY (`ibpt_id`) REFERENCES `ibpts` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_inventarios
-- ----------------------------
DROP TABLE IF EXISTS `item_inventarios`;
CREATE TABLE `item_inventarios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `inventario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(10, 2) NOT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `estado` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_inventarios_inventario_id_foreign`(`inventario_id`) USING BTREE,
  INDEX `item_inventarios_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_inventarios_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `item_inventarios_inventario_id_foreign` FOREIGN KEY (`inventario_id`) REFERENCES `inventarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_inventarios_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_inventarios_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_lista_precos
-- ----------------------------
DROP TABLE IF EXISTS `item_lista_precos`;
CREATE TABLE `item_lista_precos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `lista_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `percentual_lucro` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_lista_precos_lista_id_foreign`(`lista_id`) USING BTREE,
  INDEX `item_lista_precos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_lista_precos_lista_id_foreign` FOREIGN KEY (`lista_id`) REFERENCES `lista_precos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_lista_precos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_nfces
-- ----------------------------
DROP TABLE IF EXISTS `item_nfces`;
CREATE TABLE `item_nfces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfce_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(12, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `perc_icms` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_pis` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_cofins` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_ipi` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `cest` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '102',
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '49',
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '49',
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `perc_red_bc` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `cfop` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ncm` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cEnq` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pST` decimal(10, 2) NULL DEFAULT NULL,
  `vBCSTRet` decimal(10, 2) NULL DEFAULT NULL,
  `origem` int(11) NOT NULL DEFAULT 0,
  `codigo_beneficio_fiscal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '0=Normal, 1=Devolvido, 2=Trocado',
  `quantidade_devolvida` decimal(10, 3) NULL DEFAULT 0.000,
  `item_substituto_id` bigint(20) UNSIGNED NULL DEFAULT NULL COMMENT 'ID do item que substituiu este em caso de troca',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_nfces_nfce_id_foreign`(`nfce_id`) USING BTREE,
  INDEX `item_nfces_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_nfces_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_nfces_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_nfces_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_nfces_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 11518 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_nota_servicos
-- ----------------------------
DROP TABLE IF EXISTS `item_nota_servicos`;
CREATE TABLE `item_nota_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nota_servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `discriminacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_servico` decimal(16, 7) NOT NULL,
  `codigo_cnae` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_servico` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_tributacao_municipio` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `exigibilidade_iss` int(11) NOT NULL,
  `iss_retido` int(11) NOT NULL,
  `data_competencia` date NULL DEFAULT NULL,
  `estado_local_prestacao_servico` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_local_prestacao_servico` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_deducoes` decimal(16, 7) NULL DEFAULT NULL,
  `desconto_incondicional` decimal(16, 7) NULL DEFAULT NULL,
  `desconto_condicional` decimal(16, 7) NULL DEFAULT NULL,
  `outras_retencoes` decimal(16, 7) NULL DEFAULT NULL,
  `aliquota_iss` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_pis` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_cofins` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_inss` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_ir` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_csll` decimal(7, 2) NULL DEFAULT NULL,
  `intermediador` enum('n','f','j') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `documento_intermediador` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_intermediador` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `im_intermediador` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `responsavel_retencao_iss` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_nota_servicos_nota_servico_id_foreign`(`nota_servico_id`) USING BTREE,
  INDEX `item_nota_servicos_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `item_nota_servicos_nota_servico_id_foreign` FOREIGN KEY (`nota_servico_id`) REFERENCES `nota_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_nota_servicos_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_nves
-- ----------------------------
DROP TABLE IF EXISTS `item_nves`;
CREATE TABLE `item_nves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(12, 2) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `perc_icms` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_pis` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_cofins` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_ipi` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cest` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `vbc_icms` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `vbc_pis` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `vbc_cofins` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `vbc_ipi` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_red_bc` decimal(10, 2) NULL DEFAULT NULL,
  `cfop` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ncm` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cEnq` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pST` decimal(10, 2) NULL DEFAULT NULL,
  `vBCSTRet` decimal(10, 2) NULL DEFAULT NULL,
  `origem` int(11) NOT NULL DEFAULT 0,
  `codigo_beneficio_fiscal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `lote` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_vencimento` date NULL DEFAULT NULL,
  `xPed` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nItemPed` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `infAdProd` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pMVAST` decimal(10, 4) NULL DEFAULT NULL,
  `vBCST` decimal(10, 2) NULL DEFAULT NULL,
  `pICMSST` decimal(10, 2) NULL DEFAULT NULL,
  `vICMSST` decimal(10, 2) NULL DEFAULT NULL,
  `vBCFCPST` decimal(10, 2) NULL DEFAULT NULL,
  `pFCPST` decimal(10, 2) NULL DEFAULT NULL,
  `vFCPST` decimal(10, 2) NULL DEFAULT NULL,
  `modBCST` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '0=Normal, 1=Devolvido, 2=Trocado',
  `quantidade_devolvida` decimal(10, 3) NULL DEFAULT 0.000,
  `item_substituto_id` bigint(20) UNSIGNED NULL DEFAULT NULL COMMENT 'ID do item que substituiu este em caso de troca',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_nves_nfe_id_foreign`(`nfe_id`) USING BTREE,
  INDEX `item_nves_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_nves_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_nves_nfe_id_foreign` FOREIGN KEY (`nfe_id`) REFERENCES `nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_nves_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_nves_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1233 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_ordem_producaos
-- ----------------------------
DROP TABLE IF EXISTS `item_ordem_producaos`;
CREATE TABLE `item_ordem_producaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ordem_producao_id` bigint(20) UNSIGNED NOT NULL,
  `item_producao_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(12, 3) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_ordem_producaos_ordem_producao_id_foreign`(`ordem_producao_id`) USING BTREE,
  INDEX `item_ordem_producaos_item_producao_id_foreign`(`item_producao_id`) USING BTREE,
  INDEX `item_ordem_producaos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_ordem_producaos_item_producao_id_foreign` FOREIGN KEY (`item_producao_id`) REFERENCES `item_producaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_ordem_producaos_ordem_producao_id_foreign` FOREIGN KEY (`ordem_producao_id`) REFERENCES `ordem_producaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_ordem_producaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pedido_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `item_pedido_deliveries`;
CREATE TABLE `item_pedido_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `tamanho_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `estado` enum('novo','pendente','preparando','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'novo',
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `observacao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pedido_deliveries_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_pedido_deliveries_servico_id_foreign`(`servico_id`) USING BTREE,
  INDEX `item_pedido_deliveries_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `item_pedido_deliveries_tamanho_id_foreign`(`tamanho_id`) USING BTREE,
  CONSTRAINT `item_pedido_deliveries_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedido_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_deliveries_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_deliveries_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_deliveries_tamanho_id_foreign` FOREIGN KEY (`tamanho_id`) REFERENCES `tamanho_pizzas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pedido_ecommerces
-- ----------------------------
DROP TABLE IF EXISTS `item_pedido_ecommerces`;
CREATE TABLE `item_pedido_ecommerces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pedido_ecommerces_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `item_pedido_ecommerces_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_pedido_ecommerces_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_pedido_ecommerces_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedido_ecommerces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_ecommerces_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_ecommerces_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pedido_mercado_livres
-- ----------------------------
DROP TABLE IF EXISTS `item_pedido_mercado_livres`;
CREATE TABLE `item_pedido_mercado_livres`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `item_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `condicao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `variacao_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `taxa_venda` decimal(12, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pedido_mercado_livres_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `item_pedido_mercado_livres_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_pedido_mercado_livres_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedido_mercado_livres` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedido_mercado_livres_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `item_pedidos`;
CREATE TABLE `item_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `estado` enum('novo','pendente','preparando','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'novo',
  `quantidade` decimal(8, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `tempo_preparo` int(11) NULL DEFAULT NULL,
  `ponto_carne` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tamanho_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pedidos_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `item_pedidos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_pedidos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `item_pedidos_tamanho_id_foreign`(`tamanho_id`) USING BTREE,
  CONSTRAINT `item_pedidos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedidos_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedidos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pedidos_tamanho_id_foreign` FOREIGN KEY (`tamanho_id`) REFERENCES `tamanho_pizzas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pizza_carrinhos
-- ----------------------------
DROP TABLE IF EXISTS `item_pizza_carrinhos`;
CREATE TABLE `item_pizza_carrinhos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_carrinho_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pizza_carrinhos_item_carrinho_id_foreign`(`item_carrinho_id`) USING BTREE,
  INDEX `item_pizza_carrinhos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_pizza_carrinhos_item_carrinho_id_foreign` FOREIGN KEY (`item_carrinho_id`) REFERENCES `item_carrinho_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pizza_carrinhos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pizza_pedido_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `item_pizza_pedido_deliveries`;
CREATE TABLE `item_pizza_pedido_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pizza_pedido_deliveries_item_pedido_id_foreign`(`item_pedido_id`) USING BTREE,
  INDEX `item_pizza_pedido_deliveries_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_pizza_pedido_deliveries_item_pedido_id_foreign` FOREIGN KEY (`item_pedido_id`) REFERENCES `item_pedido_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pizza_pedido_deliveries_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pizza_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `item_pizza_pedidos`;
CREATE TABLE `item_pizza_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pizza_pedidos_item_pedido_id_foreign`(`item_pedido_id`) USING BTREE,
  INDEX `item_pizza_pedidos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_pizza_pedidos_item_pedido_id_foreign` FOREIGN KEY (`item_pedido_id`) REFERENCES `item_pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pizza_pedidos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_pre_vendas
-- ----------------------------
DROP TABLE IF EXISTS `item_pre_vendas`;
CREATE TABLE `item_pre_vendas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pre_venda_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(10, 3) NOT NULL,
  `valor` decimal(16, 7) NOT NULL,
  `observacao` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_pre_vendas_pre_venda_id_foreign`(`pre_venda_id`) USING BTREE,
  INDEX `item_pre_vendas_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_pre_vendas_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_pre_vendas_pre_venda_id_foreign` FOREIGN KEY (`pre_venda_id`) REFERENCES `pre_vendas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `item_pre_vendas_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_pre_vendas_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_producaos
-- ----------------------------
DROP TABLE IF EXISTS `item_producaos`;
CREATE TABLE `item_producaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(12, 3) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_producaos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_producaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_servico_nfces
-- ----------------------------
DROP TABLE IF EXISTS `item_servico_nfces`;
CREATE TABLE `item_servico_nfces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfce_id` bigint(20) UNSIGNED NOT NULL,
  `servico_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(6, 2) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `observacao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_servico_nfces_nfce_id_foreign`(`nfce_id`) USING BTREE,
  INDEX `item_servico_nfces_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `item_servico_nfces_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_servico_nfces_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_transferencia_estoques
-- ----------------------------
DROP TABLE IF EXISTS `item_transferencia_estoques`;
CREATE TABLE `item_transferencia_estoques`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `transferencia_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(14, 4) NOT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_transferencia_estoques_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_transferencia_estoques_transferencia_id_foreign`(`transferencia_id`) USING BTREE,
  CONSTRAINT `item_transferencia_estoques_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_transferencia_estoques_transferencia_id_foreign` FOREIGN KEY (`transferencia_id`) REFERENCES `transferencia_estoques` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_trocas
-- ----------------------------
DROP TABLE IF EXISTS `item_trocas`;
CREATE TABLE `item_trocas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `troca_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(7, 3) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_trocas_troca_id_foreign`(`troca_id`) USING BTREE,
  INDEX `item_trocas_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `item_trocas_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_trocas_troca_id_foreign` FOREIGN KEY (`troca_id`) REFERENCES `trocas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for item_venda_suspensas
-- ----------------------------
DROP TABLE IF EXISTS `item_venda_suspensas`;
CREATE TABLE `item_venda_suspensas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `venda_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(7, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `item_venda_suspensas_venda_id_foreign`(`venda_id`) USING BTREE,
  INDEX `item_venda_suspensas_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `item_venda_suspensas_variacao_id_foreign`(`variacao_id`) USING BTREE,
  CONSTRAINT `item_venda_suspensas_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_venda_suspensas_variacao_id_foreign` FOREIGN KEY (`variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `item_venda_suspensas_venda_id_foreign` FOREIGN KEY (`venda_id`) REFERENCES `venda_suspensas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for itens_devolucao
-- ----------------------------
DROP TABLE IF EXISTS `itens_devolucao`;
CREATE TABLE `itens_devolucao`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `devolucao_id` bigint(20) UNSIGNED NOT NULL,
  `item_id` bigint(20) UNSIGNED NOT NULL,
  `tipo_item` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade` decimal(10, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `itens_devolucao_devolucao_id_foreign`(`devolucao_id`) USING BTREE,
  INDEX `itens_devolucao_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `itens_devolucao_devolucao_id_foreign` FOREIGN KEY (`devolucao_id`) REFERENCES `devolucoes` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `itens_devolucao_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for laboratorios
-- ----------------------------
DROP TABLE IF EXISTS `laboratorios`;
CREATE TABLE `laboratorios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnpj` varchar(14) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `laboratorios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `laboratorios_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `laboratorios_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `laboratorios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for lacre_transportes
-- ----------------------------
DROP TABLE IF EXISTS `lacre_transportes`;
CREATE TABLE `lacre_transportes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `info_id` bigint(20) UNSIGNED NOT NULL,
  `numero` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `lacre_transportes_info_id_foreign`(`info_id`) USING BTREE,
  CONSTRAINT `lacre_transportes_info_id_foreign` FOREIGN KEY (`info_id`) REFERENCES `info_descargas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for lacre_unidade_cargas
-- ----------------------------
DROP TABLE IF EXISTS `lacre_unidade_cargas`;
CREATE TABLE `lacre_unidade_cargas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `info_id` bigint(20) UNSIGNED NOT NULL,
  `numero` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `lacre_unidade_cargas_info_id_foreign`(`info_id`) USING BTREE,
  CONSTRAINT `lacre_unidade_cargas_info_id_foreign` FOREIGN KEY (`info_id`) REFERENCES `info_descargas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for lista_preco_usuarios
-- ----------------------------
DROP TABLE IF EXISTS `lista_preco_usuarios`;
CREATE TABLE `lista_preco_usuarios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `lista_preco_id` bigint(20) UNSIGNED NOT NULL,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `lista_preco_usuarios_lista_preco_id_foreign`(`lista_preco_id`) USING BTREE,
  INDEX `lista_preco_usuarios_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `lista_preco_usuarios_lista_preco_id_foreign` FOREIGN KEY (`lista_preco_id`) REFERENCES `lista_precos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `lista_preco_usuarios_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for lista_precos
-- ----------------------------
DROP TABLE IF EXISTS `lista_precos`;
CREATE TABLE `lista_precos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ajuste_sobre` enum('valor_compra','valor_venda') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` enum('incremento','reducao') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentual_alteracao` decimal(5, 2) NOT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `lista_precos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `lista_precos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `lista_precos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `lista_precos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for localizacaos
-- ----------------------------
DROP TABLE IF EXISTS `localizacaos`;
CREATE TABLE `localizacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `nome` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_fantasia` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `aut_xml` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `celular` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `arquivo` blob NULL DEFAULT NULL,
  `senha` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `complemento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `numero_ultima_nfe_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfe_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_nfe` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfce_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfce_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_nfce` int(11) NULL DEFAULT NULL,
  `numero_ultima_cte_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_cte_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_cte` int(11) NULL DEFAULT NULL,
  `numero_ultima_mdfe_producao` int(11) NULL DEFAULT NULL,
  `numero_ultima_mdfe_homologacao` int(11) NULL DEFAULT NULL,
  `numero_serie_mdfe` int(11) NULL DEFAULT NULL,
  `numero_ultima_nfse` int(11) NULL DEFAULT NULL,
  `numero_serie_nfse` int(11) NULL DEFAULT NULL,
  `csc` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `csc_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ambiente` int(11) NOT NULL,
  `tributacao` enum('MEI','Simples Nacional','Regime Normal') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_nfse` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `perc_ap_cred` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `mensagem_aproveitamento_credito` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `localizacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `localizacaos_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `localizacaos_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `localizacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 22 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for login_falhas
-- ----------------------------
DROP TABLE IF EXISTS `login_falhas`;
CREATE TABLE `login_falhas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 63 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for manifesto_dves
-- ----------------------------
DROP TABLE IF EXISTS `manifesto_dves`;
CREATE TABLE `manifesto_dves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `num_prot` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_emissao` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequencia_evento` int(11) NOT NULL,
  `fatura_salva` tinyint(1) NOT NULL,
  `tipo` int(11) NOT NULL,
  `nsu` int(11) NOT NULL,
  `compra_id` int(11) NOT NULL DEFAULT 0,
  `nNf` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `manifesto_dves_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `manifesto_dves_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 259 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for manutencao_veiculo_anexos
-- ----------------------------
DROP TABLE IF EXISTS `manutencao_veiculo_anexos`;
CREATE TABLE `manutencao_veiculo_anexos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `manutencao_id` bigint(20) UNSIGNED NOT NULL,
  `arquivo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `manutencao_veiculo_anexos_manutencao_id_foreign`(`manutencao_id`) USING BTREE,
  CONSTRAINT `manutencao_veiculo_anexos_manutencao_id_foreign` FOREIGN KEY (`manutencao_id`) REFERENCES `manutencao_veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for manutencao_veiculo_produtos
-- ----------------------------
DROP TABLE IF EXISTS `manutencao_veiculo_produtos`;
CREATE TABLE `manutencao_veiculo_produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `manutencao_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(6, 2) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `manutencao_veiculo_produtos_manutencao_id_foreign`(`manutencao_id`) USING BTREE,
  INDEX `manutencao_veiculo_produtos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `manutencao_veiculo_produtos_manutencao_id_foreign` FOREIGN KEY (`manutencao_id`) REFERENCES `manutencao_veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `manutencao_veiculo_produtos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for manutencao_veiculo_servicos
-- ----------------------------
DROP TABLE IF EXISTS `manutencao_veiculo_servicos`;
CREATE TABLE `manutencao_veiculo_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `manutencao_id` bigint(20) UNSIGNED NOT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(6, 2) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `manutencao_veiculo_servicos_manutencao_id_foreign`(`manutencao_id`) USING BTREE,
  INDEX `manutencao_veiculo_servicos_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `manutencao_veiculo_servicos_manutencao_id_foreign` FOREIGN KEY (`manutencao_id`) REFERENCES `manutencao_veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `manutencao_veiculo_servicos_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for manutencao_veiculos
-- ----------------------------
DROP TABLE IF EXISTS `manutencao_veiculos`;
CREATE TABLE `manutencao_veiculos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `veiculo_id` bigint(20) UNSIGNED NOT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `total` decimal(12, 2) NOT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(10, 2) NULL DEFAULT NULL,
  `conta_pagar_id` tinyint(1) NULL DEFAULT NULL,
  `data_inicio` date NULL DEFAULT NULL,
  `data_fim` date NULL DEFAULT NULL,
  `estado` enum('aguardando','em_manutencao','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `manutencao_veiculos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `manutencao_veiculos_veiculo_id_foreign`(`veiculo_id`) USING BTREE,
  INDEX `manutencao_veiculos_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  CONSTRAINT `manutencao_veiculos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `manutencao_veiculos_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `manutencao_veiculos_veiculo_id_foreign` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for marcas
-- ----------------------------
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE `marcas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `marcas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `marcas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 408 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for margem_comissaos
-- ----------------------------
DROP TABLE IF EXISTS `margem_comissaos`;
CREATE TABLE `margem_comissaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `percentual` decimal(5, 2) NULL DEFAULT NULL,
  `margem` decimal(5, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `margem_comissaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `margem_comissaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for market_place_configs
-- ----------------------------
DROP TABLE IF EXISTS `market_place_configs`;
CREATE TABLE `market_place_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `loja_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_facebook` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_instagram` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_whatsapp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tempo_medio_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_entrega` decimal(10, 2) NULL DEFAULT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `latitude` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `longitude` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_entrega_gratis` decimal(10, 2) NULL DEFAULT NULL,
  `usar_bairros` tinyint(1) NOT NULL DEFAULT 1,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `notificacao_novo_pedido` tinyint(1) NOT NULL DEFAULT 1,
  `mercadopago_public_key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercadopago_access_token` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_divisao_pizza` enum('divide','valor_maior') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'divide',
  `logo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fav_icon` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipos_pagamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `segmento` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `pedido_minimo` decimal(10, 2) NULL DEFAULT NULL,
  `avaliacao_media` decimal(10, 2) NOT NULL,
  `api_token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `autenticacao_sms` tinyint(1) NOT NULL DEFAULT 0,
  `confirmacao_pedido_cliente` tinyint(1) NOT NULL DEFAULT 0,
  `tipo_entrega` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cor_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `funcionamento_descricao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `market_place_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `market_place_configs_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `market_place_configs_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `market_place_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for mdves
-- ----------------------------
DROP TABLE IF EXISTS `mdves`;
CREATE TABLE `mdves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `uf_inicio` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uf_fim` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `encerrado` tinyint(1) NOT NULL,
  `data_inicio_viagem` date NOT NULL,
  `carga_posterior` tinyint(1) NOT NULL,
  `cnpj_contratante` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `veiculo_tracao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `veiculo_reboque_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `veiculo_reboque2_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `veiculo_reboque3_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estado_emissao` enum('novo','aprovado','rejeitado','cancelado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mdfe_numero` int(11) NOT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `protocolo` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `seguradora_nome` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `seguradora_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_apolice` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_averbacao` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_carga` decimal(10, 2) NOT NULL,
  `quantidade_carga` decimal(16, 4) NOT NULL,
  `info_complementar` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `info_adicional_fisco` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `condutor_nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `condutor_cpf` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lac_rodo` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tp_emit` int(11) NOT NULL,
  `tp_transp` int(11) NOT NULL,
  `produto_pred_nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `produto_pred_ncm` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `produto_pred_cod_barras` varchar(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep_carrega` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep_descarrega` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tp_carga` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitude_carregamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitude_carregamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitude_descarregamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitude_descarregamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `tipo_modal` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `mdves_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `mdves_veiculo_tracao_id_foreign`(`veiculo_tracao_id`) USING BTREE,
  INDEX `mdves_veiculo_reboque_id_foreign`(`veiculo_reboque_id`) USING BTREE,
  INDEX `mdves_veiculo_reboque2_id_foreign`(`veiculo_reboque2_id`) USING BTREE,
  INDEX `mdves_veiculo_reboque3_id_foreign`(`veiculo_reboque3_id`) USING BTREE,
  CONSTRAINT `mdves_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `mdves_veiculo_reboque2_id_foreign` FOREIGN KEY (`veiculo_reboque2_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `mdves_veiculo_reboque3_id_foreign` FOREIGN KEY (`veiculo_reboque3_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `mdves_veiculo_reboque_id_foreign` FOREIGN KEY (`veiculo_reboque_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `mdves_veiculo_tracao_id_foreign` FOREIGN KEY (`veiculo_tracao_id`) REFERENCES `veiculos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for medicao_receita_os
-- ----------------------------
DROP TABLE IF EXISTS `medicao_receita_os`;
CREATE TABLE `medicao_receita_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ordem_servico_id` bigint(20) UNSIGNED NOT NULL,
  `esferico_longe_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `esferico_longe_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `esferico_perto_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `esferico_perto_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cilindrico_longe_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cilindrico_longe_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cilindrico_perto_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cilindrico_perto_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `eixo_longe_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `eixo_longe_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `eixo_perto_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `eixo_perto_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `altura_longe_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `altura_longe_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `altura_perto_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `altura_perto_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dnp_longe_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dnp_longe_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dnp_perto_od` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dnp_perto_oe` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `medicao_receita_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  CONSTRAINT `medicao_receita_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for medicos
-- ----------------------------
DROP TABLE IF EXISTS `medicos`;
CREATE TABLE `medicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpf` varchar(14) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `crm` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `medicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `medicos_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `medicos_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `medicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for medida_ctes
-- ----------------------------
DROP TABLE IF EXISTS `medida_ctes`;
CREATE TABLE `medida_ctes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cte_id` bigint(20) UNSIGNED NOT NULL,
  `cod_unidade` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_medida` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade` decimal(10, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `medida_ctes_cte_id_foreign`(`cte_id`) USING BTREE,
  CONSTRAINT `medida_ctes_cte_id_foreign` FOREIGN KEY (`cte_id`) REFERENCES `ctes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for menu_access_logs
-- ----------------------------
DROP TABLE IF EXISTS `menu_access_logs`;
CREATE TABLE `menu_access_logs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rota` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `menu` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `submenu` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_menu_access_logs_usuario`(`usuario_id`) USING BTREE,
  INDEX `fk_menu_access_logs_empresa`(`empresa_id`) USING BTREE,
  CONSTRAINT `fk_menu_access_logs_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_menu_access_logs_usuario` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 55554 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for mercado_livre_configs
-- ----------------------------
DROP TABLE IF EXISTS `mercado_livre_configs`;
CREATE TABLE `mercado_livre_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `client_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `refresh_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `url` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_expira` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `mercado_livre_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `mercado_livre_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for mercado_livre_perguntas
-- ----------------------------
DROP TABLE IF EXISTS `mercado_livre_perguntas`;
CREATE TABLE `mercado_livre_perguntas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `texto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `resposta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `mercado_livre_perguntas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `mercado_livre_perguntas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for meta_resultados
-- ----------------------------
DROP TABLE IF EXISTS `meta_resultados`;
CREATE TABLE `meta_resultados`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `funcionario_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(12, 2) NOT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `tabela` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `meta_resultados_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `meta_resultados_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `meta_resultados_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `meta_resultados_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 241 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for model_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions`  (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`permission_id`, `model_id`, `model_type`) USING BTREE,
  INDEX `model_has_permissions_model_id_model_type_index`(`model_id`, `model_type`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for model_has_roles
-- ----------------------------
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles`  (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`role_id`, `model_id`, `model_type`) USING BTREE,
  INDEX `model_has_roles_model_id_model_type_index`(`model_id`, `model_type`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for modelo_etiquetas
-- ----------------------------
DROP TABLE IF EXISTS `modelo_etiquetas`;
CREATE TABLE `modelo_etiquetas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `altura` decimal(7, 2) NOT NULL,
  `largura` decimal(7, 2) NOT NULL,
  `etiquestas_por_linha` int(11) NOT NULL,
  `distancia_etiquetas_lateral` decimal(7, 2) NOT NULL,
  `distancia_etiquetas_horizontal` int(11) NULL DEFAULT 5,
  `distancia_etiquetas_topo` decimal(7, 2) NOT NULL,
  `quantidade_etiquetas` int(11) NOT NULL,
  `tamanho_fonte` decimal(7, 2) NOT NULL,
  `tamanho_codigo_barras` decimal(7, 2) NOT NULL,
  `nome_empresa` tinyint(1) NOT NULL,
  `nome_produto` tinyint(1) NOT NULL,
  `valor_produto` tinyint(1) NOT NULL,
  `codigo_produto` tinyint(1) NOT NULL,
  `codigo_barras_numerico` tinyint(1) NOT NULL,
  `importado_super` tinyint(1) NOT NULL DEFAULT 0,
  `tipo` enum('simples','gondola') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `modelo_etiquetas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `modelo_etiquetas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for motivo_interrupcaos
-- ----------------------------
DROP TABLE IF EXISTS `motivo_interrupcaos`;
CREATE TABLE `motivo_interrupcaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `motivo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `motivo_interrupcaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `motivo_interrupcaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for motoboy_comissaos
-- ----------------------------
DROP TABLE IF EXISTS `motoboy_comissaos`;
CREATE TABLE `motoboy_comissaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `motoboy_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `valor_total_pedido` decimal(10, 2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `motoboy_comissaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `motoboy_comissaos_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `motoboy_comissaos_motoboy_id_foreign`(`motoboy_id`) USING BTREE,
  CONSTRAINT `motoboy_comissaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `motoboy_comissaos_motoboy_id_foreign` FOREIGN KEY (`motoboy_id`) REFERENCES `motoboys` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `motoboy_comissaos_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedido_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for motoboys
-- ----------------------------
DROP TABLE IF EXISTS `motoboys`;
CREATE TABLE `motoboys`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_comissao` decimal(10, 2) NOT NULL,
  `tipo_comissao` enum('valor_fixo','percentual') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `motoboys_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `motoboys_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movimentacao_produtos
-- ----------------------------
DROP TABLE IF EXISTS `movimentacao_produtos`;
CREATE TABLE `movimentacao_produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(14, 4) NOT NULL,
  `tipo` enum('incremento','reducao') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_transacao` int(11) NOT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `tipo_transacao` enum('venda_nfe','venda_nfce','compra','alteracao_estoque') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `produto_variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estoque_atual` decimal(14, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `movimentacao_produtos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `movimentacao_produtos_produto_variacao_id_foreign`(`produto_variacao_id`) USING BTREE,
  CONSTRAINT `movimentacao_produtos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `movimentacao_produtos_produto_variacao_id_foreign` FOREIGN KEY (`produto_variacao_id`) REFERENCES `produto_variacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 13848 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movimentos_estoque
-- ----------------------------
DROP TABLE IF EXISTS `movimentos_estoque`;
CREATE TABLE `movimentos_estoque`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade_anterior` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `quantidade_nova` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `diferenca` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ajuste, entrada, saida, transferencia, inventario',
  `operacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'entrada, saida',
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `inventario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `movimentos_estoque_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `movimentos_estoque_user_id_foreign`(`user_id`) USING BTREE,
  INDEX `movimentos_estoque_inventario_id_foreign`(`inventario_id`) USING BTREE,
  CONSTRAINT `movimentos_estoque_inventario_id_foreign` FOREIGN KEY (`inventario_id`) REFERENCES `inventarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `movimentos_estoque_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `movimentos_estoque_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for municipio_carregamentos
-- ----------------------------
DROP TABLE IF EXISTS `municipio_carregamentos`;
CREATE TABLE `municipio_carregamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mdfe_id` bigint(20) UNSIGNED NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `municipio_carregamentos_mdfe_id_foreign`(`mdfe_id`) USING BTREE,
  INDEX `municipio_carregamentos_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `municipio_carregamentos_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `municipio_carregamentos_mdfe_id_foreign` FOREIGN KEY (`mdfe_id`) REFERENCES `mdves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for n_fe_descargas
-- ----------------------------
DROP TABLE IF EXISTS `n_fe_descargas`;
CREATE TABLE `n_fe_descargas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `info_id` bigint(20) UNSIGNED NOT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `seg_cod_barras` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `n_fe_descargas_info_id_foreign`(`info_id`) USING BTREE,
  CONSTRAINT `n_fe_descargas_info_id_foreign` FOREIGN KEY (`info_id`) REFERENCES `info_descargas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for natureza_operacaos
-- ----------------------------
DROP TABLE IF EXISTS `natureza_operacaos`;
CREATE TABLE `natureza_operacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_entrada_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_entrada_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_icms` decimal(5, 2) NULL DEFAULT NULL,
  `perc_pis` decimal(5, 2) NULL DEFAULT NULL,
  `perc_cofins` decimal(5, 2) NULL DEFAULT NULL,
  `perc_ipi` decimal(5, 2) NULL DEFAULT NULL,
  `padrao` tinyint(1) NOT NULL DEFAULT 0,
  `sobrescrever_cfop` tinyint(1) NOT NULL DEFAULT 0,
  `_id_import` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `natureza_operacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `natureza_operacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 46 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ncms
-- ----------------------------
DROP TABLE IF EXISTS `ncms`;
CREATE TABLE `ncms`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 15142 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nfces
-- ----------------------------
DROP TABLE IF EXISTS `nfces`;
CREATE TABLE `nfces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `natureza_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `emissor_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `emissor_cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ambiente` int(11) NOT NULL,
  `lista_id` int(11) NULL DEFAULT NULL,
  `funcionario_id` int(11) NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cliente_cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `chave_sat` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `recibo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_serie` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` int(11) NULL DEFAULT NULL,
  `motivo_rejeicao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `estado` enum('novo','rejeitado','cancelado','aprovado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `total` decimal(12, 2) NOT NULL,
  `desconto` decimal(12, 2) NULL DEFAULT NULL,
  `valor_cashback` decimal(10, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(12, 2) NULL DEFAULT NULL,
  `valor_entrega` decimal(12, 2) NULL DEFAULT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `api` tinyint(1) NOT NULL DEFAULT 0,
  `data_emissao` timestamp NULL DEFAULT NULL,
  `dinheiro_recebido` decimal(10, 2) NOT NULL,
  `troco` decimal(10, 2) NOT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxa_percentual` decimal(10, 2) NULL DEFAULT NULL,
  `bandeira_cartao` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `cnpj_cartao` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cAut_cartao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `gerar_conta_receber` tinyint(1) NOT NULL DEFAULT 0,
  `local_id` int(11) NULL DEFAULT NULL,
  `signed_xml` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `contigencia` tinyint(1) NOT NULL DEFAULT 0,
  `reenvio_contigencia` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `valor_devolvido` decimal(10, 2) NULL DEFAULT 0.00 COMMENT 'Valor total de devoluções',
  `tem_devolucao` tinyint(4) NULL DEFAULT 0 COMMENT '1=Tem devolução, 0=Não tem',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nfces_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `nfces_natureza_id_foreign`(`natureza_id`) USING BTREE,
  INDEX `nfces_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `nfces_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `nfces_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nfces_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nfces_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nfces_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3154 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nota_servico_configs
-- ----------------------------
DROP TABLE IF EXISTS `nota_servico_configs`;
CREATE TABLE `nota_servico_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `razao_social` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `regime` enum('simples','normal') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `im` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cnae` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `login_prefeitura` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `senha_prefeitura` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nota_servico_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `nota_servico_configs_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `nota_servico_configs_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nota_servico_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nota_servicos
-- ----------------------------
DROP TABLE IF EXISTS `nota_servicos`;
CREATE TABLE `nota_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor_total` decimal(16, 7) NOT NULL,
  `gerar_conta_receber` tinyint(1) NOT NULL DEFAULT 0,
  `data_vencimento` date NULL DEFAULT NULL,
  `conta_receber_id` int(11) NULL DEFAULT NULL,
  `estado` enum('novo','rejeitado','aprovado','cancelado','processando') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_verificacao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_nfse` int(11) NOT NULL,
  `url_xml` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_pdf_nfse` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_pdf_rps` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `razao_social` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `im` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `natureza_operacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `uuid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `chave` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ambiente` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nota_servicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `nota_servicos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `nota_servicos_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `nota_servicos_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nota_servicos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nota_servicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for notas_reservas
-- ----------------------------
DROP TABLE IF EXISTS `notas_reservas`;
CREATE TABLE `notas_reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reserva_id` bigint(20) UNSIGNED NOT NULL,
  `texto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `notas_reservas_reserva_id_foreign`(`reserva_id`) USING BTREE,
  CONSTRAINT `notas_reservas_reserva_id_foreign` FOREIGN KEY (`reserva_id`) REFERENCES `reservas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for notificacaos
-- ----------------------------
DROP TABLE IF EXISTS `notificacaos`;
CREATE TABLE `notificacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `tabela` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao_curta` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `referencia` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `visualizada` tinyint(1) NOT NULL DEFAULT 0,
  `por_sistema` tinyint(1) NOT NULL DEFAULT 0,
  `prioridade` enum('baixa','media','alta') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `super` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `notificacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `notificacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for notificao_cardapios
-- ----------------------------
DROP TABLE IF EXISTS `notificao_cardapios`;
CREATE TABLE `notificao_cardapios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `pedido_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `mesa` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `comanda` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` enum('garcom','fechar_mesa') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `avaliacao` int(11) NULL DEFAULT NULL,
  `observacao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `notificao_cardapios_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `notificao_cardapios_pedido_id_foreign`(`pedido_id`) USING BTREE,
  CONSTRAINT `notificao_cardapios_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `notificao_cardapios_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nps_configuracoes
-- ----------------------------
DROP TABLE IF EXISTS `nps_configuracoes`;
CREATE TABLE `nps_configuracoes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ativo` tinyint(1) NOT NULL DEFAULT 0,
  `data_inicio` date NULL DEFAULT NULL,
  `data_fim` date NULL DEFAULT NULL,
  `dia_mes` tinyint(4) NOT NULL DEFAULT 1,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pesquisa de Satisfação',
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nps_pesquisas
-- ----------------------------
DROP TABLE IF EXISTS `nps_pesquisas`;
CREATE TABLE `nps_pesquisas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nota` tinyint(4) NULL DEFAULT NULL,
  `feedback` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ignorado` tinyint(1) NOT NULL DEFAULT 0,
  `respondido` tinyint(1) NOT NULL DEFAULT 0,
  `mes_referencia` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_nps_pesquisas_empresa`(`empresa_id`) USING BTREE,
  INDEX `idx_usuario_mes`(`usuario_id`, `mes_referencia`) USING BTREE,
  CONSTRAINT `fk_nps_pesquisas_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `fk_nps_pesquisas_usuario` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 46 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nuvem_shop_configs
-- ----------------------------
DROP TABLE IF EXISTS `nuvem_shop_configs`;
CREATE TABLE `nuvem_shop_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `client_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_secret` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nuvem_shop_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `nuvem_shop_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nuvem_shop_item_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `nuvem_shop_item_pedidos`;
CREATE TABLE `nuvem_shop_item_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `pedido_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `sub_total` decimal(10, 2) NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nuvem_shop_item_pedidos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `nuvem_shop_item_pedidos_pedido_id_foreign`(`pedido_id`) USING BTREE,
  CONSTRAINT `nuvem_shop_item_pedidos_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `nuvem_shop_pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nuvem_shop_item_pedidos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nuvem_shop_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `nuvem_shop_pedidos`;
CREATE TABLE `nuvem_shop_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `pedido_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtotal` decimal(10, 2) NOT NULL,
  `total` decimal(10, 2) NOT NULL,
  `valor_frete` decimal(10, 2) NOT NULL,
  `desconto` decimal(10, 2) NOT NULL,
  `observacao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cliente_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `status_envio` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `gateway` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_pagamento` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `venda_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nuvem_shop_pedidos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `nuvem_shop_pedidos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for nves
-- ----------------------------
DROP TABLE IF EXISTS `nves`;
CREATE TABLE `nves`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `natureza_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` int(11) NULL DEFAULT NULL,
  `emissor_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `emissor_cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `aut_xml` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ambiente` int(11) NOT NULL,
  `crt` int(11) NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `transportadora_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `chave` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `chave_importada` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `recibo` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_serie` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` int(11) NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `sequencia_cce` int(11) NOT NULL DEFAULT 0,
  `motivo_rejeicao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `estado` enum('novo','rejeitado','cancelado','aprovado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` decimal(12, 2) NOT NULL,
  `valor_produtos` decimal(12, 2) NULL DEFAULT NULL,
  `valor_frete` decimal(12, 2) NULL DEFAULT NULL,
  `desconto` decimal(12, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(12, 2) NULL DEFAULT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `placa` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` int(11) NULL DEFAULT NULL,
  `qtd_volumes` int(11) NULL DEFAULT NULL,
  `numeracao_volumes` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `especie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `peso_liquido` decimal(8, 3) NULL DEFAULT NULL,
  `peso_bruto` decimal(8, 3) NULL DEFAULT NULL,
  `api` tinyint(1) NOT NULL DEFAULT 0,
  `gerar_conta_receber` tinyint(1) NOT NULL DEFAULT 0,
  `gerar_conta_pagar` tinyint(1) NOT NULL DEFAULT 0,
  `referencia` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tpNF` int(11) NOT NULL DEFAULT 1,
  `tpEmis` int(11) NOT NULL DEFAULT 1,
  `finNFe` int(11) NOT NULL DEFAULT 1,
  `data_emissao` timestamp NULL DEFAULT NULL,
  `orcamento` tinyint(1) NOT NULL DEFAULT 0,
  `ref_orcamento` int(11) NULL DEFAULT NULL,
  `data_emissao_saida` date NULL DEFAULT NULL,
  `data_emissao_retroativa` date NULL DEFAULT NULL,
  `data_entrega` date NULL DEFAULT NULL,
  `bandeira_cartao` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cnpj_cartao` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cAut_cartao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `signed_xml` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `contigencia` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `valor_devolvido` decimal(10, 2) NULL DEFAULT 0.00 COMMENT 'Valor total de devoluções',
  `tem_devolucao` tinyint(4) NULL DEFAULT 0 COMMENT '1=Tem devolução, 0=Não tem',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `nves_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `nves_natureza_id_foreign`(`natureza_id`) USING BTREE,
  INDEX `nves_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `nves_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  INDEX `nves_caixa_id_foreign`(`caixa_id`) USING BTREE,
  INDEX `nves_transportadora_id_foreign`(`transportadora_id`) USING BTREE,
  CONSTRAINT `nves_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nves_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nves_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nves_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nves_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `nves_transportadora_id_foreign` FOREIGN KEY (`transportadora_id`) REFERENCES `transportadoras` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 185 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ordem_producaos
-- ----------------------------
DROP TABLE IF EXISTS `ordem_producaos`;
CREATE TABLE `ordem_producaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `estado` enum('novo','producao','expedicao','entregue') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_prevista_entrega` date NULL DEFAULT NULL,
  `codigo_sequencial` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ordem_producaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `ordem_producaos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `ordem_producaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ordem_producaos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ordem_servicos
-- ----------------------------
DROP TABLE IF EXISTS `ordem_servicos`;
CREATE TABLE `ordem_servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estado` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pd',
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `forma_pagamento` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'av',
  `valor` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `data_inicio` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `data_entrega` timestamp NULL DEFAULT NULL,
  `nfe_id` int(11) NOT NULL DEFAULT 0,
  `codigo_sequencial` int(11) NULL DEFAULT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `adiantamento` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ordem_servicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `ordem_servicos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `ordem_servicos_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `ordem_servicos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `ordem_servicos_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `ordem_servicos_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ordem_servicos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ordem_servicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ordem_servicos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ordem_servicos_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for otica_os
-- ----------------------------
DROP TABLE IF EXISTS `otica_os`;
CREATE TABLE `otica_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ordem_servico_id` bigint(20) UNSIGNED NOT NULL,
  `convenio_id` int(11) NULL DEFAULT NULL,
  `medico_id` int(11) NULL DEFAULT NULL,
  `tipo_armacao_id` int(11) NULL DEFAULT NULL,
  `laboratorio_id` int(11) NULL DEFAULT NULL,
  `formato_armacao_id` int(11) NULL DEFAULT NULL,
  `validade` date NULL DEFAULT NULL,
  `arquivo_receita` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao_receita` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_lente` enum('Pronta','Surfaçada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `material_lente` enum('Policarbonato','Resina','Trivex') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_lente` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `coloracao_lente` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_propria` tinyint(1) NOT NULL,
  `armacao_segue` tinyint(1) NOT NULL,
  `armacao_aro` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_ponte` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_maior_diagonal` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_altura_vertical` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_distancia_pupilar` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_altura_centro_longe_od` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_altura_centro_longe_oe` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_altura_centro_perto_od` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `armacao_altura_centro_perto_oe` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tratamentos` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `otica_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  CONSTRAINT `otica_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for padrao_frigobars
-- ----------------------------
DROP TABLE IF EXISTS `padrao_frigobars`;
CREATE TABLE `padrao_frigobars`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `frigobar_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `padrao_frigobars_frigobar_id_foreign`(`frigobar_id`) USING BTREE,
  INDEX `padrao_frigobars_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `padrao_frigobars_frigobar_id_foreign` FOREIGN KEY (`frigobar_id`) REFERENCES `frigobars` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `padrao_frigobars_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for padrao_tributacao_produtos
-- ----------------------------
DROP TABLE IF EXISTS `padrao_tributacao_produtos`;
CREATE TABLE `padrao_tributacao_produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `perc_icms` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_pis` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_cofins` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_ipi` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop_entrada_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_entrada_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cEnq` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_red_bc` decimal(5, 2) NULL DEFAULT NULL,
  `pST` decimal(5, 2) NULL DEFAULT NULL,
  `cest` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ncm` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_beneficio_fiscal` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `padrao` tinyint(1) NOT NULL DEFAULT 0,
  `modBCST` int(11) NULL DEFAULT NULL,
  `pMVAST` decimal(5, 2) NULL DEFAULT NULL,
  `pICMSST` decimal(5, 2) NULL DEFAULT NULL,
  `redBCST` decimal(5, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `padrao_tributacao_produtos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `padrao_tributacao_produtos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 26 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pagamentos
-- ----------------------------
DROP TABLE IF EXISTS `pagamentos`;
CREATE TABLE `pagamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `plano_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `transacao_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `forma_pagamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `qr_code_base64` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `qr_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pagamentos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pagamentos_plano_id_foreign`(`plano_id`) USING BTREE,
  CONSTRAINT `pagamentos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pagamentos_plano_id_foreign` FOREIGN KEY (`plano_id`) REFERENCES `planos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for password_reset_tokens
-- ----------------------------
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens`  (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for password_resets
-- ----------------------------
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets`  (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  INDEX `password_resets_email_index`(`email`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pedido_deliveries
-- ----------------------------
DROP TABLE IF EXISTS `pedido_deliveries`;
CREATE TABLE `pedido_deliveries`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `motoboy_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `comissao_motoboy` decimal(10, 2) NULL DEFAULT NULL,
  `valor_total` decimal(10, 2) NOT NULL,
  `troco_para` decimal(10, 2) NULL DEFAULT NULL,
  `tipo_pagamento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` enum('novo','aprovado','cancelado','finalizado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `motivo_estado` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `endereco_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cupom_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `valor_entrega` decimal(10, 2) NOT NULL,
  `app` tinyint(1) NOT NULL,
  `qr_code_base64` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `qr_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `transacao_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status_pagamento` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pedido_lido` tinyint(1) NOT NULL DEFAULT 0,
  `finalizado` tinyint(1) NOT NULL DEFAULT 0,
  `horario_cricao` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `horario_leitura` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `horario_entrega` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nfce_id` int(11) NULL DEFAULT NULL,
  `funcionario_id_agendamento` int(11) NULL DEFAULT NULL,
  `inicio_agendamento` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `fim_agendamento` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_agendamento` date NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pedido_deliveries_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pedido_deliveries_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `pedido_deliveries_motoboy_id_foreign`(`motoboy_id`) USING BTREE,
  INDEX `pedido_deliveries_endereco_id_foreign`(`endereco_id`) USING BTREE,
  INDEX `pedido_deliveries_cupom_id_foreign`(`cupom_id`) USING BTREE,
  CONSTRAINT `pedido_deliveries_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_deliveries_cupom_id_foreign` FOREIGN KEY (`cupom_id`) REFERENCES `cupom_descontos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_deliveries_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_deliveries_endereco_id_foreign` FOREIGN KEY (`endereco_id`) REFERENCES `endereco_deliveries` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_deliveries_motoboy_id_foreign` FOREIGN KEY (`motoboy_id`) REFERENCES `motoboys` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pedido_ecommerces
-- ----------------------------
DROP TABLE IF EXISTS `pedido_ecommerces`;
CREATE TABLE `pedido_ecommerces`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `endereco_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `estado` enum('novo','preparando','em_trasporte','finalizado','recusado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_pagamento` enum('cartao','pix','boleto','deposito') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_total` decimal(10, 2) NOT NULL,
  `valor_frete` decimal(10, 2) NULL DEFAULT NULL,
  `desconto` decimal(10, 2) NULL DEFAULT NULL,
  `tipo_frete` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `rua_entrega` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `referencia_entrega` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro_entrega` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_entrega` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `link_boleto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `qr_code_base64` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `qr_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `hash_pedido` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_pagamento` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `transacao_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `nfe_id` int(11) NULL DEFAULT NULL,
  `cupom_desconto` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_rastreamento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pedido_lido` tinyint(1) NOT NULL DEFAULT 0,
  `nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `sobre_nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_documento` enum('cpf','cnpj') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `comprovante` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pedido_ecommerces_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `pedido_ecommerces_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pedido_ecommerces_endereco_id_foreign`(`endereco_id`) USING BTREE,
  CONSTRAINT `pedido_ecommerces_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_ecommerces_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_ecommerces_endereco_id_foreign` FOREIGN KEY (`endereco_id`) REFERENCES `endereco_ecommerces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pedido_mercado_livres
-- ----------------------------
DROP TABLE IF EXISTS `pedido_mercado_livres`;
CREATE TABLE `pedido_mercado_livres`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `_id` bigint(20) NOT NULL,
  `tipo_pagamento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` decimal(10, 2) NOT NULL,
  `valor_entrega` decimal(10, 2) NOT NULL,
  `nickname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `entrega_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_pedido` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `comentario` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `rua_entrega` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep_entrega` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro_entrega` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_entrega` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `comentario_entrega` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_rastreamento` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cliente_nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cliente_documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pedido_mercado_livres_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pedido_mercado_livres_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `pedido_mercado_livres_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedido_mercado_livres_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pedidos
-- ----------------------------
DROP TABLE IF EXISTS `pedidos`;
CREATE TABLE `pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cliente_fone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `comanda` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mesa` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `data_fechamento` timestamp NULL DEFAULT NULL,
  `total` decimal(12, 2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `em_atendimento` tinyint(1) NOT NULL DEFAULT 1,
  `nfce_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pedidos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pedidos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `pedidos_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  CONSTRAINT `pedidos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedidos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pedidos_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for percurso_cte_os
-- ----------------------------
DROP TABLE IF EXISTS `percurso_cte_os`;
CREATE TABLE `percurso_cte_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cteos_id` bigint(20) UNSIGNED NOT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `percurso_cte_os_cteos_id_foreign`(`cteos_id`) USING BTREE,
  CONSTRAINT `percurso_cte_os_cteos_id_foreign` FOREIGN KEY (`cteos_id`) REFERENCES `cte_os` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for percursos
-- ----------------------------
DROP TABLE IF EXISTS `percursos`;
CREATE TABLE `percursos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mdfe_id` bigint(20) UNSIGNED NOT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `percursos_mdfe_id_foreign`(`mdfe_id`) USING BTREE,
  CONSTRAINT `percursos_mdfe_id_foreign` FOREIGN KEY (`mdfe_id`) REFERENCES `mdves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for permissions
-- ----------------------------
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `permissions_name_guard_name_unique`(`name`, `guard_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 290 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for personal_access_tokens
-- ----------------------------
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `personal_access_tokens_token_unique`(`token`) USING BTREE,
  INDEX `personal_access_tokens_tokenable_type_tokenable_id_index`(`tokenable_type`, `tokenable_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for plano_contas
-- ----------------------------
DROP TABLE IF EXISTS `plano_contas`;
CREATE TABLE `plano_contas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `plano_conta_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `plano_contas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `plano_contas_plano_conta_id_foreign`(`plano_conta_id`) USING BTREE,
  CONSTRAINT `plano_contas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `plano_contas_plano_conta_id_foreign` FOREIGN KEY (`plano_conta_id`) REFERENCES `plano_contas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 345 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for plano_empresas
-- ----------------------------
DROP TABLE IF EXISTS `plano_empresas`;
CREATE TABLE `plano_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `revenda_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `plano_id` bigint(20) UNSIGNED NOT NULL,
  `data_expiracao` date NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `valor_repasse` decimal(10, 2) NULL DEFAULT NULL,
  `forma_pagamento` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `plano_empresas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `plano_empresas_plano_id_foreign`(`plano_id`) USING BTREE,
  INDEX `fk_plano_empresas_revenda_id`(`revenda_id`) USING BTREE,
  CONSTRAINT `fk_plano_empresas_revenda_id` FOREIGN KEY (`revenda_id`) REFERENCES `revendas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `plano_empresas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `plano_empresas_plano_id_foreign` FOREIGN KEY (`plano_id`) REFERENCES `planos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 25 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for plano_pendentes
-- ----------------------------
DROP TABLE IF EXISTS `plano_pendentes`;
CREATE TABLE `plano_pendentes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `contador_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `plano_id` bigint(20) UNSIGNED NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `plano_pendentes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `plano_pendentes_contador_id_foreign`(`contador_id`) USING BTREE,
  INDEX `plano_pendentes_plano_id_foreign`(`plano_id`) USING BTREE,
  CONSTRAINT `plano_pendentes_contador_id_foreign` FOREIGN KEY (`contador_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `plano_pendentes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `plano_pendentes_plano_id_foreign` FOREIGN KEY (`plano_id`) REFERENCES `planos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for planos
-- ----------------------------
DROP TABLE IF EXISTS `planos`;
CREATE TABLE `planos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `maximo_nfes` int(11) NOT NULL,
  `maximo_nfces` int(11) NOT NULL,
  `maximo_ctes` int(11) NOT NULL,
  `maximo_mdfes` int(11) NOT NULL,
  `maximo_usuarios` int(11) NOT NULL,
  `maximo_locais` int(11) NOT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `visivel_clientes` tinyint(1) NOT NULL DEFAULT 1,
  `visivel_contadores` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `valor` decimal(10, 2) NOT NULL,
  `valor_implantacao` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `intervalo_dias` int(11) NOT NULL,
  `modulos` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `auto_cadastro` tinyint(1) NOT NULL,
  `fiscal` tinyint(1) NOT NULL,
  `segmento_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 12 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pre_vendas
-- ----------------------------
DROP TABLE IF EXISTS `pre_vendas`;
CREATE TABLE `pre_vendas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `lista_id` int(11) NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `funcionario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `natureza_id` bigint(20) UNSIGNED NOT NULL,
  `valor_total` decimal(16, 7) NOT NULL,
  `desconto` decimal(10, 2) NOT NULL,
  `acrescimo` decimal(10, 2) NOT NULL,
  `forma_pagamento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pedido_delivery_id` int(11) NULL DEFAULT NULL,
  `tipo_finalizado` enum('nfe','nfce') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `venda_id` int(11) NULL DEFAULT NULL,
  `codigo` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bandeira_cartao` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `cnpj_cartao` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cAut_cartao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `descricao_pag_outros` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rascunho` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `local_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pre_vendas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `pre_vendas_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `pre_vendas_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `pre_vendas_funcionario_id_foreign`(`funcionario_id`) USING BTREE,
  INDEX `pre_vendas_natureza_id_foreign`(`natureza_id`) USING BTREE,
  CONSTRAINT `pre_vendas_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pre_vendas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pre_vendas_funcionario_id_foreign` FOREIGN KEY (`funcionario_id`) REFERENCES `funcionarios` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pre_vendas_natureza_id_foreign` FOREIGN KEY (`natureza_id`) REFERENCES `natureza_operacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `pre_vendas_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_adicionals
-- ----------------------------
DROP TABLE IF EXISTS `produto_adicionals`;
CREATE TABLE `produto_adicionals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `adicional_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_adicionals_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_adicionals_adicional_id_foreign`(`adicional_id`) USING BTREE,
  CONSTRAINT `produto_adicionals_adicional_id_foreign` FOREIGN KEY (`adicional_id`) REFERENCES `adicionals` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_adicionals_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_combos
-- ----------------------------
DROP TABLE IF EXISTS `produto_combos`;
CREATE TABLE `produto_combos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `item_id` bigint(20) UNSIGNED NOT NULL,
  `quantidade` decimal(8, 3) NOT NULL,
  `valor_compra` decimal(12, 4) NOT NULL,
  `sub_total` decimal(12, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_combos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_combos_item_id_foreign`(`item_id`) USING BTREE,
  CONSTRAINT `produto_combos_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_combos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_composicaos
-- ----------------------------
DROP TABLE IF EXISTS `produto_composicaos`;
CREATE TABLE `produto_composicaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ingrediente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 3) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_composicaos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_composicaos_ingrediente_id_foreign`(`ingrediente_id`) USING BTREE,
  CONSTRAINT `produto_composicaos_ingrediente_id_foreign` FOREIGN KEY (`ingrediente_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_composicaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_fornecedors
-- ----------------------------
DROP TABLE IF EXISTS `produto_fornecedors`;
CREATE TABLE `produto_fornecedors`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `fornecedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_fornecedors_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_fornecedors_fornecedor_id_foreign`(`fornecedor_id`) USING BTREE,
  CONSTRAINT `produto_fornecedors_fornecedor_id_foreign` FOREIGN KEY (`fornecedor_id`) REFERENCES `fornecedors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_fornecedors_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 365 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_ingredientes
-- ----------------------------
DROP TABLE IF EXISTS `produto_ingredientes`;
CREATE TABLE `produto_ingredientes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ingrediente` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_ingredientes_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `produto_ingredientes_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_localizacaos
-- ----------------------------
DROP TABLE IF EXISTS `produto_localizacaos`;
CREATE TABLE `produto_localizacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `localizacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_localizacaos_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_localizacaos_localizacao_id_foreign`(`localizacao_id`) USING BTREE,
  CONSTRAINT `produto_localizacaos_localizacao_id_foreign` FOREIGN KEY (`localizacao_id`) REFERENCES `localizacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_localizacaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2625 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_os
-- ----------------------------
DROP TABLE IF EXISTS `produto_os`;
CREATE TABLE `produto_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ordem_servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` int(11) NOT NULL,
  `valor` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `subtotal` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_os_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  CONSTRAINT `produto_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_os_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_pizza_valors
-- ----------------------------
DROP TABLE IF EXISTS `produto_pizza_valors`;
CREATE TABLE `produto_pizza_valors`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `tamanho_id` bigint(20) UNSIGNED NOT NULL,
  `valor` decimal(12, 4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_pizza_valors_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_pizza_valors_tamanho_id_foreign`(`tamanho_id`) USING BTREE,
  CONSTRAINT `produto_pizza_valors_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_pizza_valors_tamanho_id_foreign` FOREIGN KEY (`tamanho_id`) REFERENCES `tamanho_pizzas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_tributacao_locals
-- ----------------------------
DROP TABLE IF EXISTS `produto_tributacao_locals`;
CREATE TABLE `produto_tributacao_locals`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `local_id` bigint(20) UNSIGNED NOT NULL,
  `ncm` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_icms` decimal(10, 2) NULL DEFAULT NULL,
  `perc_pis` decimal(10, 2) NULL DEFAULT NULL,
  `perc_cofins` decimal(10, 2) NULL DEFAULT NULL,
  `perc_ipi` decimal(10, 2) NULL DEFAULT NULL,
  `perc_red_bc` decimal(5, 2) NULL DEFAULT NULL,
  `cest` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `origem` int(11) NULL DEFAULT NULL,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_unitario` decimal(12, 4) NULL DEFAULT NULL,
  `cfop_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_tributacao_locals_produto_id_foreign`(`produto_id`) USING BTREE,
  INDEX `produto_tributacao_locals_local_id_foreign`(`local_id`) USING BTREE,
  CONSTRAINT `produto_tributacao_locals_local_id_foreign` FOREIGN KEY (`local_id`) REFERENCES `localizacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_tributacao_locals_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_unicos
-- ----------------------------
DROP TABLE IF EXISTS `produto_unicos`;
CREATE TABLE `produto_unicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nfe_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nfce_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `codigo` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` enum('entrada','saida') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `em_estoque` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_unicos_nfe_id_foreign`(`nfe_id`) USING BTREE,
  INDEX `produto_unicos_nfce_id_foreign`(`nfce_id`) USING BTREE,
  INDEX `produto_unicos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `produto_unicos_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_unicos_nfe_id_foreign` FOREIGN KEY (`nfe_id`) REFERENCES `nves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produto_unicos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produto_variacaos
-- ----------------------------
DROP TABLE IF EXISTS `produto_variacaos`;
CREATE TABLE `produto_variacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `descricao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(12, 4) NOT NULL,
  `codigo_barras` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `referencia` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produto_variacaos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `produto_variacaos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for produtos
-- ----------------------------
DROP TABLE IF EXISTS `produtos`;
CREATE TABLE `produtos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `categoria_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `sub_categoria_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `padrao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `marca_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `variacao_modelo_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_barras` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_barras2` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_barras3` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `referencia` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ncm` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `unidade` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_icms` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_pis` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_cofins` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `perc_ipi` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `cest` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `origem` int(11) NOT NULL DEFAULT 0,
  `cst_csosn` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_pis` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_cofins` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_ipi` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_red_bc` decimal(5, 2) NULL DEFAULT NULL,
  `pST` decimal(5, 2) NULL DEFAULT NULL,
  `valor_unitario` decimal(12, 4) NOT NULL,
  `valor_minimo_venda` decimal(12, 4) NOT NULL,
  `valor_compra` decimal(12, 4) NOT NULL,
  `percentual_lucro` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `cfop_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cfop_entrada_estadual` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_entrada_outro_estado` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_beneficio_fiscal` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cEnq` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `gerenciar_estoque` tinyint(1) NOT NULL DEFAULT 0,
  `adRemICMSRet` decimal(10, 4) NOT NULL DEFAULT 0.0000,
  `pBio` decimal(10, 4) NOT NULL DEFAULT 0.0000,
  `tipo_servico` tinyint(1) NOT NULL DEFAULT 0,
  `indImport` int(11) NOT NULL DEFAULT 0,
  `cUFOrig` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pOrig` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `codigo_anp` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `perc_glp` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_gnn` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `perc_gni` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `valor_partida` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `unidade_tributavel` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `quantidade_tributavel` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `cardapio` tinyint(1) NOT NULL DEFAULT 0,
  `delivery` tinyint(1) NOT NULL DEFAULT 0,
  `reserva` tinyint(1) NOT NULL DEFAULT 0,
  `ecommerce` tinyint(1) NOT NULL DEFAULT 0,
  `nome_en` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_es` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_en` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao_es` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_cardapio` decimal(12, 4) NULL DEFAULT NULL,
  `valor_delivery` decimal(12, 4) NULL DEFAULT NULL,
  `destaque_delivery` tinyint(1) NULL DEFAULT NULL,
  `oferta_delivery` tinyint(1) NULL DEFAULT NULL,
  `tempo_preparo` int(11) NULL DEFAULT NULL,
  `tipo_carne` tinyint(1) NOT NULL DEFAULT 0,
  `tipo_unico` tinyint(1) NOT NULL DEFAULT 0,
  `composto` tinyint(1) NOT NULL DEFAULT 0,
  `combo` tinyint(1) NOT NULL DEFAULT 0,
  `margem_combo` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `estoque_minimo` decimal(5, 2) NOT NULL DEFAULT 0.00,
  `alerta_validade` int(11) NULL DEFAULT NULL,
  `referencia_balanca` int(11) NULL DEFAULT NULL,
  `balanca_pdv` tinyint(1) NOT NULL DEFAULT 0,
  `exportar_balanca` tinyint(1) NOT NULL DEFAULT 0,
  `valor_ecommerce` decimal(12, 4) NULL DEFAULT NULL,
  `destaque_ecommerce` tinyint(1) NULL DEFAULT NULL,
  `percentual_desconto` int(11) NULL DEFAULT NULL,
  `descricao_ecommerce` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `texto_ecommerce` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `largura` decimal(8, 2) NULL DEFAULT NULL,
  `comprimento` decimal(8, 2) NULL DEFAULT NULL,
  `altura` decimal(8, 2) NULL DEFAULT NULL,
  `peso` decimal(12, 3) NULL DEFAULT NULL,
  `hash_ecommerce` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `hash_delivery` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `texto_delivery` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mercado_livre_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercado_livre_link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercado_livre_valor` decimal(12, 4) NULL DEFAULT NULL,
  `mercado_livre_categoria` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `condicao_mercado_livre` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `quantidade_mercado_livre` int(11) NULL DEFAULT NULL,
  `mercado_livre_tipo_publicacao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercado_livre_youtube` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `mercado_livre_descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mercado_livre_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mercado_livre_modelo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_slug` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_valor` decimal(12, 4) NULL DEFAULT NULL,
  `woocommerce_type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `woocommerce_descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `woocommerce_stock_status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `categorias_woocommerce` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nuvem_shop_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nuvem_shop_valor` decimal(12, 4) NULL DEFAULT NULL,
  `texto_nuvem_shop` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `modBCST` int(11) NULL DEFAULT NULL,
  `pMVAST` decimal(5, 2) NULL DEFAULT NULL,
  `pICMSST` decimal(5, 2) NULL DEFAULT NULL,
  `redBCST` decimal(5, 2) NULL DEFAULT NULL,
  `valor_atacado` decimal(22, 7) NOT NULL DEFAULT 0.0000000,
  `quantidade_atacado` int(11) NULL DEFAULT NULL,
  `referencia_xml` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_dimensao` tinyint(1) NOT NULL DEFAULT 0,
  `tipo_producao` tinyint(1) NOT NULL DEFAULT 0,
  `espessura` decimal(8, 2) NULL DEFAULT NULL,
  `_id_import` int(11) NULL DEFAULT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao2` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao3` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao4` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `produtos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `produtos_categoria_id_foreign`(`categoria_id`) USING BTREE,
  INDEX `produtos_sub_categoria_id_foreign`(`sub_categoria_id`) USING BTREE,
  INDEX `produtos_padrao_id_foreign`(`padrao_id`) USING BTREE,
  INDEX `produtos_marca_id_foreign`(`marca_id`) USING BTREE,
  CONSTRAINT `produtos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categoria_produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produtos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produtos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produtos_padrao_id_foreign` FOREIGN KEY (`padrao_id`) REFERENCES `padrao_tributacao_produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `produtos_sub_categoria_id_foreign` FOREIGN KEY (`sub_categoria_id`) REFERENCES `categoria_produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2618 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for recebimento_planos
-- ----------------------------
DROP TABLE IF EXISTS `recebimento_planos`;
CREATE TABLE `recebimento_planos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `financeiro_plano_id` bigint(20) UNSIGNED NOT NULL,
  `data_pagamento` date NOT NULL,
  `valor_pago` decimal(10, 2) NOT NULL,
  `valor_repasse` decimal(10, 2) NULL DEFAULT NULL,
  `forma_pagamento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_recebimento_planos_financeiro_plano_id`(`financeiro_plano_id`) USING BTREE,
  INDEX `fk_recebimento_planos_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `fk_recebimento_planos_financeiro_plano_id` FOREIGN KEY (`financeiro_plano_id`) REFERENCES `financeiro_planos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_recebimento_planos_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for registro_tefs
-- ----------------------------
DROP TABLE IF EXISTS `registro_tefs`;
CREATE TABLE `registro_tefs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nfce_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome_rede` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nsu` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_transacao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hora_transacao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_total` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estado` enum('aprovado','cancelado','pendente') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `usuario_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `registro_tefs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `registro_tefs_nfce_id_foreign`(`nfce_id`) USING BTREE,
  CONSTRAINT `registro_tefs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `registro_tefs_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for relacao_dados_fornecedors
-- ----------------------------
DROP TABLE IF EXISTS `relacao_dados_fornecedors`;
CREATE TABLE `relacao_dados_fornecedors`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cst_csosn_entrada` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_entrada` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cst_csosn_saida` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cfop_saida` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `relacao_dados_fornecedors_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `relacao_dados_fornecedors_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for relatorio_os
-- ----------------------------
DROP TABLE IF EXISTS `relatorio_os`;
CREATE TABLE `relatorio_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ordem_servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `texto` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_registro` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `relatorio_os_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `relatorio_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  CONSTRAINT `relatorio_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `relatorio_os_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for remessa_boleto_items
-- ----------------------------
DROP TABLE IF EXISTS `remessa_boleto_items`;
CREATE TABLE `remessa_boleto_items`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `remessa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `boleto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `remessa_boleto_items_remessa_id_foreign`(`remessa_id`) USING BTREE,
  INDEX `remessa_boleto_items_boleto_id_foreign`(`boleto_id`) USING BTREE,
  CONSTRAINT `remessa_boleto_items_boleto_id_foreign` FOREIGN KEY (`boleto_id`) REFERENCES `boletos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `remessa_boleto_items_remessa_id_foreign` FOREIGN KEY (`remessa_id`) REFERENCES `remessa_boletos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for remessa_boletos
-- ----------------------------
DROP TABLE IF EXISTS `remessa_boletos`;
CREATE TABLE `remessa_boletos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome_arquivo` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `conta_boleto_id` int(11) NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `remessa_boletos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `remessa_boletos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reserva_configs
-- ----------------------------
DROP TABLE IF EXISTS `reserva_configs`;
CREATE TABLE `reserva_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cpf_cnpj` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `razao_social` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NOT NULL,
  `telefone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `horario_checkin` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `horario_checkout` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `reserva_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `reserva_configs_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `reserva_configs_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `reserva_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reservas
-- ----------------------------
DROP TABLE IF EXISTS `reservas`;
CREATE TABLE `reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NOT NULL,
  `acomodacao_id` bigint(20) UNSIGNED NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `data_checkin` date NOT NULL,
  `data_checkout` date NOT NULL,
  `valor_estadia` decimal(12, 2) NOT NULL,
  `desconto` decimal(12, 2) NULL DEFAULT NULL,
  `valor_outros` decimal(12, 2) NULL DEFAULT NULL,
  `valor_total` decimal(12, 2) NULL DEFAULT NULL,
  `estado` enum('pendente','iniciado','finalizado','cancelado') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `motivo_cancelamento` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `conferencia_frigobar` tinyint(1) NOT NULL DEFAULT 0,
  `total_hospedes` int(11) NULL DEFAULT NULL,
  `codigo_reseva` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_externo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_checkin_realizado` timestamp NULL DEFAULT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `nfse_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `reservas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `reservas_cliente_id_foreign`(`cliente_id`) USING BTREE,
  INDEX `reservas_acomodacao_id_foreign`(`acomodacao_id`) USING BTREE,
  CONSTRAINT `reservas_acomodacao_id_foreign` FOREIGN KEY (`acomodacao_id`) REFERENCES `acomodacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `reservas_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `reservas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for revendas
-- ----------------------------
DROP TABLE IF EXISTS `revendas`;
CREATE TABLE `revendas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpf_cnpj` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_fantasia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `ie` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `endereco` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cep` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `telefone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `celular` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_revendas_cidade_id`(`cidade_id`) USING BTREE,
  CONSTRAINT `fk_revendas_cidade_id` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for role_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions`  (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  PRIMARY KEY (`permission_id`, `role_id`) USING BTREE,
  INDEX `role_has_permissions_role_id_foreign`(`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for roles
-- ----------------------------
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `type_user` smallint(6) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `roles_name_guard_name_unique`(`name`, `guard_name`) USING BTREE,
  INDEX `roles_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `roles_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 40 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sangria_caixas
-- ----------------------------
DROP TABLE IF EXISTS `sangria_caixas`;
CREATE TABLE `sangria_caixas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `conta_empresa_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sangria_caixas_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `sangria_caixas_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 39 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for segmento_empresas
-- ----------------------------
DROP TABLE IF EXISTS `segmento_empresas`;
CREATE TABLE `segmento_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `segmento_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `segmento_empresas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `segmento_empresas_segmento_id_foreign`(`segmento_id`) USING BTREE,
  CONSTRAINT `segmento_empresas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `segmento_empresas_segmento_id_foreign` FOREIGN KEY (`segmento_id`) REFERENCES `segmentos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for segmentos
-- ----------------------------
DROP TABLE IF EXISTS `segmentos`;
CREATE TABLE `segmentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for servico_os
-- ----------------------------
DROP TABLE IF EXISTS `servico_os`;
CREATE TABLE `servico_os`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ordem_servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `valor` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `subtotal` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `servico_os_servico_id_foreign`(`servico_id`) USING BTREE,
  INDEX `servico_os_ordem_servico_id_foreign`(`ordem_servico_id`) USING BTREE,
  CONSTRAINT `servico_os_ordem_servico_id_foreign` FOREIGN KEY (`ordem_servico_id`) REFERENCES `ordem_servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `servico_os_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for servico_reservas
-- ----------------------------
DROP TABLE IF EXISTS `servico_reservas`;
CREATE TABLE `servico_reservas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reserva_id` bigint(20) UNSIGNED NOT NULL,
  `servico_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `servico_reservas_reserva_id_foreign`(`reserva_id`) USING BTREE,
  INDEX `servico_reservas_servico_id_foreign`(`servico_id`) USING BTREE,
  CONSTRAINT `servico_reservas_reserva_id_foreign` FOREIGN KEY (`reserva_id`) REFERENCES `reservas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `servico_reservas_servico_id_foreign` FOREIGN KEY (`servico_id`) REFERENCES `servicos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for servicos
-- ----------------------------
DROP TABLE IF EXISTS `servicos`;
CREATE TABLE `servicos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `nome` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `unidade_cobranca` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tempo_servico` int(11) NOT NULL,
  `tempo_adicional` int(11) NOT NULL DEFAULT 0,
  `tempo_tolerancia` int(11) NOT NULL DEFAULT 0,
  `valor_adicional` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `comissao` decimal(6, 2) NOT NULL DEFAULT 0.00,
  `categoria_id` bigint(20) UNSIGNED NOT NULL,
  `codigo_servico` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `aliquota_iss` decimal(6, 2) NULL DEFAULT NULL,
  `aliquota_pis` decimal(6, 2) NULL DEFAULT NULL,
  `aliquota_cofins` decimal(6, 2) NULL DEFAULT NULL,
  `aliquota_inss` decimal(6, 2) NULL DEFAULT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `reserva` tinyint(1) NOT NULL DEFAULT 0,
  `padrao_reserva_nfse` tinyint(1) NOT NULL DEFAULT 0,
  `marketplace` tinyint(1) NOT NULL DEFAULT 0,
  `codigo_tributacao_municipio` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `hash_delivery` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `destaque_marketplace` tinyint(1) NULL DEFAULT NULL,
  `aliquota_ir` decimal(7, 2) NULL DEFAULT NULL,
  `aliquota_csll` decimal(7, 2) NULL DEFAULT NULL,
  `valor_deducoes` decimal(16, 7) NULL DEFAULT NULL,
  `desconto_incondicional` decimal(16, 7) NULL DEFAULT NULL,
  `desconto_condicional` decimal(16, 7) NULL DEFAULT NULL,
  `outras_retencoes` decimal(16, 7) NULL DEFAULT NULL,
  `estado_local_prestacao_servico` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `natureza_operacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_cnae` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `servicos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `servicos_categoria_id_foreign`(`categoria_id`) USING BTREE,
  CONSTRAINT `servicos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categoria_servicos` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `servicos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sessions
-- ----------------------------
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions`  (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sessions_user_id_index`(`user_id`) USING BTREE,
  INDEX `sessions_last_activity_index`(`last_activity`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sped_configs
-- ----------------------------
DROP TABLE IF EXISTS `sped_configs`;
CREATE TABLE `sped_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `codigo_conta_analitica` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_receita` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `gerar_bloco_k` tinyint(1) NOT NULL DEFAULT 0,
  `layout_bloco_k` int(11) NOT NULL DEFAULT 0,
  `codigo_obrigacao` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '000',
  `data_vencimento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '10',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sped_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `sped_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for speds
-- ----------------------------
DROP TABLE IF EXISTS `speds`;
CREATE TABLE `speds`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `data_refrencia` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `saldo_credor` decimal(14, 2) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `speds_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `speds_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for suprimento_caixas
-- ----------------------------
DROP TABLE IF EXISTS `suprimento_caixas`;
CREATE TABLE `suprimento_caixas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `conta_empresa_id` int(11) NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `suprimento_caixas_caixa_id_foreign`(`caixa_id`) USING BTREE,
  CONSTRAINT `suprimento_caixas_caixa_id_foreign` FOREIGN KEY (`caixa_id`) REFERENCES `caixas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 17 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for system_updates
-- ----------------------------
DROP TABLE IF EXISTS `system_updates`;
CREATE TABLE `system_updates`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `versao` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tamanho_pizzas
-- ----------------------------
DROP TABLE IF EXISTS `tamanho_pizzas`;
CREATE TABLE `tamanho_pizzas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_en` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome_es` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `maximo_sabores` int(11) NOT NULL,
  `quantidade_pedacos` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tamanho_pizzas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `tamanho_pizzas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for taxa_historico
-- ----------------------------
DROP TABLE IF EXISTS `taxa_historico`;
CREATE TABLE `taxa_historico`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `taxa_pagamento_id` bigint(20) UNSIGNED NOT NULL,
  `taxa_anterior` decimal(10, 2) NULL DEFAULT NULL,
  `taxa_nova` decimal(10, 2) NOT NULL,
  `tipo_pagamento` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bandeira_cartao` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_taxa_historico_empresa_id`(`empresa_id`) USING BTREE,
  INDEX `fk_taxa_historico_taxa_pagamento_id`(`taxa_pagamento_id`) USING BTREE,
  INDEX `fk_taxa_historico_usuario_id`(`usuario_id`) USING BTREE,
  INDEX `idx_tipo_pagamento`(`tipo_pagamento`) USING BTREE,
  INDEX `idx_bandeira_cartao`(`bandeira_cartao`) USING BTREE,
  CONSTRAINT `fk_taxa_historico_empresa_id` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `fk_taxa_historico_taxa_pagamento_id` FOREIGN KEY (`taxa_pagamento_id`) REFERENCES `taxa_pagamentos` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `fk_taxa_historico_usuario_id` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for taxa_pagamentos
-- ----------------------------
DROP TABLE IF EXISTS `taxa_pagamentos`;
CREATE TABLE `taxa_pagamentos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `taxa` decimal(7, 3) NOT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bandeira_cartao` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `taxa_pagamentos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `taxa_pagamentos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tef_multi_plus_cards
-- ----------------------------
DROP TABLE IF EXISTS `tef_multi_plus_cards`;
CREATE TABLE `tef_multi_plus_cards`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pdv` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tef_multi_plus_cards_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `tef_multi_plus_cards_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `tef_multi_plus_cards_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `tef_multi_plus_cards_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ticket_mensagem_anexos
-- ----------------------------
DROP TABLE IF EXISTS `ticket_mensagem_anexos`;
CREATE TABLE `ticket_mensagem_anexos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ticket_mensagem_id` bigint(20) UNSIGNED NOT NULL,
  `anexo` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ticket_mensagem_anexos_ticket_mensagem_id_foreign`(`ticket_mensagem_id`) USING BTREE,
  CONSTRAINT `ticket_mensagem_anexos_ticket_mensagem_id_foreign` FOREIGN KEY (`ticket_mensagem_id`) REFERENCES `ticket_mensagems` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ticket_mensagems
-- ----------------------------
DROP TABLE IF EXISTS `ticket_mensagems`;
CREATE TABLE `ticket_mensagems`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) UNSIGNED NOT NULL,
  `descricao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `resposta` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ticket_mensagems_ticket_id_foreign`(`ticket_id`) USING BTREE,
  CONSTRAINT `ticket_mensagems_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tickets
-- ----------------------------
DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `assunto` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `departamento` enum('financeiro','suporte') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('aberto','respondida','resolvido','aguardando') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tickets_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `tickets_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipo_armacaos
-- ----------------------------
DROP TABLE IF EXISTS `tipo_armacaos`;
CREATE TABLE `tipo_armacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tipo_armacaos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `tipo_armacaos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipo_despesa_fretes
-- ----------------------------
DROP TABLE IF EXISTS `tipo_despesa_fretes`;
CREATE TABLE `tipo_despesa_fretes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tipo_despesa_fretes_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `tipo_despesa_fretes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for transferencia_estoques
-- ----------------------------
DROP TABLE IF EXISTS `transferencia_estoques`;
CREATE TABLE `transferencia_estoques`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `local_saida_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `local_entrada_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `observacao` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `codigo_transacao` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `transferencia_estoques_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `transferencia_estoques_local_saida_id_foreign`(`local_saida_id`) USING BTREE,
  INDEX `transferencia_estoques_local_entrada_id_foreign`(`local_entrada_id`) USING BTREE,
  INDEX `transferencia_estoques_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `transferencia_estoques_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `transferencia_estoques_local_entrada_id_foreign` FOREIGN KEY (`local_entrada_id`) REFERENCES `localizacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `transferencia_estoques_local_saida_id_foreign` FOREIGN KEY (`local_saida_id`) REFERENCES `localizacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `transferencia_estoques_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for transportadoras
-- ----------------------------
DROP TABLE IF EXISTS `transportadoras`;
CREATE TABLE `transportadoras`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `razao_social` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nome_fantasia` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpf_cnpj` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ie` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cidade_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `rua` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cep` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bairro` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `complemento` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `antt` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `_id_import` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `transportadoras_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `transportadoras_cidade_id_foreign`(`cidade_id`) USING BTREE,
  CONSTRAINT `transportadoras_cidade_id_foreign` FOREIGN KEY (`cidade_id`) REFERENCES `cidades` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `transportadoras_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tratamento_oticas
-- ----------------------------
DROP TABLE IF EXISTS `tratamento_oticas`;
CREATE TABLE `tratamento_oticas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `nome` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `tratamento_oticas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `tratamento_oticas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for trocas
-- ----------------------------
DROP TABLE IF EXISTS `trocas`;
CREATE TABLE `trocas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nfce_id` bigint(20) UNSIGNED NOT NULL,
  `observacao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `valor_troca` decimal(12, 2) NOT NULL,
  `valor_original` decimal(12, 2) NOT NULL,
  `numero_sequencial` int(11) NULL DEFAULT NULL,
  `codigo` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `trocas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `trocas_nfce_id_foreign`(`nfce_id`) USING BTREE,
  CONSTRAINT `trocas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `trocas_nfce_id_foreign` FOREIGN KEY (`nfce_id`) REFERENCES `nfces` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for unidade_cargas
-- ----------------------------
DROP TABLE IF EXISTS `unidade_cargas`;
CREATE TABLE `unidade_cargas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `info_id` bigint(20) UNSIGNED NOT NULL,
  `id_unidade_carga` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade_rateio` decimal(5, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `unidade_cargas_info_id_foreign`(`info_id`) USING BTREE,
  CONSTRAINT `unidade_cargas_info_id_foreign` FOREIGN KEY (`info_id`) REFERENCES `info_descargas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for unidade_medidas
-- ----------------------------
DROP TABLE IF EXISTS `unidade_medidas`;
CREATE TABLE `unidade_medidas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `unidade_medidas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `unidade_medidas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1103 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_sessions
-- ----------------------------
DROP TABLE IF EXISTS `user_sessions`;
CREATE TABLE `user_sessions`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `login_time` timestamp NULL DEFAULT NULL,
  `logout_time` timestamp NULL DEFAULT NULL,
  `session_duration` int(11) NULL DEFAULT NULL COMMENT 'Duração da sessão em segundos',
  `ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `features_used` int(11) NULL DEFAULT 0 COMMENT 'Número de funcionalidades usadas na sessão',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_user_sessions_usuario`(`usuario_id`) USING BTREE,
  INDEX `fk_user_sessions_empresa`(`empresa_id`) USING BTREE,
  CONSTRAINT `fk_user_sessions_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_user_sessions_usuario` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1150 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `imagem` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT 1,
  `sidebar_active` tinyint(1) NOT NULL DEFAULT 1,
  `notificacao_cardapio` tinyint(1) NOT NULL DEFAULT 0,
  `notificacao_marketplace` tinyint(1) NOT NULL DEFAULT 0,
  `notificacao_ecommerce` tinyint(1) NOT NULL DEFAULT 0,
  `tipo_contador` tinyint(1) NOT NULL DEFAULT 0,
  `escolher_localidade_venda` tinyint(1) NOT NULL DEFAULT 0,
  `suporte` tinyint(1) NOT NULL DEFAULT 0,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `users_email_unique`(`email`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 33 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for usuario_emissaos
-- ----------------------------
DROP TABLE IF EXISTS `usuario_emissaos`;
CREATE TABLE `usuario_emissaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `numero_serie_nfce` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_ultima_nfce` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `usuario_emissaos_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `usuario_emissaos_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for usuario_empresas
-- ----------------------------
DROP TABLE IF EXISTS `usuario_empresas`;
CREATE TABLE `usuario_empresas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `usuario_empresas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `usuario_empresas_usuario_id_foreign`(`usuario_id`) USING BTREE,
  CONSTRAINT `usuario_empresas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `usuario_empresas_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 29 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for usuario_localizacaos
-- ----------------------------
DROP TABLE IF EXISTS `usuario_localizacaos`;
CREATE TABLE `usuario_localizacaos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `localizacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `usuario_localizacaos_usuario_id_foreign`(`usuario_id`) USING BTREE,
  INDEX `usuario_localizacaos_localizacao_id_foreign`(`localizacao_id`) USING BTREE,
  CONSTRAINT `usuario_localizacaos_localizacao_id_foreign` FOREIGN KEY (`localizacao_id`) REFERENCES `localizacaos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `usuario_localizacaos_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for vale_pedagios
-- ----------------------------
DROP TABLE IF EXISTS `vale_pedagios`;
CREATE TABLE `vale_pedagios`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mdfe_id` bigint(20) UNSIGNED NOT NULL,
  `cnpj_fornecedor` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnpj_fornecedor_pagador` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_compra` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(10, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `vale_pedagios_mdfe_id_foreign`(`mdfe_id`) USING BTREE,
  CONSTRAINT `vale_pedagios_mdfe_id_foreign` FOREIGN KEY (`mdfe_id`) REFERENCES `mdves` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for variacao_mercado_livres
-- ----------------------------
DROP TABLE IF EXISTS `variacao_mercado_livres`;
CREATE TABLE `variacao_mercado_livres`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade` decimal(10, 2) NOT NULL,
  `valor` decimal(12, 2) NOT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor_nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `variacao_mercado_livres_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `variacao_mercado_livres_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `variacao_mercado_livres_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `variacao_mercado_livres_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for variacao_modelo_items
-- ----------------------------
DROP TABLE IF EXISTS `variacao_modelo_items`;
CREATE TABLE `variacao_modelo_items`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `variacao_modelo_id` bigint(20) UNSIGNED NOT NULL,
  `nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `variacao_modelo_items_variacao_modelo_id_foreign`(`variacao_modelo_id`) USING BTREE,
  CONSTRAINT `variacao_modelo_items_variacao_modelo_id_foreign` FOREIGN KEY (`variacao_modelo_id`) REFERENCES `variacao_modelos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for variacao_modelos
-- ----------------------------
DROP TABLE IF EXISTS `variacao_modelos`;
CREATE TABLE `variacao_modelos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `descricao` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `variacao_modelos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `variacao_modelos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for veiculos
-- ----------------------------
DROP TABLE IF EXISTS `veiculos`;
CREATE TABLE `veiculos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `placa` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cor` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `marca` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rntrc` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `taf` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `renavam` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero_registro_estadual` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_carroceria` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_rodado` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tara` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `capacidade` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_nome` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_ie` varchar(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `proprietario_tp` int(11) NOT NULL,
  `funcionario_id` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `veiculos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `veiculos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for venda_suspensas
-- ----------------------------
DROP TABLE IF EXISTS `venda_suspensas`;
CREATE TABLE `venda_suspensas`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `total` decimal(12, 2) NOT NULL,
  `desconto` decimal(12, 2) NULL DEFAULT NULL,
  `acrescimo` decimal(12, 2) NULL DEFAULT NULL,
  `observacao` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tipo_pagamento` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `local_id` int(11) NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL,
  `funcionario_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `venda_suspensas_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `venda_suspensas_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `venda_suspensas_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `venda_suspensas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for venda_temporaria_itens
-- ----------------------------
DROP TABLE IF EXISTS `venda_temporaria_itens`;
CREATE TABLE `venda_temporaria_itens`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `venda_temporaria_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NOT NULL,
  `variacao_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `codigo` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade` decimal(10, 3) NOT NULL,
  `valor_unitario` decimal(10, 2) NOT NULL,
  `valor_subtotal` decimal(10, 2) NOT NULL,
  `ordem` int(11) NOT NULL DEFAULT 0,
  `dados_adicionais` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL CHECK (json_valid(`dados_adicionais`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `venda_temporaria_id`(`venda_temporaria_id`) USING BTREE,
  INDEX `produto_id`(`produto_id`) USING BTREE,
  CONSTRAINT `fk_venda_temporaria_itens_venda_temporaria_id` FOREIGN KEY (`venda_temporaria_id`) REFERENCES `venda_temporarias` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for venda_temporarias
-- ----------------------------
DROP TABLE IF EXISTS `venda_temporarias`;
CREATE TABLE `venda_temporarias`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario_id` bigint(20) UNSIGNED NOT NULL,
  `caixa_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `vendedor_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `total` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `desconto` decimal(10, 2) NULL DEFAULT 0.00,
  `acrescimo` decimal(10, 2) NULL DEFAULT 0.00,
  `observacao` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `dados_adicionais` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL CHECK (json_valid(`dados_adicionais`)),
  `data_criacao` timestamp NOT NULL DEFAULT current_timestamp(),
  `data_atualizacao` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `expiracao` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `usuario_id`(`usuario_id`) USING BTREE,
  INDEX `caixa_id`(`caixa_id`) USING BTREE,
  INDEX `data_criacao`(`data_criacao`) USING BTREE,
  INDEX `expiracao`(`expiracao`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for video_suportes
-- ----------------------------
DROP TABLE IF EXISTS `video_suportes`;
CREATE TABLE `video_suportes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pagina` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_video` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_servidor` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for woocommerce_configs
-- ----------------------------
DROP TABLE IF EXISTS `woocommerce_configs`;
CREATE TABLE `woocommerce_configs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `consumer_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `woocommerce_configs_empresa_id_foreign`(`empresa_id`) USING BTREE,
  CONSTRAINT `woocommerce_configs_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for woocommerce_item_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `woocommerce_item_pedidos`;
CREATE TABLE `woocommerce_item_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint(20) UNSIGNED NOT NULL,
  `produto_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `item_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_nome` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantidade` decimal(8, 2) NOT NULL,
  `valor_unitario` decimal(12, 2) NOT NULL,
  `sub_total` decimal(12, 2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `woocommerce_item_pedidos_pedido_id_foreign`(`pedido_id`) USING BTREE,
  INDEX `woocommerce_item_pedidos_produto_id_foreign`(`produto_id`) USING BTREE,
  CONSTRAINT `woocommerce_item_pedidos_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `woocommerce_pedidos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `woocommerce_item_pedidos_produto_id_foreign` FOREIGN KEY (`produto_id`) REFERENCES `produtos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for woocommerce_pedidos
-- ----------------------------
DROP TABLE IF EXISTS `woocommerce_pedidos`;
CREATE TABLE `woocommerce_pedidos`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint(20) UNSIGNED NOT NULL,
  `cliente_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `pedido_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rua` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `numero` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `bairro` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cidade` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `uf` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `cep` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `total` decimal(10, 2) NOT NULL,
  `valor_frete` decimal(10, 2) NOT NULL,
  `desconto` decimal(10, 2) NOT NULL,
  `observacao` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `nfe_id` int(11) NULL DEFAULT NULL,
  `tipo_pagamento` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `numero_pedido` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `venda_id` int(11) NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `woocommerce_pedidos_empresa_id_foreign`(`empresa_id`) USING BTREE,
  INDEX `woocommerce_pedidos_cliente_id_foreign`(`cliente_id`) USING BTREE,
  CONSTRAINT `woocommerce_pedidos_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `woocommerce_pedidos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
