@extends('layouts.app', ['title' => 'Editar Usuário'])
@section('content')

<div class="card mt-1">
    <div class="card-header">
        <h4>Editar Usuário</h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="{{ route('usuario-super.index') }}" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        @if(!isset($item))
            <div class="alert alert-danger">
                Usuário não encontrado. <a href="{{ route('usuario-super.index') }}">Voltar para lista</a>
            </div>
        @else
            {!!Form::open()->fill($item)
            ->put()
            ->route('usuario-super.update', [$item->id])
            ->multipart()
            !!}
            <div class="pl-lg-4">
                @include('usuarios_super._forms')
            </div>
            {!!Form::close()!!}
        @endif
    </div>
</div>
@endsection
