@extends('relatorios.default', ['title' => 'Relatório de Clientes'])

@section('css')
<style type="text/css">
    .summary-box {
        background-color: #eef2f7;
        border-left: 4px solid #3366cc;
        padding: 6px 10px;
        margin-bottom: 8px;
        font-size: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .summary-title {
        font-weight: bold;
        color: #333;
    }

    .summary-value {
        color: #3366cc;
        font-weight: bold;
        font-size: 11px;
    }

    .clients-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 10px;
        font-size: 7.8px;
    }

    .clients-table thead {
        background-color: #f1f1f1;
        text-transform: uppercase;
    }

    .clients-table th, .clients-table td {
        padding: 2px 4px;
        border: 1px solid #ccc;
    }

    .clients-table th {
        font-weight: 600;
        color: #2c3e50;
    }

    .clients-table td {
        vertical-align: top;
        color: #333;
    }

    .clients-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .document {
        font-family: 'Courier New', monospace;
        color: #555;
    }

    .city-info {
        color: #3366cc;
    }

    .text-right { text-align: right; }
    .text-center { text-align: center; }
</style>
@endsection

@section('content')

@if($tipo != '')
    <div class="summary-box">
        <div class="summary-title">Total vendido:</div>
        <div class="summary-value">{{ __moeda($data->sum('total')) }}</div>
    </div>
@endif

<table class="clients-table">
    <thead>
        <tr>
            <th style="width: 20%">Razão social</th>
            <th style="width: 15%">Nome fantasia</th>
            <th style="width: 12%">CPF/CNPJ</th>
            <th style="width: 10%">IE</th>
            <th style="width: 18%">Endereço</th>
            <th style="width: 10%">Cidade</th>
            <th style="width: 7%">Cadastrado</th>
            @if($tipo != '')
            <th style="width: 8%" class="text-right">Total vendido</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @foreach($data as $item)
        <tr>
            <td>{{ $item->razao_social ?: 'Não informado' }}</td>
            <td>{{ $item->nome_fantasia ?: 'Não informado' }}</td>
            <td class="document">{{ $item->cpf_cnpj ?: 'Não informado' }}</td>
            <td class="document">{{ $item->ie ?: 'Não informado' }}</td>
            <td>{{ $item->endereco ?: 'Não informado' }}</td>
            <td class="city-info">{{ $item->cidade?->info ?? 'Não informado' }}</td>
            <td class="text-center">{{ __data_pt($item->created_at) }}</td>
            @if($tipo != '')
            <td class="text-right">{{ __moeda($item->total) }}</td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@endsection
