@extends('layouts.app', ['title' => 'Painel eNPS'])

@section('css')
<style>
    .nps-card {
        position: relative;
        overflow: hidden;
        border-radius: 10px;
        transition: all 0.3s ease;
    }
    
    .nps-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    
    .nps-score {
        font-size: 2.5rem;
        font-weight: bold;
    }
    
    .nps-badge {
        position: absolute;
        top: 0;
        right: 0;
        padding: 8px 16px;
        border-bottom-left-radius: 10px;
    }
    
    .score-detrator {
        color: #dc3545;
    }
    
    .score-neutro {
        color: #ffc107;
    }
    
    .score-promotor {
        color: #198754;
    }
    
    .bar-detrator {
        background-color: #dc3545;
    }
    
    .bar-neutro {
        background-color: #ffc107;
    }
    
    .bar-promotor {
        background-color: #198754;
    }
    
    .stats-card {
        border-radius: 10px;
        border: none;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        transition: all 0.3s;
    }
    
    .stats-card:hover {
        box-shadow: 0 10px 15px rgba(0,0,0,0.1);
    }
    
    .stats-icon {
        width: 60px;
        height: 60px;
        line-height: 60px;
        text-align: center;
        border-radius: 50%;
        font-size: 24px;
    }
    
    .stats-value {
        font-size: 24px;
        font-weight: bold;
        margin: 10px 0;
    }
</style>
@endsection

@section('content')
<div class="container my-4">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Painel de Pesquisa eNPS</h5>
                    <div>
                        <a href="{{ route('nps.detalhes') }}" class="btn btn-sm btn-outline-primary">
                            <i class="ri-file-list-line"></i> Ver Respostas Detalhadas
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filtros -->
                    <form method="get" action="{{ route('nps.admin') }}" class="row g-3 mb-4">
                        <div class="col-md-4">
                            <label for="mes" class="form-label">Mês</label>
                            <select class="form-select" id="mes" name="mes" onchange="this.form.submit()">
                                @foreach($mesesDisponiveis as $value => $label)
                                    <option value="{{ $value }}" {{ $mes == $value ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="empresa_id" class="form-label">Empresa</label>
                            <select class="form-select" id="empresa_id" name="empresa_id" onchange="this.form.submit()">
                                <option value="">Todas as Empresas</option>
                                @foreach($empresas as $empresa)
                                    <option value="{{ $empresa->id }}" {{ $empresaId == $empresa->id ? 'selected' : '' }}>{{ $empresa->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="ri-filter-line"></i> Filtrar
                            </button>
                        </div>
                    </form>
                    
                    <!-- Cards de estatísticas -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card stats-card mb-4">
                                <div class="card-body text-center">
                                    <div class="stats-icon bg-primary-light text-primary mx-auto">
                                        <i class="ri-user-voice-line"></i>
                                    </div>
                                    <div class="stats-value">{{ $totalRespondentes }}</div>
                                    <div class="stats-label">Respondentes</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stats-card mb-4">
                                <div class="card-body text-center">
                                    <div class="stats-icon bg-success-light text-success mx-auto">
                                        <i class="ri-emotion-happy-line"></i>
                                    </div>
                                    <div class="stats-value">{{ $promotores }}</div>
                                    <div class="stats-label">Promotores (9-10)</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stats-card mb-4">
                                <div class="card-body text-center">
                                    <div class="stats-icon bg-warning-light text-warning mx-auto">
                                        <i class="ri-emotion-normal-line"></i>
                                    </div>
                                    <div class="stats-value">{{ $neutros }}</div>
                                    <div class="stats-label">Neutros (7-8)</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card stats-card mb-4">
                                <div class="card-body text-center">
                                    <div class="stats-icon bg-danger-light text-danger mx-auto">
                                        <i class="ri-emotion-unhappy-line"></i>
                                    </div>
                                    <div class="stats-value">{{ $detratores }}</div>
                                    <div class="stats-label">Detratores (0-6)</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Score NPS Geral -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card nps-card mb-4">
                                <div class="card-body text-center py-5">
                                    <h6 class="mb-3">Score NPS Geral</h6>
                                    <div class="nps-score 
                                        @if($npsScore < 0) score-detrator
                                        @elseif($npsScore < 50) score-neutro
                                        @else score-promotor
                                        @endif">
                                        {{ $npsScore }}
                                    </div>
                                    <div class="progress mt-4" style="height: 20px;">
                                        @php
                                            // Calcular porcentagens
                                            $pDetratores = $totalRespondentes > 0 ? ($detratores / $totalRespondentes) * 100 : 0;
                                            $pNeutros = $totalRespondentes > 0 ? ($neutros / $totalRespondentes) * 100 : 0;
                                            $pPromotores = $totalRespondentes > 0 ? ($promotores / $totalRespondentes) * 100 : 0;
                                        @endphp
                                        <div class="progress-bar bar-detrator" role="progressbar" style="width: {{ $pDetratores }}%" aria-valuenow="{{ $pDetratores }}" aria-valuemin="0" aria-valuemax="100">{{ round($pDetratores) }}%</div>
                                        <div class="progress-bar bar-neutro" role="progressbar" style="width: {{ $pNeutros }}%" aria-valuenow="{{ $pNeutros }}" aria-valuemin="0" aria-valuemax="100">{{ round($pNeutros) }}%</div>
                                        <div class="progress-bar bar-promotor" role="progressbar" style="width: {{ $pPromotores }}%" aria-valuenow="{{ $pPromotores }}" aria-valuemin="0" aria-valuemax="100">{{ round($pPromotores) }}%</div>
                                    </div>
                                    <div class="d-flex justify-content-between mt-2">
                                        <small class="text-danger">Detratores</small>
                                        <small class="text-warning">Neutros</small>
                                        <small class="text-success">Promotores</small>
                                    </div>
                                </div>
                                
                                <div class="nps-badge 
                                    @if($npsScore < 0) bg-danger
                                    @elseif($npsScore < 50) bg-warning
                                    @else bg-success
                                    @endif text-white">
                                    @if($npsScore < 0)
                                        Crítico
                                    @elseif($npsScore < 30)
                                        Melhorias Necessárias
                                    @elseif($npsScore < 50)
                                        Bom
                                    @elseif($npsScore < 70)
                                        Muito Bom
                                    @else
                                        Excelente
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Estatísticas por Empresa -->
                    @if($estatisticasPorEmpresa->count() > 0)
                    <div class="row">
                        <div class="col-12">
                            <h5 class="mb-3">Resultados por Empresa</h5>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>Empresa</th>
                                            <th class="text-center">Respondentes</th>
                                            <th class="text-center">Detratores</th>
                                            <th class="text-center">Neutros</th>
                                            <th class="text-center">Promotores</th>
                                            <th class="text-center">Média</th>
                                            <th class="text-center">Score NPS</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($estatisticasPorEmpresa as $est)
                                        <tr>
                                            <td>{{ $est['nome_empresa'] }}</td>
                                            <td class="text-center">{{ $est['total_respondentes'] }}</td>
                                            <td class="text-center text-danger">{{ $est['detratores'] }}</td>
                                            <td class="text-center text-warning">{{ $est['neutros'] }}</td>
                                            <td class="text-center text-success">{{ $est['promotores'] }}</td>
                                            <td class="text-center fw-bold">{{ $est['media_notas'] }}</td>
                                            <td class="text-center">
                                                <span class="badge 
                                                    @if($est['nps_score'] < 0) bg-danger
                                                    @elseif($est['nps_score'] < 50) bg-warning
                                                    @else bg-success
                                                    @endif">
                                                    {{ $est['nps_score'] }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <!-- Informações sobre Usuários e Empresas que Ignoraram a Pesquisa -->
                    @if($pesquisasIgnoradas->count() > 0)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">Usuários e Empresas que Ignoraram a Pesquisa</h5>
                                </div>
                                <div class="card-body">
                                    <!-- Estatística de Ignorados -->
                                    <div class="alert alert-info mb-4">
                                        <div class="d-flex align-items-center">
                                            <div class="stats-icon bg-info-light text-info me-3" style="width: 50px; height: 50px; line-height: 50px; text-align: center; border-radius: 50%;">
                                                <i class="ri-close-circle-line fs-4"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">Pesquisas Ignoradas: <span class="badge bg-info">{{ $totalIgnorados }}</span></h6>
                                                <p class="mb-0">
                                                    @if($totalRespondentes + $totalIgnorados > 0)
                                                        {{ round(($totalIgnorados / ($totalRespondentes + $totalIgnorados)) * 100, 1) }}% dos usuários optaram por ignorar a pesquisa neste período.
                                                    @else
                                                        Nenhuma resposta registrada no período.
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Tabela de Ignorados por Empresa -->
                                    @if($ignoradosPorEmpresa->count() > 0)
                                    <h6 class="mb-3">Por Empresa</h6>
                                    <div class="table-responsive mb-4">
                                        <table class="table table-sm table-striped table-hover">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>Empresa</th>
                                                    <th class="text-center">Usuários que Ignoraram</th>
                                                    <th class="text-center">Percentual</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($ignoradosPorEmpresa as $item)
                                                <tr>
                                                    <td>{{ $item['nome_empresa'] }}</td>
                                                    <td class="text-center">{{ $item['total_ignorados'] }}</td>
                                                    <td class="text-center">
                                                        <div class="progress" style="height: 20px;">
                                                            <div class="progress-bar bg-info" role="progressbar" style="width: {{ $item['percentual'] }}%" aria-valuenow="{{ $item['percentual'] }}" aria-valuemin="0" aria-valuemax="100">{{ $item['percentual'] }}%</div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @endif
                                    
                                    <!-- Lista de Usuários que Ignoraram -->
                                    <h6 class="mb-3">Detalhes dos Usuários</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped table-hover">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>Nome do Usuário</th>
                                                    <th>Email</th>
                                                    <th>Empresa</th>
                                                    <th class="text-center">Data</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($pesquisasIgnoradas as $ignorado)
                                                <tr>
                                                    <td>{{ $ignorado->usuario->name ?? 'N/A' }}</td>
                                                    <td>{{ $ignorado->usuario->email ?? 'N/A' }}</td>
                                                    <td>{{ $ignorado->empresa->nome ?? 'N/A' }}</td>
                                                    <td class="text-center">{{ $ignorado->created_at->format('d/m/Y H:i') }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <!-- Gráfico do NPS -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5>Distribuição de Notas</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="npsChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Dados para o gráfico de distribuição de notas
        const ctx = document.getElementById('npsChart').getContext('2d');
        
        // Contagem de cada nota (0 a 10)
        const notasCounts = Array(11).fill(0);
        
        @foreach($pesquisas->where('respondido', true) as $pesquisa)
            @if(isset($pesquisa->nota))
                notasCounts[{{ $pesquisa->nota }}]++;
            @endif
        @endforeach
        
        const npsChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
                datasets: [{
                    label: 'Quantidade de Respostas',
                    data: notasCounts,
                    backgroundColor: [
                        // Cores para detratores (0-6)
                        '#dc3545', '#dc3545', '#dc3545', '#dc3545', '#dc3545', '#dc3545', '#dc3545',
                        // Cores para neutros (7-8)
                        '#ffc107', '#ffc107',
                        // Cores para promotores (9-10)
                        '#198754', '#198754'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Quantidade de Respostas'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Nota'
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            title: function(tooltipItems) {
                                const nota = tooltipItems[0].label;
                                let categoria = 'Detrator';
                                if (nota >= 9) {
                                    categoria = 'Promotor';
                                } else if (nota >= 7) {
                                    categoria = 'Neutro';
                                }
                                return `Nota ${nota} (${categoria})`;
                            }
                        }
                    }
                }
            }
        });
    });
</script>
@endsection 