<!DOCTYPE html>
<html>
<head>
    <title>Comprovante de Suprimento</title>
    <style type="text/css">
        @page {
            margin: 0px;
        }
        body {
            font-family: 'Arial';
            font-size: 12px;
            margin: 5px;
        }
        .center {
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        td {
            padding: 1px;
        }
        hr {
            border: 1px dashed black;
        }
        .text-small {
            font-size: 11px;
        }
    </style>
</head>
<body>
    <div class="center">
        <h4 style="margin-bottom: 0px;">{{ $empresa->razao_social }}</h4>
        <span>CNPJ: {{ $empresa->cpf_cnpj }}</span><br>
        @if(isset($empresa->endereco) && $empresa->endereco)
        <span>{{ $empresa->endereco->logradouro ?? 'N/D' }}, {{ $empresa->endereco->numero ?? 'S/N' }} - {{ $empresa->endereco->bairro ?? 'N/D' }}</span><br>
        <span>{{ $empresa->endereco->cidade ?? 'N/D' }}/{{ $empresa->endereco->estado ?? 'N/D' }}</span><br>
        @else
        <span>Endereço não disponível</span><br>
        @endif
        <hr>
        <h4 style="margin-bottom: 5px;">COMPROVANTE DE SUPRIMENTO</h4>
    </div>
    
    <table>
        <tr>
            <td class="bold">Data:</td>
            <td>{{ \Carbon\Carbon::parse($suprimento->created_at)->format('d/m/Y H:i:s') }}</td>
        </tr>
        <tr>
            <td class="bold">Valor:</td>
            <td>R$ {{ number_format($suprimento->valor, 2, ',', '.') }}</td>
        </tr>
        <tr>
            <td class="bold">Forma Pagto:</td>
            <td>
                @php
                    $tipos = [
                        '01' => 'Dinheiro',
                        '02' => 'Cheque',
                        '03' => 'Cartão de Crédito',
                        '04' => 'Cartão de Débito',
                        '05' => 'Crédito Loja',
                        '10' => 'Vale Alimentação',
                        '11' => 'Vale Refeição',
                        '12' => 'Vale Presente',
                        '13' => 'Vale Combustível',
                        '15' => 'Boleto Bancário',
                        '16' => 'Depósito Bancário',
                        '17' => 'PIX',
                        '99' => 'Outros'
                    ];
                @endphp
                {{ $tipos[$suprimento->tipo_pagamento] ?? 'N/D' }}
            </td>
        </tr>
        @if($suprimento->observacao)
        <tr>
            <td class="bold">Observação:</td>
            <td>{{ $suprimento->observacao }}</td>
        </tr>
        @endif
        <tr>
            <td class="bold">Operador:</td>
            <td>{{ Auth::user()->nome }}</td>
        </tr>
    </table>
    
    <hr>
    <div class="center text-small">
        <span>Documento sem valor fiscal</span><br>
        <span>Emitido em {{ date('d/m/Y H:i:s') }}</span>
    </div>
</body>
</html>