<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprovante de Consignação #{{ $consignacao->numero_consignacao }}</title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none !important; }
        }
        
        body {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            line-height: 1.2;
            margin: 0;
            padding: 10px;
        }
        
        .header {
            text-align: center;
            border-bottom: 1px solid #000;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        
        .empresa-nome {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .empresa-info {
            font-size: 10px;
            margin-bottom: 5px;
        }
        
        .titulo {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 15px 0;
            text-transform: uppercase;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        
        .info-label {
            font-weight: bold;
        }
        
        .cliente-info {
            border: 1px solid #000;
            padding: 8px;
            margin: 10px 0;
        }
        
        .cliente-titulo {
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: left;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: center;
        }
        
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-bold { font-weight: bold; }
        
        .totais {
            border-top: 2px solid #000;
            padding-top: 10px;
            margin-top: 15px;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        
        .total-final {
            font-size: 14px;
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
        }
        
        .observacoes {
            border: 1px solid #000;
            padding: 8px;
            margin: 15px 0;
            min-height: 60px;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
        }
        
        .assinaturas {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
        }
        
        .assinatura {
            text-align: center;
            width: 45%;
        }
        
        .linha-assinatura {
            border-top: 1px solid #000;
            margin-top: 30px;
            padding-top: 5px;
        }
        
        .btn-print {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            padding: 10px 20px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        
        .btn-print:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <button class="btn-print no-print" onclick="window.print()">
        🖨️ Imprimir
    </button>
    
    <div class="header">
        <div class="empresa-nome">{{ config('app.name', 'Sistema ERP') }}</div>
        <div class="empresa-info">
            {{ config('app.address', 'Endereço da Empresa') }}<br>
            Tel: {{ config('app.phone', '(00) 0000-0000') }} | 
            Email: {{ config('app.email', 'contato@empresa.com') }}
        </div>
    </div>
    
    <div class="titulo">Comprovante de Consignação</div>
    
    <div class="info-row">
        <span class="info-label">Número:</span>
        <span>{{ $consignacao->numero_consignacao }}</span>
    </div>
    
    <div class="info-row">
        <span class="info-label">Data:</span>
        <span>{{ $consignacao->data_consignacao->format('d/m/Y H:i') }}</span>
    </div>
    
    <div class="info-row">
        <span class="info-label">Vencimento:</span>
        <span>{{ $consignacao->data_vencimento ? $consignacao->data_vencimento->format('d/m/Y') : 'Não definido' }}</span>
    </div>
    
    <div class="info-row">
        <span class="info-label">Vendedor:</span>
        <span>{{ $consignacao->funcionario->nome ?? 'Não informado' }}</span>
    </div>
    
    <div class="cliente-info">
        <div class="cliente-titulo">Dados do Cliente</div>
        <div><strong>Nome:</strong> {{ $consignacao->cliente->nome }}</div>
        <div><strong>CPF/CNPJ:</strong> {{ $consignacao->cliente->cpf_cnpj }}</div>
        <div><strong>Telefone:</strong> {{ $consignacao->cliente->telefone ?? 'Não informado' }}</div>
        <div><strong>Endereço:</strong> {{ $consignacao->cliente->endereco ?? 'Não informado' }}</div>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>Produto</th>
                <th>Qtd. Consignada</th>
                <th>Qtd. Vendida</th>
                <th>Qtd. Devolvida</th>
                <th>Valor Unit.</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($consignacao->itens as $index => $item)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>
                    <strong>{{ $item->descricao }}</strong>
                    @if($item->produto->codigo)
                        <br><small>Cód: {{ $item->produto->codigo }}</small>
                    @endif
                </td>
                <td class="text-center">{{ number_format($item->quantidade, 3, ',', '.') }}</td>
                <td class="text-center">{{ number_format($item->quantidade_vendida, 3, ',', '.') }}</td>
                <td class="text-center">{{ number_format($item->quantidade_devolvida, 3, ',', '.') }}</td>
                <td class="text-right">{{ __moeda($item->valor_unitario) }}</td>
                <td class="text-right">{{ __moeda($item->sub_total) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="totais">
        <div class="total-row">
            <span class="info-label">Quantidade Total Consignada:</span>
            <span>{{ number_format($consignacao->itens->sum('quantidade'), 3, ',', '.') }}</span>
        </div>
        <div class="total-row">
            <span class="info-label">Quantidade Total Vendida:</span>
            <span>{{ number_format($consignacao->itens->sum('quantidade_vendida'), 3, ',', '.') }}</span>
        </div>
        <div class="total-row">
            <span class="info-label">Quantidade Total Devolvida:</span>
            <span>{{ number_format($consignacao->itens->sum('quantidade_devolvida'), 3, ',', '.') }}</span>
        </div>
        <div class="total-row total-final">
            <span class="info-label">VALOR TOTAL DA CONSIGNAÇÃO:</span>
            <span>{{ __moeda($consignacao->valor_total) }}</span>
        </div>
    </div>
    
    @if($consignacao->observacao)
    <div class="observacoes">
        <div class="cliente-titulo">Observações</div>
        <div>{{ $consignacao->observacao }}</div>
    </div>
    @endif
    
    <div class="assinaturas">
        <div class="assinatura">
            <div class="linha-assinatura">Assinatura do Cliente</div>
        </div>
        <div class="assinatura">
            <div class="linha-assinatura">Assinatura do Vendedor</div>
        </div>
    </div>
    
    <div class="footer">
        <p>Este documento é um comprovante de consignação e não substitui uma nota fiscal.</p>
        <p>Impresso em: {{ now()->format('d/m/Y H:i:s') }}</p>
        <p>Sistema ERP - {{ config('app.name', 'Sistema ERP') }}</p>
    </div>
</body>
</html> 