@extends('layouts.app', ['title' => 'Converter Consignação em Venda'])
@section('content')

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-8">
            <h4 class="mb-0">
                <i class="ri-exchange-line me-2"></i>
                Converter Consignação <strong>#{{ $consignacao->numero_consignacao }}</strong> em Venda
            </h4>
            <div class="small text-muted">
                Cliente: {{ $consignacao->cliente->nome }} | 
                Valor Total: <span class="text-success">{{ __moeda($consignacao->valor_total) }}</span>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-secondary">
                <i class="ri-arrow-left-line me-1"></i> Voltar
            </a>
        </div>
    </div>

    {!! Form::open()->post()->route('consignacao.convert', $consignacao->id)->id('form-convert-consignacao') !!}

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-3">
                <div class="card-header">
                    <strong>Itens da Consignação</strong>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Qtd. Vendida</th>
                                    <th>Valor Unitário</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($consignacao->itens as $index => $item)
                                @if($item->quantidade_vendida > 0)
                                <tr>
                                    <td>
                                        <strong>{{ $item->descricao }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $item->produto->codigo ?? '' }}</small>
                                    </td>
                                    <td>{{ number_format($item->quantidade_vendida, 3, ',', '.') }}</td>
                                    <td>{{ __moeda($item->valor_unitario) }}</td>
                                    <td>{{ __moeda($item->quantidade_vendida * $item->valor_unitario) }}</td>
                                </tr>
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <strong>Configurações da Venda</strong>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tipo de Documento</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="tipo_documento" id="tipo_nfce" value="nfce" checked>
                                    <label class="form-check-label" for="tipo_nfce">
                                        NFCe (Nota Fiscal de Consumidor Eletrônica)
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="tipo_documento" id="tipo_comprovante" value="comprovante">
                                    <label class="form-check-label" for="tipo_comprovante">
                                        Comprovante Não Fiscal
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Forma de Pagamento</label>
                                <select name="forma_pagamento" class="form-select" required>
                                    <option value="">Selecione...</option>
                                    <option value="dinheiro">Dinheiro</option>
                                    <option value="cartao_credito">Cartão de Crédito</option>
                                    <option value="cartao_debito">Cartão de Débito</option>
                                    <option value="pix">PIX</option>
                                    <option value="transferencia">Transferência</option>
                                    <option value="boleto">Boleto</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Condição de Pagamento</label>
                                <select name="condicao_pagamento" class="form-select" required>
                                    <option value="">Selecione...</option>
                                    <option value="avista">À Vista</option>
                                    <option value="prazo">A Prazo</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Parcelas</label>
                                <input type="number" name="parcelas" class="form-control" value="1" min="1" max="12">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações da Venda</label>
                        <textarea name="observacao_venda" class="form-control" rows="3" placeholder="Observações sobre a venda..."></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header">
                    <strong>Resumo da Conversão</strong>
                </div>
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-6">Cliente:</div>
                        <div class="col-6"><strong>{{ $consignacao->cliente->nome }}</strong></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6">Vendedor:</div>
                        <div class="col-6"><strong>{{ $consignacao->funcionario->nome ?? '--' }}</strong></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6">Itens:</div>
                        <div class="col-6"><strong>{{ $consignacao->itens->where('quantidade_vendida', '>', 0)->count() }}</strong></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-6">Qtd. Total:</div>
                        <div class="col-6"><strong>{{ number_format($consignacao->itens->sum('quantidade_vendida'), 3, ',', '.') }}</strong></div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-6"><strong>Valor Total:</strong></div>
                        <div class="col-6"><strong class="text-success fs-5">{{ __moeda($consignacao->valor_total) }}</strong></div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <strong>Ações</strong>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="ri-check-line me-2"></i> Converter em Venda
                        </button>
                        <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-secondary">
                            <i class="ri-close-line me-2"></i> Cancelar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {!! Form::close() !!}
</div>

@endsection

@section('js')
<script>
$(document).ready(function() {
    // Mostrar/ocultar campo de parcelas baseado na condição de pagamento
    $('select[name="condicao_pagamento"]').on('change', function() {
        const parcelasField = $('input[name="parcelas"]');
        if ($(this).val() === 'avista') {
            parcelasField.val(1).prop('disabled', true);
        } else {
            parcelasField.prop('disabled', false);
        }
    });

    // Validação do formulário
    $('#form-convert-consignacao').on('submit', function(e) {
        const formaPagamento = $('select[name="forma_pagamento"]').val();
        const condicaoPagamento = $('select[name="condicao_pagamento"]').val();
        
        if (!formaPagamento) {
            alert('Selecione uma forma de pagamento!');
            e.preventDefault();
            return false;
        }
        
        if (!condicaoPagamento) {
            alert('Selecione uma condição de pagamento!');
            e.preventDefault();
            return false;
        }
        
        // Confirmar conversão
        if (!confirm('Tem certeza que deseja converter esta consignação em venda? Esta ação não pode ser desfeita.')) {
            e.preventDefault();
            return false;
        }
    });
});
</script>
@endsection 