<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usuario_id')->nullable()->constrained('users');
            $table->foreignId('empresa_id')->nullable()->constrained('empresas');
            $table->timestamp('login_time')->nullable();
            $table->timestamp('logout_time')->nullable();
            $table->integer('session_duration')->nullable()->comment('Duração da sessão em segundos');
            $table->string('ip', 50)->nullable();
            $table->string('user_agent', 255)->nullable();
            $table->integer('features_used')->default(0)->comment('Número de funcionalidades usadas na sessão');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_sessions');
    }
};
