<?php

namespace App\Observers;

use App\Models\Nfe;
use App\Models\TaxaPagamento;

class NfeTaxaObserver
{
    /**
     * Handle the Nfe "created" event.
     */
    public function created(Nfe $nfe)
    {
        if (!empty($nfe->tipo_pagamento) && !empty($nfe->empresa_id)) {
            $bandeira_cartao = $nfe->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $nfe->empresa_id)
                ->where('tipo_pagamento', $nfe->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $nfe->taxa_percentual = $taxa->taxa;
                $nfe->save();
            }
        }
    }
} 