<?php
session_start();
require_once 'config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit;
}

try {
    $database = new Database();
    $pdo = $database->getConnection();

    // Prepara a query de inserção
    $query = "INSERT INTO cheques (
        user_id, cliente, numero_cheque, banco, valor, 
        taxa_juros, data_troca, data_vencimento, 
        dias, juros, valor_liquido, status_pagamento
    ) VALUES (
        :user_id, :cliente, :numero_cheque, :banco, :valor,
        :taxa_juros, :data_troca, :data_vencimento,
        :dias, :juros, :valor_liquido, 'pendente'
    )";

    $stmt = $pdo->prepare($query);

    // Executa a query com os dados recebidos
    $success = $stmt->execute([
        'user_id' => $_SESSION['user_id'],
        'cliente' => $_POST['cliente'],
        'numero_cheque' => $_POST['numero_cheque'],
        'banco' => $_POST['banco'],
        'valor' => $_POST['valor'],
        'taxa_juros' => $_POST['taxa_juros'],
        'data_troca' => $_POST['data_troca'],
        'data_vencimento' => $_POST['data_vencimento'],
        'dias' => $_POST['dias'],
        'juros' => $_POST['juros'],
        'valor_liquido' => $_POST['valor_liquido']
    ]);

    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Cheque salvo com sucesso']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao salvar o cheque']);
    }

} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro no banco de dados: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
}
?>
