<?php
require_once __DIR__ . '/config.php';

header('X-Content-Type-Options: nosniff');

function respond($success, $error = null) {
    $isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
    if ($isAjax) {
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['success' => $success, 'error' => $error]);
        exit;
    } else {
        $qs = $success ? 'status=success' : ('status=error&msg=' . urlencode($error ?? 'Erro'));
        header('Location: index.php?' . $qs);
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    respond(false, 'Método inválido');
}

if (!isset($_FILES['video']) || $_FILES['video']['error'] !== UPLOAD_ERR_OK) {
    respond(false, 'Arquivo não enviado ou inválido');
}

$file = $_FILES['video'];
// Sem verificação de tamanho máximo aqui; dependerá de upload_max_filesize/post_max_size

$allowedExts = ['mp4', 'webm'];
$originalName = $file['name'];
$ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
if (!in_array($ext, $allowedExts, true)) {
    respond(false, 'Formato não suportado. Use .mp4 ou .webm');
}

$uploadsDir = __DIR__ . '/uploads';
if (!is_dir($uploadsDir)) {
    mkdir($uploadsDir, 0777, true);
}

// Sanitize filename and make unique
$base = pathinfo($originalName, PATHINFO_FILENAME);
$base = preg_replace('/[^a-zA-Z0-9_\-]+/', '_', $base);
$unique = $base . '_' . uniqid('', true) . '.' . $ext;
$destPath = $uploadsDir . '/' . $unique;

if (!move_uploaded_file($file['tmp_name'], $destPath)) {
    respond(false, 'Falha ao mover o arquivo');
}

$relativePath = 'uploads/' . $unique;

$mysqli = get_db_connection();
if (!$mysqli) {
    respond(false, 'Falha na conexão com o banco');
}

$stmt = $mysqli->prepare('INSERT INTO videos (nome_arquivo, caminho) VALUES (?, ?)');
if (!$stmt) {
    respond(false, 'Falha ao preparar inserção');
}
$stmt->bind_param('ss', $originalName, $relativePath);
$ok = $stmt->execute();
$stmt->close();

if (!$ok) {
    respond(false, 'Falha ao salvar no banco');
}

respond(true);