<!doctype html>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($title); ?></title>

        <!-- Fonts -->
        <link rel="dns-prefetch" href="//fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

        <!-- Scripts -->

        <link href="/assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />
        <link href="/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <script src="/assets/js/config.js"></script>
        <link rel="shortcut icon" href="/logo-sm.png">

        <?php echo $__env->yieldContent('css'); ?>

    </head>
    <body class="authentication-bg pb-0">

        <?php if(session()->has('flash_success')): ?>
        <div class="container">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Sucesso!</strong> <?php echo e(session()->get('flash_success')); ?>


            </div>
        </div>
        <?php endif; ?>

        <?php if(session()->has('flash_error')): ?>
        <div class="container">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Sucesso!</strong> <?php echo e(session()->get('flash_error')); ?>


            </div>
        </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe" crossorigin="anonymous"></script>

        <script src="/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="/assets/js/app.min.js"></script>

        <script src='https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js'></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.15/jquery.mask.min.js"></script>
        <!-- <script type="text/javascript" src="/js/main.js"></script> -->

        <?php echo $__env->yieldContent('js'); ?>

    </body>
    </html>
<?php /**PATH C:\laragon\www\erp\resources\views/layouts/header_auth.blade.php ENDPATH**/ ?>