<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Tenant;
use Database\Seeders\ModuleSeeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Criar os tenants
        $tenantPrincipal = Tenant::create([
            'name' => 'Empresa Principal', // empresa 1
            'slug' => 'empresa-principal',
        ]);

        $tenantUsuario1 = Tenant::create([
            'name' => 'Empresa do Usuário 1', // empresa 2
            'slug' => 'empresa-do-usuario-1',
        ]);

        $tenantUsuario2 = Tenant::create([
            'name' => 'Empresa do Usuário 2', // empresa 3
            'slug' => 'empresa-do-usuario-2',
        ]);

        // Criar usuários
        User::create([
            'name' => 'Administrador', // usuario 1
            'email' => 'valtenci@icloud.com',
            'password' => Hash::make('Valtenci1@'),
            'tenant_id' => $tenantPrincipal->id,
            'role' => 'admin',
        ]);

        User::create([
            'name' => 'Usuário 1', // usuario 2
            'email' => 'usuario1@gmail.com',
            'password' => Hash::make('Usuario1'),
            'tenant_id' => $tenantUsuario1->id,
            'role' => 'gerente',
        ]);

        User::create([
            'name' => 'Usuário 2', // usuario 3
            'email' => 'usuario2@gmail.com',
            'password' => Hash::make('Usuario2'),
            'tenant_id' => $tenantUsuario2->id,
            'role' => 'operador',
        ]);

        // Executar o ModuleSeeder
        $this->call(ModuleSeeder::class);
    }
}
