<?php

namespace App\Traits;

trait HasModulePermissions
{
    public function hasPermissionTo(string $module): bool
    {
        return $this->canAccessModule($module);
    }

    public function hasAnyPermission(array $modules): bool
    {
        foreach ($modules as $module) {
            if ($this->hasPermissionTo($module)) {
                return true;
            }
        }
        return false;
    }

    public function hasAllPermissions(array $modules): bool
    {
        foreach ($modules as $module) {
            if (!$this->hasPermissionTo($module)) {
                return false;
            }
        }
        return true;
    }
}
