<?php

namespace App\Filament\User\Resources\ModuleResource\Pages;

use App\Filament\User\Resources\ModuleResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;

class CreateModule extends CreateRecord
{
    protected static string $resource = ModuleResource::class;

    public function getTitle(): string
    {
        return 'Novo Módulo';
    }  

    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Módulo')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Módulo criado!')
            ->body('O novo módulo foi cadastrado com sucesso')
            ->duration(5000);
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    } 

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
