<?php

namespace App\Filament\User\Resources\ClientResource\Pages;

use App\Filament\User\Resources\ClientResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Filament\Notifications\Actions\Action as NotificationAction;

class CreateClient extends CreateRecord
{
    // titulo
    public function getTitle(): string
    {
        return 'Novo Cliente';
    }

    // botao criar cliente
    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Cliente')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    // botao criar e criar outro
    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    // botao cancelar
    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected static string $resource = ClientResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Cliente criado!')
            ->body('O novo cliente foi cadastrado com sucesso')
            ->duration(5000);
    }
}
