<?php

namespace App\Filament\User\Resources;

use App\Filament\User\Resources\CategoriaResource\Pages;
use App\Filament\User\Resources\CategoriaResource\RelationManagers;
use App\Models\Categoria;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Notifications\Notification;


class CategoriaResource extends Resource
{
    protected static ?string $model = Categoria::class;
    // aqui controle de visibilidade do menu 
    protected static ?string $navigationIcon = 'heroicon-o-tag';
    protected static ?string $navigationGroup = 'Cadastros';
    protected static ?int $navigationSort = 2;
    protected static ?string $pluralLabel = 'Categorias';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('nome')
                    ->required()
                    ->maxLength(50),
                // PEGA APENAS O TENANT DO USUARIO LOGADO
                Select::make('tenant_id')
                    ->label('Empresa do Cliente')
                    ->relationship('tenant', 'name', fn ($query) => $query->where('id', auth()->user()->tenant_id))
                    ->required()
                    ->preload()
                    ->searchable()
                    ->default(auth()->user()->tenant_id)
                    ->disabled()
                    ->dehydrated(), // NAO PODE SER ALTERADO


            ]);
    }
 
    public static function table(Table $table): Table
    {
        return $table
        // pega apenas os clientes do tenant do usuario logado
        ->modifyQueryUsing(fn (Builder $query) => $query->where('tenant_id', auth()->user()->tenant_id))
            ->columns([
                TextColumn::make('nome')
                    ->searchable(),
                TextColumn::make('tenant.name')
                    ->label('Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('created_at')->label('Data de Criação')
                    ->searchable()
                    ->dateTime('d/m/Y'),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make()
                ->tooltip('Editar')
                    ->iconButton()
                    ->color('warning')
                    ->icon('heroicon-o-pencil-square'),
                DeleteAction::make()
                ->tooltip('Excluir')
                    ->iconButton()
                    ->color('danger')
                    ->icon('heroicon-o-trash')
                    ->modalHeading('Excluir Categoria')
                    ->modalDescription('Tem certeza que deseja excluir esta categoria? Esta ação não poderá ser desfeita.')
                    ->modalSubmitActionLabel('Sim, excluir')
                    ->modalCancelActionLabel('Não, cancelar')
                    ->successNotification(null)
                    ->after(function() {
                        Notification::make()
                            ->success()
                            ->color('success')
                            ->icon('heroicon-o-check-circle')
                            ->title('Categoria excluída!')
                            ->body('A categoria foi removida com sucesso')
                            ->send();
                    }),
            ]) 
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('Excluir Selecionados')
                        ->modalHeading('Excluir Categorias Selecionadas')
                        ->modalDescription('Tem certeza que deseja excluir as categorias selecionadas? Esta ação não poderá ser desfeita.')
                        ->modalSubmitActionLabel('Sim, excluir')
                        ->modalCancelActionLabel('Não, cancelar')
                        ->successNotification(null)
                        ->after(function() {
                            Notification::make()
                                ->success()
                                ->color('success')
                                ->icon('heroicon-o-check-circle')
                                ->title('Categorias excluídas!')
                                ->body('As categorias foram removidas com sucesso')
                                ->send();
                        })
                ])
                ->label('Ações em massa'),
            ]);
    }

    // public static function getRelations(): array
    // {
    //     return [
    //         //
    //     ];
    // }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCategorias::route('/'),
            'create' => Pages\CreateCategoria::route('/create'),
            'edit' => Pages\EditCategoria::route('/{record}/edit'),
        ];
    }
}
