<?php

namespace App\Enums;

use App\Models\RoleModule;

enum UserRole: string
{
    case ADMIN = 'admin';
    case GERENTE = 'gerente';
    case OPERADOR = 'operador';

    public function label(): string
    {
        return match($this) {
            self::ADMIN => 'Administrador',
            self::GERENTE => 'Gerente',
            self::OPERADOR => 'Operador',
        };
    }

    public function canAccessModule(string $module): bool
    {
        if ($this === self::ADMIN) {
            return true; // Admin sempre pode acessar tudo
        }

        // Verifica se existe permissão para o role no tenant atual
        return RoleModule::where('role', $this->value)
            ->where('tenant_id', auth()->user()->tenant_id)
            ->whereHas('module', function ($query) use ($module) {
                $query->where('name', $module)
                      ->where('is_active', true);
            })
            ->exists();
    }
}
