<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

$id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
if (!$id) {
    header('Location: index.php');
    exit;
}

try {
    $pdo->beginTransaction();

    // Verificar se há parcelas pagas
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM installments WHERE movement_id = ? AND status = 'paid'");
    $stmt->execute([$id]);
    $hasPaidInstallments = $stmt->fetch()['count'] > 0;

    if ($hasPaidInstallments) {
        header('Location: index.php?error=has_paid_installments');
        exit;
    }

    // Excluir parcelas
    $stmt = $pdo->prepare("DELETE FROM installments WHERE movement_id = ?");
    $stmt->execute([$id]);

    // Excluir movimento
    $stmt = $pdo->prepare("DELETE FROM movements WHERE id = ?");
    $stmt->execute([$id]);
    
    $pdo->commit();
    header('Location: index.php?success=deleted');
    exit;
} catch (PDOException $e) {
    $pdo->rollBack();
    header('Location: index.php?error=delete_failed');
    exit;
}
