<!doctype html>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-theme="light" <?php if(__tipoMenu() == 'horizontal'): ?> data-layout="topnav" <?php endif; ?>>


    <head>
        <!-- CSS para animação pulse e mudança de cor do ícone de notificações -->
        <style>
        /* Animação pulse + cor para ícone de notificação */
        @keyframes pulseColor {
          0% {
            transform: scale(1);
            color: #4361ee; /* violeta */
            text-shadow: 0 0 6px #4361ee;
          }
          50% {
            transform: scale(1.25);
            color: #ff9800; /* laranja */
            text-shadow: 0 0 12px #ff9800;
          }
          100% {
            transform: scale(1);
            color: #4361ee; /* violeta */
            text-shadow: 0 0 6px #4361ee;
          }
        }
        .pulse-notify {
          animation: pulseColor 1s infinite;
          transition: color 0.2s, text-shadow 0.2s, transform 0.2s;
        }
        </style>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta content="Coderthemes" name="author" />
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title', 'ERP'); ?></title>

        <!-- Favicon e ícones para dispositivos móveis -->
        <link rel="shortcut icon" href="/logo-sm.png">
        <link rel="icon" type="image/png" sizes="32x32" href="/logo-sm.png">
        <link rel="icon" type="image/png" sizes="16x16" href="/logo-sm.png">
        
        <!-- Apple Touch Icons -->
        <link rel="apple-touch-icon" href="/logo-sm.png">
        <link rel="apple-touch-icon" sizes="152x152" href="/logo-sm.png">
        <link rel="apple-touch-icon" sizes="180x180" href="/logo-sm.png">
        <link rel="apple-touch-icon" sizes="167x167" href="/logo-sm.png">
        
        <!-- iOS Meta tags -->
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="black">
        <meta name="apple-mobile-web-app-title" content="<?php echo $__env->yieldContent('title', 'ERP'); ?>">
        
        <!-- Android Meta Tags -->
        <meta name="mobile-web-app-capable" content="yes">
        <meta name="theme-color" content="#ffffff">
        <meta name="application-name" content="<?php echo $__env->yieldContent('title', 'ERP'); ?>">

        <!-- Web App Manifest -->
        <link rel="manifest" href="/manifest.json">

        <script rel="stylesheet" src="/assets/js/config.js"></script>

        <link href="/assets/vendor/fullcalendar/main.min.css" rel="stylesheet" type="text/css" />
        <link href="/assets/vendor/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="/assets/vendor/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
        <link href="/assets/vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
        <link href="/assets/vendor/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css">
        <link href="/assets/vendor/flatpickr/flatpickr.min.css" rel="stylesheet" type="text/css" />

        <link href="/assets/css/app.css" rel="stylesheet" type="text/css" id="app-style" />
        <!-- <link href="/assets/css/app-rtl.css" rel="stylesheet" type="text/css"/> -->
        <link href="/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" type="text/css" href="/assets/css/toastr.min.css">
        <link rel="stylesheet" type="text/css" href="/css/style.css">
        <link rel="stylesheet" type="text/css" href="/css/responsive-menu-fix.css">
        <link rel="stylesheet" type="text/css" href="/css/toggle-menu-button.css">
        <link rel="stylesheet" type="text/css" href="/css/responsive-scroll-fix.css">

        <!-- Tema personalizado -->
        <link rel="stylesheet" type="text/css" href="/assets/css/custom-theme.css">

        <link href="/bs5-tour/css/bs5-intro-tour.css" rel="stylesheet"/>

        <link rel='stylesheet' href='/css/bootstrap-duallistbox.min.css'/>

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

        <!-- Correções para interação em dispositivos móveis -->
        <link href="/css/mobile-touch-fix.css" rel="stylesheet" type="text/css" />

        <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">

        <?php echo $__env->yieldContent('css'); ?>

    </head>
    <body class="<?php echo e(isset($bodyClass) ? $bodyClass : ''); ?>">

        <div class="loader"></div>
        <?php if(isset(Auth::user()->empresa->empresa)): ?>
        <input type="hidden" value="<?php echo e(Auth::user()->empresa->empresa->id); ?>" id="empresa_id">
        <?php endif; ?>
        <input type="hidden" value="<?php echo e(Auth::user()->id); ?>" id="usuario_id">

        <div class="wrapper">
            <!-- ========== Topbar Start ========== -->
            <div class="navbar-custom">
                <div class="container-fluid">
                    <div class="topbar">
                        <div class="topbar-menu d-flex flex-row align-items-center gap-1">
                            <!-- Sidebar Menu Toggle Button -->
                            <button id="step1" class="button-toggle-menu me-2">
                                <i class="ri-menu-2-fill"></i>
                            </button>
                            <!-- INFORMAÇÕES DO SISTEMA (PLANO, IP, ETC) -->
                            <div class="d-flex flex-row align-items-center gap-3 ms-2">
                                <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa): ?>
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-building-fill text-primary"></i>
                                    <span class="info-label">Empresa:</span>
                                    <span class="info-value">#<?php echo e(Auth::user()->empresa->empresa->id); ?> - <?php echo e(Auth::user()->empresa->empresa->nome); ?></span>
                                </div>
                                <?php endif; ?>

                                <?php if(Auth::user()->empresa && !__isContador()): ?>
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-server-fill text-primary"></i>
                                    <span class="info-label">Ambiente:</span>
                                    <span class="info-value"><?php echo e(Auth::user()->empresa->empresa->ambiente == 2 ? 'HOMOLOGAÇÃO' : 'PRODUÇÃO'); ?></span>
                                </div>
                                <?php endif; ?>

                                <?php if(sizeof(Auth::user()->acessos) > 0): ?>
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-wifi-fill text-primary"></i>
                                    <span class="info-label">IP:</span>
                                    <span class="info-value"><?php echo e(Auth::user()->acessos ? Auth::user()->acessos->first()->ip : ''); ?></span>
                                </div>
                                <?php endif; ?>

                                <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa->empresa_selecionada != null): ?>
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-focus-3-line text-success"></i>
                                    <span class="info-label">Empresa selecionada:</span>
                                    <span class="info-value"><?php echo e(Auth::user()->empresa->empresa->empresaSelecionada->info); ?></span>
                                </div>
                                <?php endif; ?>

                                <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa->plano): ?>
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-vip-crown-fill text-warning"></i>
                                    <span class="info-label">Plano:</span>
                                    <span class="info-value"><?php echo e(Auth::user()->empresa->empresa->plano->plano->nome); ?> (até <?php echo e(__data_pt(Auth::user()->empresa->empresa->plano->data_expiracao, 0)); ?>)</span>
                                </div>
                                <?php endif; ?>
                                <!-- Versão do sistema -->
                                <div class="header-info-item d-flex align-items-center gap-1">
                                    <i class="ri-information-line text-info"></i>
                                    <span class="info-label">Versão:</span>
                                    <span class="info-value"><?php echo e(env('APP_VERSION', '1.0.0')); ?></span>
                                </div>
                            </div>
                        </div>

                        <ul class="topbar-menu d-flex align-items-center flex-row gap-3">
                            <!-- Search Dropdown -->
                            <li class="dropdown d-xl-none">
                                <a class="nav-link dropdown-toggle arrow-none" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                    <i class="ri-search-line fs-22"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-animated dropdown-lg p-0">
                                    <div class="dropdown-header">
                                        <div class="d-flex flex-column">
                                            <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa): ?>
                                            <div class="header-info-item mb-2">
                                                <i class="ri-building-fill text-primary"></i>
                                                <div>
                                                    <p class="info-label">Empresa</p>
                                                    <p class="info-value">#<?php echo e(Auth::user()->empresa->empresa->id); ?> - <?php echo e(Auth::user()->empresa->empresa->nome); ?></p>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php if(Auth::user()->empresa && !__isContador()): ?>
                                            <div class="header-info-item mb-2">
                                                <i class="ri-server-fill text-primary"></i>
                                                <div>
                                                    <p class="info-label">Ambiente</p>
                                                    <p class="info-value"><?php echo e(Auth::user()->empresa->empresa->ambiente == 2 ? 'HOMOLOGAÇÃO' : 'PRODUÇÃO'); ?></p>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php if(sizeof(Auth::user()->acessos) > 0): ?>
                                            <div class="header-info-item mb-2">
                                                <i class="ri-wifi-fill text-primary"></i>
                                                <div>
                                                    <p class="info-label">IP</p>
                                                    <p class="info-value"><?php echo e(Auth::user()->acessos ? Auth::user()->acessos->first()->ip : ''); ?></p>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa->empresa_selecionada != null): ?>
                                            <div class="header-info-item mb-2">
                                                <i class="ri-focus-3-line text-success"></i>
                                                <div>
                                                    <p class="info-label">Empresa selecionada</p>
                                                    <p class="info-value"><?php echo e(Auth::user()->empresa->empresa->empresaSelecionada->info); ?></p>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php if(Auth::user()->empresa && Auth::user()->empresa->empresa->plano): ?>
                                            <div class="header-info-item mb-2">
                                                <i class="ri-vip-crown-fill text-warning"></i>
                                                <div>
                                                    <p class="info-label">Plano</p>
                                                    <p class="info-value"><?php echo e(Auth::user()->empresa->empresa->plano->plano->nome); ?> (até <?php echo e(__data_pt(Auth::user()->empresa->empresa->plano->data_expiracao, 0)); ?>)</p>
                                                </div>
                                            </div>
                                            <div class="d-flex mt-2 gap-2">
                                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('upgrade.index')); ?>">
                                                    <i class="ri-arrow-up-line me-1"></i>Upgrade
                                                </a>
                                                <button class="btn btn-info btn-sm" id="click-tour-mobile">
                                                    <i class="ri-compass-3-line me-1"></i>Tour
                                                </button>
                                            </div>
                                            <?php if(env("APP_ENV") == "demo"): ?>
                                            <button class="btn btn-success btn-sm mt-2" id="click-modal-dev-mobile">
                                                <i class="ri-code-box-line me-1"></i>Desenvolvedor
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </li>

                            <!-- Notificações -->
                            <li class="dropdown notification-list">
                                <a class="nav-link dropdown-toggle arrow-none" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                    <i class="ri-notification-3-fill fs-22"></i>
                                    <div class="spinner-border spinner-border-sm text-danger" role="status">
                                        <span class="visually-hidden"></span>
                                    </div>
                                    <span class="noti-icon-badge d-none"></span>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-animated dropdown-lg py-0">
                                    <div class="p-2 border-top-0 border-start-0 border-end-0 border-dashed border">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <h6 class="m-0 fs-16 fw-medium"> Notificações</h6>
                                            </div>
                                            <div class="col-auto">
                                                <a href="<?php echo e(route('notificacao.clear-all')); ?>" class="text-dark text-decoration-underline">
                                                    <small>Limpar tudo</small>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <div style="max-height: 300px;" data-simplebar="init">
                                        <div class="simplebar-wrapper" style="margin: 0px;">
                                            <div class="simplebar-height-auto-observer-wrapper">
                                                <div class="simplebar-height-auto-observer"></div>
                                            </div>
                                            <div class="simplebar-mask">
                                                <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                                    <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: auto; overflow: hidden scroll;">
                                                        <div class="simplebar-content alertas-main" style="padding: 0px;">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="simplebar-placeholder" style="width: auto; height: 432px;"></div>
                                        </div>
                                        <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                                            <div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
                                        </div>
                                        <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                                            <div class="simplebar-scrollbar" style="height: 208px; transform: translate3d(0px, 0px, 0px); display: block;"></div>
                                        </div>
                                    </div>
                                </div>
                            </li>

                            <!-- PDV Link -->
                            <?php if(!__isContador()): ?>
                            <?php if(__isActivePlan(Auth::user()->empresa, 'PDV')): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_create')): ?>
                            <li class="d-none d-sm-inline-block">
                                <a title="PDV" class="nav-link" href="<?php echo e(route('frontbox.create')); ?>">
                                    <i class="ri-shopping-basket-2-fill fs-22"></i>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php endif; ?>

                            <!-- Botão de alternância de tema -->
                            <li>
                                <button id="theme-toggle-btn" class="btn btn-light btn-sm" aria-label="Alternar tema claro/escuro">
                                    <i class="ri-moon-line fs-4"></i>
                                </button>
                            </li>

                            <!-- Fullscreen Button -->
                            <li class="d-none d-md-inline-block">
                                <a class="nav-link" href="javascript:void(0)" data-toggle="fullscreen">
                                    <i class="ri-fullscreen-line fs-22"></i>
                                </a>
                            </li>

                            <!-- User Profile Menu -->
                            <li class="dropdown">
                                <a class="nav-link dropdown-toggle arrow-none nav-user px-2" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                    <span class="account-user-avatar">
                                        <?php if(Auth::user()->imagem != null): ?>
                                        <img src="<?php echo e(Auth::user()->img); ?>" height="32" class="rounded-circle">
                                        <?php else: ?>
                                        <img src="/assets/images/users/avatar-4.jpg" alt="user-image" width="32" class="rounded-circle">
                                        <?php endif; ?>
                                    </span>
                                    <span class="d-lg-flex flex-column gap-1 d-none">
                                        <h5 class="my-0"><?php echo e(Auth::user()->name); ?></h5>
                                        <h6 class="my-0 fw-normal"><?php echo e(Auth::user()->tipo); ?></h6>
                                    </span>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-animated profile-dropdown">
                                    <!-- item-->
                                    <div class="dropdown-header noti-title">
                                        <h6 class="text-overflow m-0">Bem vindo!</h6>
                                    </div>

                                    <?php if(!__isContador()): ?>
                                    <a href="<?php echo e(route('usuarios.profile', Auth::user()->id)); ?>" class="dropdown-item">
                                        <i class="ri-account-circle-fill align-middle me-1"></i>
                                        <span>Minha Conta</span>
                                    </a>

                                    <!-- item-->
                                    <a href="<?php echo e(route('config.index')); ?>" class="dropdown-item">
                                        <i class="ri-settings-4-fill align-middle me-1"></i>
                                        <span>Configuração</span>
                                    </a>

                                    <a href="<?php echo e(route('ticket.index')); ?>" class="dropdown-item">
                                        <i class="ri-information-fill align-middle me-1"></i>
                                        <span>Abrir chamado</span>
                                    </a>
                                    <?php endif; ?>

                                    <!-- item-->
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); localStorage.removeItem('nps_exibido_data'); document.getElementById('logout-form').submit();">
                                        <i class="ri-logout-box-line align-middle me-1"></i>
                                        Sair
                                    </a>
                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- ========== Topbar End ========== -->

            <!-- init:: Menu -->
            <?php if(__tipoMenu() == 'horizontal'): ?>
            <?php echo $__env->make('layouts.menu.horizontal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
            <?php echo $__env->make('layouts.menu.vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <!-- end:: Menu -->

            <div class="content-page">
                <div class="content">
                    <div class="<?php if(__tipoMenu() == 'vertical'): ?> container-fluid <?php endif; ?>" <?php if(__tipoMenu() == 'horizontal'): ?> style="margin-top: -15px" <?php endif; ?>>

                        <?php echo $__env->yieldContent('content'); ?>

                    </div>
                </div>
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-6">
                                <script>
                                    document.write(new Date().getFullYear())

                                </script> <?php echo e(env("APP_NAME")); ?>

                            </div>
                        </div>
                    </div>
                </footer>
            </div>

            <?php if(!isset($not_loading)): ?>
            <div class="control-loading">
                <div class="modal-loading loading-class"></div>
            </div>
            <?php endif; ?>

            <div class="modal fade" id="modal-dev" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">DADOS DO DESENVOLVEDOR</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <h4>Marcos Mello - Slym Software</h4>
                            <a href="https://wa.me/5543920004769">WhatsApp <strong>43920004769</strong></a>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modal-crm-notificacao" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Notificações CRM</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                           
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modal-notificacao" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Notificações</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modal-notificacao-delivery" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Notificações de Delivery</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modal-notificacao-ecommerce" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="staticBackdropLabel">Notificações de Ecommerce</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>

            <script type="text/javascript">
                let prot = window.location.protocol;
                let host = window.location.host;
                const path_url = prot + "//" + host + "/";

            </script>
            <script src="/assets/js/vendor.min.js"></script>
            <script src="/assets/vendor/select2/js/select2.min.js"></script>
            <script src="/assets/js/toastr.min.js"></script>
            <script src="/assets/vendor/dropzone/dropzone.js"></script>
            <script src="/assets/js/pages/component.fileupload.js"></script>
            <script src="/assets/vendor/daterangepicker/moment.min.js"></script>
            <script src="/assets/vendor/daterangepicker/daterangepicker.js"></script>
            <script src="/assets/vendor/jquery-mask-plugin/jquery.mask.min.js"></script>
            <script src="/assets/vendor/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.min.js"></script>
            <script src="/assets/vendor/admin-resources/jquery.vectormap/maps/jquery-jvectormap-world-mill-en.js"></script>
            <script src="/assets/vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
            <script src="/assets/vendor/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>

            <script src='/js/jquery.bootstrap-duallistbox.min.js'></script>

            <script src="/js/uploadImagem.js"></script>
            <script type="text/javascript" src="/js/jquery.mask.min.js"></script>
            <script src='https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js'></script>
            <script src="/assets/js/app.js"></script>
            <script type="text/javascript" src="/js/main.js"></script>
            <script src="/assets/vendor/flatpickr/flatpickr.min.js"></script>
            <script src="/assets/js/pages/demo.flatpickr.js"></script>

            <?php if(__isNotificacao(Auth::user()->empresa) && Auth::user()->notificacao_cardapio): ?>
            <script src="/js/notificacao.js"></script>
            <?php endif; ?>

            <?php if(__isNotificacaoMarketPlace(Auth::user()->empresa) && Auth::user()->notificacao_marketplace): ?>
            <script src="/js/notificacao_marketplace.js"></script>
            <?php endif; ?>

            <?php if(__isNotificacaoEcommerce(Auth::user()->empresa) && Auth::user()->notificacao_ecommerce): ?>
            <script src="/js/notificacao_ecommerce.js"></script>
            <?php endif; ?>

            <!-- Script para melhorar a responsividade das tabelas -->
            <script src="/js/responsive-tables.js"></script>

            <!-- Script para corrigir problemas de clique em botões em dispositivos móveis -->
            <script src="/js/mobile-touch-fix.js"></script>

            <?php echo $__env->yieldContent('js'); ?>

            <script type="text/javascript">
                toastr.options = {
                    "progressBar": true
                    , "onclick": null
                    , "showDuration": "300"
                    , "hideDuration": "1000"
                    , "timeOut": "10000"
                    , "extendedTimeOut": "1000"
                    , "showEasing": "swing"
                    , "hideEasing": "linear"
                    , "showMethod": "fadeIn"
                    , "hideMethod": "fadeOut"
                }
                <?php if(session()->has('flash_success')): ?>
                toastr.success('<?php echo e(session()->get('flash_success')); ?>');
                <?php endif; ?>

                <?php if(session()->has('flash_error')): ?>
                toastr.error('<?php echo e(session()->get('flash_error')); ?>');
                <?php endif; ?>

                <?php if(session()->has('flash_warning')): ?>
                toastr.warning('<?php echo e(session()->get('flash_warning')); ?>');
                <?php endif; ?>

                <?php if(!Auth::user()->sidebar_active): ?>
                $(html).attr('data-sidenav-size', 'condensed');
                <?php endif; ?>

                <?php if(session()->has('flash_modal_crm')): ?>
                modalCrmNotification()
                <?php endif; ?>


                $(html).attr('data-topbar-color', '<?php echo e(__dataTopBar()); ?>')
                $(html).attr('data-menu-color', '<?php echo e(__dataMenuBar()); ?>')

                window.addEventListener("load", () => {
                    setTimeout(() => {
                        document.querySelector(".loader").classList.add("loader--hidden")
                    }, 100)
                })

                function audioError(){
                    var audio = new Audio('/audio/error.mp3');
                    audio.addEventListener('canplaythrough', function() {
                        audio.play();
                    });
                }

                $('#click-modal-dev').click(() => {
                    $('#modal-dev').modal('show')
                })

                function modalCrmNotification(){
                    $.get(path_url+'api/crm/modal', {empresa_id: $('#empresa_id').val()})
                    .done((res) => {
                        $('#modal-crm-notificacao').modal('show')
                        $('#modal-crm-notificacao .modal-body').html(res)
                    }).fail((err) => {
                        console.log(err)
                    })
                }
            </script>

            <script src="/bs5-tour/js/bs5-intro-tour.js"></script>
            <script src="/js/tour.js"></script>
            <script src="/js/toggle-menu-button.js"></script>
            
            <!-- Script para substituição do logotipo por texto estilizado -->
            <script src="/js/logo-text-replacement.js"></script>
            
            <!-- Script para tratamento de erros de conexão com banco de dados -->
            <script src="/js/database-error-handler.js"></script>
            
            <!-- Menu backdrop para mobile -->
            <div class="menu-backdrop"></div>
            
            <!-- Modal da Pesquisa NPS -->
            <?php if(auth()->guard()->check()): ?>
                <?php echo $__env->make('nps.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <!-- Garantir que o JS do tema está incluído -->
            <script src="/js/theme_toggle.js"></script>

            <script>
            document.addEventListener('DOMContentLoaded', function() {
                var btn = document.getElementById('light-dark-mode');
                if (btn) {
                    btn.onclick = typeof toggleTheme === 'function' ? toggleTheme : function() { location.reload(); };
                }
            });
            </script>
            <script>
            // Ativa a animação pulse+cor se houver notificação não lida (badge visível)
            // Remove a animação ao abrir o dropdown ou quando o badge sumir
            document.addEventListener('DOMContentLoaded', function() {
                var badge = document.querySelector('.noti-icon-badge');
                var icon = document.querySelector('.ri-notification-3-fill');
                var dropdown = document.querySelector('.notification-list > a.nav-link');

                function updatePulse() {
                    if (badge && icon) {
                        if (!badge.classList.contains('d-none')) {
                            icon.classList.add('pulse-notify');
                        } else {
                            icon.classList.remove('pulse-notify');
                        }
                    }
                }

                // Ativa/desativa ao carregar a página
                updatePulse();

                // Observa mudanças no badge (caso AJAX atualize)
                if (badge) {
                    var observer = new MutationObserver(updatePulse);
                    observer.observe(badge, { attributes: true, attributeFilter: ['class'] });
                }

                // Remove animação ao abrir o dropdown (considera como lida/aberta)
                if (dropdown) {
                    dropdown.addEventListener('click', function() {
                        if (icon) icon.classList.remove('pulse-notify');
                    });
                }
            });
            </script>
        </body>
        </html>
<?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/layouts/app.blade.php ENDPATH**/ ?>