@extends('layouts.app', ['title' => 'NFe'])
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    /* Evita rolagem vertical forçada por dropdown */
    .dropdown-menu {
        position: absolute !important;
        z-index: 1050;
        max-height: 300px;
        overflow-y: auto;
    }

    /* Garante espaço mesmo com poucos itens */
    .table-responsive {
        min-height: 600px;
    }

    /* Evita corte no final do conteúdo */
    .card-body {
        padding-bottom: 80px;
    }

    /* Estilos para os botões de filtro rápido */
    .btn-group .filtro-rapido {
        min-width: 100px;
        transition: all 0.3s ease;
    }

    .btn-group .filtro-rapido.active {
        background-color: #0d6efd;
        color: white;
        border-color: #0d6efd;
    }

    .btn-group .filtro-rapido:hover {
        background-color: #0b5ed7;
        color: white;
        border-color: #0b5ed7;
    }

    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
        .btn-group {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
        }
        .btn-group .filtro-rapido {
            flex: 1;
            min-width: calc(50% - 5px);
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }

    .card-destaque {
        box-shadow: 0 2px 8px rgba(0,0,0,0.08), 0 0px 0px rgba(0,0,0,0.01);
        border: 1.5px solid #e0e0e0;
        border-radius: 10px;
        transition: box-shadow 0.2s;
        background: #fff;
        color: #222;
    }
    .card-destaque h4, .card-destaque h6 { color: inherit; }
    .card-recebimentos {
        background: #43a047 !important;
        border-color: #388e3c !important;
        color: #fff !important;
    }
    .card-recebimentos i { color: #fff !important; }
    .card-descontos {
        background: #1976d2 !important;
        border-color: #1565c0 !important;
        color: #fff !important;
    }
    .card-descontos i { color: #fff !important; }
    .card-cancelamentos {
        background: #c62828 !important;
        border-color: #b71c1c !important;
        color: #fff !important;
    }
    .card-cancelamentos i { color: #fff !important; }
    .card-valores {
        background: #6a1b9a !important;
        border-color: #45277a !important;
        color: #fff !important;
    }
    .card-valores i { color: #fff !important; }
</style>
@endsection
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        @can('nfe_create')
                        <a href="{{ route('nfe.create') }}" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova Venda
                        </a>
                        @endcan
                    </div>
                    <div class="col-md-6 text-end">
                        @if(__isPlanoFiscal())
                        <button id="btn-consulta-sefaz" class="btn btn-dark">
                            <i class="ri-refresh-line"></i>
                            Consultar Status Sefaz
                        </button>
                        @endif
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->id('filtro-nfe-form')
                    ->get()
                    !!}
                    <div class="row g-2">
                        <div class="col-12 col-sm-6 col-md-4 col-lg-4">
                            {!!Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('start_date', 'Data inicial')
                            ->attrs(['class' => 'form-control'])
                            ->value(request('start_date'))
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('end_date', 'Data final')
                            ->attrs(['class' => 'form-control'])
                            ->value(request('end_date'))
                            !!}
                        </div>

                        @if(__countLocalAtivo() > 1)
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        @endif

                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit"> 
                                <i class="ri-search-line"></i> Pesquisar
                            </button>
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <a id="clear-filter" class="btn btn-danger w-100" href="{{ route('nfe.index') }}">
                                <i class="ri-eraser-fill"></i> Limpar
                            </a>
                        </div>
                    </div>
                    {!!Form::close()!!}

                    <!-- Botões de Filtro Rápido -->
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-outline-primary filtro-rapido" data-dias="0">
                                    <i class="ri-calendar-line"></i> Hoje
                                </button>
                                <button type="button" class="btn btn-outline-primary filtro-rapido" data-dias="7">
                                    <i class="ri-calendar-line"></i> 7 Dias
                                </button>
                                <button type="button" class="btn btn-outline-primary filtro-rapido" data-dias="15">
                                    <i class="ri-calendar-line"></i> 15 Dias
                                </button>
                                <button type="button" class="btn btn-outline-primary filtro-rapido" data-dias="mes">
                                    <i class="ri-calendar-line"></i> Mês Atual
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row" style="margin-top: 18px; margin-bottom: 10px;">
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #6c2eb7; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaValores, 2, ',', '.') }}</h5>
                                <small>Soma Valores</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #d32f2f; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaCancelamentos, 2, ',', '.') }}</h5>
                                <small>Soma Cancelamentos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #ff9800; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaRejeitados, 2, ',', '.') }}</h5>
                                <small>Soma Rejeitados</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #1976d2; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaDescontos, 2, ',', '.') }}</h5>
                                <small>Soma Descontos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #222; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaTotalLiquido, 2, ',', '.') }}</h5>
                                <small>Total Líquido</small>
                            </div>
                        </div>
                    </div>
                </div>

                @if($contigencia != null)
                <div class="row mt-3">
                    <div class="col-md-3">
                        <div class="card h-100">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong>{{$contigencia->tipo}}</strong></p>
                                <p class="text-danger">Data de ínicio: <strong>{{ __data_pt($contigencia->created_at) }}</strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <div class="col-md-12 mt-4">
                    <div class="table-responsive">
                        <table class="table table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th width="10%">Ações</th>
                                    <th>#</th>
                                    <th>Cliente/Fornecedor</th>
                                    <th>CPF/CNPJ</th>
                                    @if(__countLocalAtivo() > 1)
                                    <th>Local</th>
                                    @endif
                                    <th>Usuário</th>
                                    <th>Número</th>
                                    <th>Número Série</th>
                                    <th>Valor</th>
                                    <th>Data de cadastro</th>
                                    <th>Data de emissão</th>
                                    <th>*</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr class="{{ 
                                    $item->estado == 'aprovado' ? 'table-success' : 
                                    ($item->estado == 'cancelado' ? 'table-danger' : 
                                    ($item->estado == 'rejeitado' ? 'table-warning' : '')) 
                                }}">
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">
                                                @if($item->estado == 'cancelado')
                                                <li>
                                                    <a class="dropdown-item text-danger" target="_blank" href="{{ route('nfe.imprimir-cancela', [$item->id]) }}">
                                                        <i class="ri-printer-line me-1"></i> Imprimir Cancelamento
                                                    </a>
                                                </li>
                                                @endif
                                                
                                                @if($item->estado == 'aprovado')
                                                <li>
                                                    <button type="button" onclick="imprimir('{{$item->id}}', '{{$item->numero}}')" class="dropdown-item text-primary" title="Imprimir NFe">
                                                        <i class="ri-printer-line me-1"></i> Imprimir NFe
                                                    </button>
                                                </li>
                                                
                                                @can('nfe_transmitir')
                                                <li>
                                                    <button title="Cancelar NFe" type="button" class="dropdown-item text-danger" onclick="cancelar('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-close-circle-line me-1"></i> Cancelar NFe
                                                    </button>
                                                </li>
                                                
                                                <li>
                                                    <button title="Corrigir NFe" type="button" class="dropdown-item text-warning" onclick="corrigir('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-file-warning-line me-1"></i> Corrigir NFe
                                                    </button>
                                                </li>
                                                @endcan
                                                @endif

                                                @if($item->estado == 'aprovado' || $item->estado == 'rejeitado')
                                                <li>
                                                    <button title="Consultar status" type="button" class="dropdown-item text-dark" onclick="info('{{$item->motivo_rejeicao}}', '{{$item->chave}}', '{{$item->estado}}', '{{$item->recibo}}')">
                                                        <i class="ri-file-line me-1"></i> Consultar Status
                                                    </button>
                                                </li>
                                                @endif

                                                @if($item->estado == 'novo' || $item->estado == 'rejeitado')
                                                @can('nfe_edit')
                                                <li>
                                                    <a class="dropdown-item text-warning" href="{{ route('nfe.edit', $item->id) }}">
                                                        <i class="ri-edit-line me-1"></i> Editar
                                                    </a>
                                                </li>
                                                @endcan
                                                
                                                @if(__isPlanoFiscal())
                                                <li>
                                                    <a target="_blank" title="XML temporário" class="dropdown-item text-secondary" href="{{ route('nfe.xml-temp', $item->id) }}">
                                                        <i class="ri-file-line me-1"></i> XML Temporário
                                                    </a>
                                                </li>
                                                @endif

                                                @can('nfe_delete')
                                                <li>
                                                    <form action="{{ route('nfe.destroy', $item->id) }}" method="post" id="form-{{$item->id}}">
                                                        @method('delete')
                                                        @csrf
                                                        <button type="button" class="dropdown-item text-danger btn-delete">
                                                            <i class="ri-delete-bin-line me-1"></i> Excluir
                                                        </button>
                                                    </form>
                                                </li>
                                                @endcan
                                                @endif

                                                @if(__isPlanoFiscal())
                                                @can('nfe_transmitir')
                                                <li>
                                                    <button title="Transmitir NFe" type="button" class="dropdown-item text-success" onclick="transmitir('{{$item->id}}')">
                                                        <i class="ri-send-plane-fill me-1"></i> Transmitir
                                                    </button>
                                                </li>
                                                @endcan
                                                @endif

                                                <li>
                                                    <a class="dropdown-item text-info" title="Imprimir Pedido" target="_blank" href="{{ route('nfe.imprimirVenda', [$item->id]) }}">
                                                        <i class="ri-printer-line me-1"></i> Imprimir Pedido
                                                    </a>
                                                </li>

                                                @if($item->estado == 'aprovado' || $item->estado == 'cancelado' || $item->estado == 'rejeitado')
                                                <li>
                                                    <button title="Consultar NFe" type="button" class="dropdown-item text-info" onclick="consultar('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-file-search-line me-1"></i> Consultar NFe
                                                    </button>
                                                </li>
                                                @endif

                                                @if(__isPlanoFiscal())
                                                @can('nfe_edit')
                                                <li>
                                                    <a title="Alterar estado fiscal" class="dropdown-item text-danger" href="{{ route('nfe.alterar-estado', $item->id) }}">
                                                        <i class="ri-arrow-up-down-line me-1"></i> Alterar Estado Fiscal
                                                    </a>
                                                </li>
                                                @endcan
                                                @endif

                                                <li>
                                                    <a class="dropdown-item text-primary" title="Detalhes" href="{{ route('nfe.show', $item->id) }}">
                                                        <i class="ri-eye-line me-1"></i> Detalhes
                                                    </a>
                                                </li>

                                                @if($item->estado != 'aprovado')
                                                <li>
                                                    <a class="dropdown-item text-danger" title="DANFE Temporária" target="_blank" href="{{ route('nfe.danfe-temporaria', [$item->id]) }}">
                                                        <i class="ri-printer-fill me-1"></i> DANFE Temporária
                                                    </a>
                                                </li>
                                                @endif

                                                <li>
                                                    <a class="dropdown-item text-dark" href="{{ route('nfe.duplicar', [$item->id]) }}" title="Duplicar venda">
                                                        <i class="ri-file-copy-line me-1"></i> Duplicar
                                                    </a>
                                                </li>

                                                @if($item->estado == 'aprovado')
                                                <li>
                                                    <button title="Enviar Email" type="button" class="dropdown-item text-primary" onclick="enviarEmail('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-mail-send-line me-1"></i> Enviar Email
                                                    </button>
                                                </li>

                                                <li>
                                                    <a title="Download XML" href="{{ route('nfe.download-xml', [$item->id]) }}" class="dropdown-item text-dark">
                                                        <i class="ri-download-line me-1"></i> Download XML
                                                    </a>
                                                </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </td>
                                    <td>{{ $item->numero_sequencial }}</td>
                                    @if($item->cliente)
                                    <td class="text-truncate" style="max-width: 150px">{{ $item->cliente ? $item->cliente->razao_social : "--" }}</td>
                                    <td>{{ $item->cliente ? $item->cliente->cpf_cnpj : "--" }}</td>
                                    @else
                                    <td class="text-truncate" style="max-width: 150px">{{ $item->fornecedor ? $item->fornecedor->razao_social : "--" }}</td>
                                    <td>{{ $item->fornecedor ? $item->fornecedor->cpf_cnpj : "--" }}</td>
                                    @endif
                                    @if(__countLocalAtivo() > 1)
                                    <td class="text-danger">{{ $item->localizacao->descricao }}</td>
                                    @endif
                                    <td>{{ $item->user ? $item->user->name : '--' }}</td>
                                    <td>{{ $item->numero ? $item->numero : '' }}</td>
                                    <td>{{ $item->numero_serie ? $item->numero_serie : '' }}</td>
                                    <td>{{ __moeda($item->total) }}</td>
                                    <td>{{ __data_pt($item->created_at) }}</td>
                                    <td>{{ $item->data_emissao ? __data_pt($item->data_emissao, 1) : '--' }}</td>
                                    <td>
                                        @if($item->pedidoEcommerce)
                                        <a title="Pedido de ecommerce" class="btn btn-sm btn-danger" href="{{ route('pedidos-ecommerce.show', [$item->pedidoEcommerce->id]) }}">EC</a>
                                        @elseif($item->ordemServico)
                                        <a title="Ordem de serviço" class="btn btn-sm btn-primary" href="{{ route('ordem-servico.show', [$item->ordemServico->id]) }}">OS</a>
                                        @elseif($item->pedidoMercadoLivre)
                                        <a title="Pedido mercado livre" class="btn btn-sm btn-warning" href="{{ route('mercado-livre-pedidos.show', [$item->pedidoMercadoLivre->id]) }}">ML</a>
                                        @elseif($item->pedidoNuvemShop)
                                        <a title="Pedido nuvem shop" class="btn btn-sm btn-dark" href="{{ route('nuvem-shop-pedidos.show', [$item->pedidoNuvemShop->pedido_id]) }}">NS</a>
                                        @elseif($item->reserva)
                                        <a title="Reserva" class="btn btn-sm btn-dark" href="{{ route('reservas.show', [$item->reserva->id]) }}">RS</a>
                                        @elseif($item->pedidoWoocomerce)
                                        <a title="Pedido woocommerce" class="btn btn-sm btn-info" href="{{ route('woocommerce-pedidos.show', [$item->pedidoWoocomerce->id]) }}">WO</a>
                                        @else
                                        --
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        @if(request('start_date') || request('end_date'))
                            {!! $data->appends([
                                'start_date' => request('start_date'),
                                'end_date' => request('end_date'),
                                'cliente_id' => request('cliente_id'),
                                'local_id' => request('local_id')
                            ])->links() !!}
                        @else
                            {!! $data->appends(request()->all())->links() !!}
                        @endif
                    </div>
                </div>
                <h5 class="mt-3">Soma: <strong class="text-success">R$ {{ __moeda($data->sum('total')) }}</strong></h5>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-print" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Imprimir NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-2">
                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-success w-100" onclick="gerarDanfe('danfe')">
                            <i class="ri-printer-line"></i>
                            DANFE
                        </button>
                    </div>

                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-primary w-100" onclick="gerarDanfe('simples')">
                            <i class="ri-printer-line"></i>
                            DANFE Simples
                        </button>
                    </div>

                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-dark w-100" onclick="gerarDanfe('etiqueta')">
                            <i class="ri-printer-line"></i>
                            DANFE Etiqueta
                        </button>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        {!!Form::text('motivo-cancela', 'Motivo')
                        ->required()
                        !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-email" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="modal-content" method="post" action="{{ route('nfe.send-email') }}" enctype="multipart/form-data">
            @csrf
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Enviar email NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-2">
                    <input type="hidden" id="nfe_email_id" name="id">
                    <div class="col-md-12">
                        {!!Form::text('email', 'Email')
                        ->required()
                        ->type('email')
                        !!}
                    </div>

                    <div class="col-md-12">
                        <div class="input-group mt-2">
                            <input type="file" class="form-control" id="arquivo" name="arquivo">
                            <label class="input-group-text" for="arquivo">Arquivo</label>
                        </div>
                        <span class="text-danger" id="filename"></span>
                    </div>

                    <div class="col-md-4 mt-2">
                        {!!Form::checkbox('danfe', 'DANFE')
                        !!}
                    </div>
                    <div class="col-md-4 mt-2">
                        {!!Form::checkbox('xml', 'XML')
                        !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="submit" class="btn btn-success btn-enviar-email">Enviar Email</button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="modal-corrigir" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Corrigir NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        {!!Form::text('motivo-corrigir', 'Motivo')
                        ->required()
                        !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-corrigir" class="btn btn-warning">Corrigir</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {
        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

    $('#btn-consulta-sefaz').click(() => {
        $.post(path_url + 'api/nfe_painel/consulta-status-sefaz', {
            empresa_id: $('#empresa_id').val(),
            usuario_id: $('#usuario_id').val(),
        })
        .done((res) => {
            let msg = "cStat: " + res.cStat
            msg += "\nMotivo: " + res.xMotivo
            msg += "\nAmbiente: " + (res.tpAmb == 2 ? "Homologação" : "Produção")
            msg += "\nverAplic: " + res.verAplic

            swal("Sucesso", msg, "success")
        })
        .fail((err) => {
            try {
                swal("Erro", err.responseText, "error")
            } catch {
                swal("Erro", "Algo deu errado", "error")
            }
        })
    })

    // Função para formatar data no formato YYYY-MM-DD
    function formatDate(date) {
        const d = new Date(date);
        let month = '' + (d.getMonth() + 1);
        let day = '' + d.getDate();
        const year = d.getFullYear();

        if (month.length < 2) month = '0' + month;
        if (day.length < 2) day = '0' + day;

        return [year, month, day].join('-');
    }

    // Função para verificar qual filtro está ativo baseado nas datas
    function verificarFiltroAtivo() {
        const startDate = $('input[name="start_date"]').val();
        const endDate = $('input[name="end_date"]').val();

        if (!startDate || !endDate) return;

        const start = new Date(startDate);
        const end = new Date(endDate);
        const hoje = new Date();
        hoje.setHours(0, 0, 0, 0);

        // Formata hoje para comparação
        const hojeFormatado = formatDate(hoje);

        // Verifica se é filtro de hoje
        if (startDate === hojeFormatado && endDate === hojeFormatado) {
            $('.filtro-rapido[data-dias="0"]').addClass('active');
            return;
        }

        // Verifica se é filtro do mês atual
        const primeiroDiaMes = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
        const ultimoDiaMes = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
        if (start.getTime() === primeiroDiaMes.getTime() && end.getTime() === ultimoDiaMes.getTime()) {
            $('.filtro-rapido[data-dias="mes"]').addClass('active');
            return;
        }

        // Verifica se é filtro de 7 ou 15 dias
        const diffTime = Math.abs(end - start);
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

        if (diffDays === 7 && formatDate(end) === formatDate(hoje)) {
            $('.filtro-rapido[data-dias="7"]').addClass('active');
        } else if (diffDays === 15 && formatDate(end) === formatDate(hoje)) {
            $('.filtro-rapido[data-dias="15"]').addClass('active');
        }
    }

    // Manipulador de clique para os botões de filtro rápido
    $('.filtro-rapido').click(function(e) {
        e.preventDefault();
        
        const dias = $(this).data('dias');
        const hoje = new Date();
        let dataInicial, dataFinal;
        
        console.log('Botão clicado:', dias);

        if (dias === 'mes') {
            dataInicial = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
            dataFinal = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
        } else if (dias === 0) {
            dataInicial = hoje;
            dataFinal = hoje;
        } else {
            dataInicial = new Date(hoje);
            dataInicial.setDate(hoje.getDate() - dias);
            dataFinal = hoje;
        }

        const startDate = formatDate(dataInicial);
        const endDate = formatDate(dataFinal);
        
        console.log('Data Inicial:', startDate);
        console.log('Data Final:', endDate);

        // Atualiza os campos de data
        $('#filtro-nfe-form input[name="start_date"]').val(startDate);
        $('#filtro-nfe-form input[name="end_date"]').val(endDate);

        console.log('Valores dos campos após atualização:');
        console.log('start_date:', $('#filtro-nfe-form input[name="start_date"]').val());
        console.log('end_date:', $('#filtro-nfe-form input[name="end_date"]').val());

        // Remove classe ativa de todos os botões
        $('.filtro-rapido').removeClass('active');
        // Adiciona classe ativa ao botão clicado
        $(this).addClass('active');

        // Pega o formulário pelo ID
        const form = $('#filtro-nfe-form');
        
        // Cria objeto com os dados do formulário
        const formData = new FormData(form[0]);
        const searchParams = new URLSearchParams();
        
        // Adiciona todos os campos do formulário ao searchParams
        for (const [key, value] of formData.entries()) {
            if (value) { // Só adiciona se tiver valor
                searchParams.append(key, value);
            }
        }
        
        // Log dos parâmetros que serão enviados
        console.log('Parâmetros que serão enviados:', searchParams.toString());

        // Constrói a URL com os parâmetros
        const url = `${window.location.pathname}?${searchParams.toString()}`;
        console.log('URL final:', url);

        // Redireciona para a URL com os parâmetros
        window.location.href = url;
    });

    // Verifica filtro ativo ao carregar a página
    $(document).ready(function() {
        console.log('Página carregada');
        console.log('URL atual:', window.location.href);
        console.log('Parâmetros na URL:', window.location.search);
        
        const urlParams = new URLSearchParams(window.location.search);
        console.log('start_date na URL:', urlParams.get('start_date'));
        console.log('end_date na URL:', urlParams.get('end_date'));
        
        verificarFiltroAtivo();
    });
</script>

<script>
    // Aplica .dropup se o dropdown estiver próximo do fim da tela
    document.querySelectorAll('.dropdown').forEach(function (dropdown) {
        const button = dropdown.querySelector('.dropdown-toggle');
        button.addEventListener('click', function () {
            const rect = dropdown.getBoundingClientRect();
            const isNearBottom = window.innerHeight - rect.bottom < 150;
            if (isNearBottom) {
                dropdown.classList.add('dropup');
            } else {
                dropdown.classList.remove('dropup');
            }
        });
    });
</script>

<script type="text/javascript" src="/js/nfe_transmitir.js"></script>
@endsection
