@extends('layouts.app', ['title' => 'Análise de Divergências de Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12 d-flex justify-content-between align-items-center mb-3">
                    <h4>Análise de Divergências - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <div>
                        <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary me-2">
                            <i class="ri-arrow-left-line"></i> Voltar
                        </a>
                        <a href="{{ route('processo-inventario.print-relatorio', $inventario->id) }}" class="btn btn-outline-danger me-2" target="_blank">
                            <i class="ri-file-pdf-line"></i> Imprimir Relatório
                        </a>
                        <a href="{{ route('processo-inventario.manual', $inventario->id) }}" class="btn btn-outline-primary">
                            <i class="ri-edit-box-line"></i> Editar Contagem
                        </a>
                    </div>
                </div>
                <p class="text-muted">
                    Compare as quantidades contadas com o estoque atual e selecione os produtos que deseja ajustar.
                </p>
                <hr>
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                @if(session('flash_warning'))
                <div class="alert alert-warning">
                    {{ session('flash_warning') }}
                </div>
                @endif
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Resumo da Análise</h5>
                                <div class="row mt-3">
                                    <div class="col-md-3">
                                        <div class="card border-light mb-3">
                                            <div class="card-body text-center">
                                                <h3 class="mb-0">{{ $resumo['total_itens'] }}</h3>
                                                <small class="text-muted">Total de Produtos</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-light mb-3">
                                            <div class="card-body text-center">
                                                <h3 class="mb-0">{{ $resumo['itens_contados'] }}</h3>
                                                <small class="text-muted">Produtos Contados</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-light mb-3">
                                            <div class="card-body text-center">
                                                <h3 class="mb-0">{{ $resumo['divergencias'] }}</h3>
                                                <small class="text-muted">Divergências Encontradas</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-light mb-3">
                                            <div class="card-body text-center">
                                                <h3 class="mb-0">{{ $resumo['percentual_divergencia'] }}%</h3>
                                                <small class="text-muted">Percentual de Divergência</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                @if(count($analise) > 0)
                <form action="{{ route('processo-inventario.ajustar-selecionados', $inventario->id) }}" method="POST">
                    @csrf
                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <div>
                            <button type="button" class="btn btn-outline-info me-2" id="btnSelecionarTodos">
                                <i class="ri-checkbox-multiple-line"></i> Selecionar Todos
                            </button>
                            <button type="button" class="btn btn-outline-secondary me-2" id="btnSelecionarDivergentes">
                                <i class="ri-filter-line"></i> Selecionar Divergentes
                            </button>
                            <button type="button" class="btn btn-outline-secondary" id="btnLimparSelecao">
                                <i class="ri-checkbox-multiple-blank-line"></i> Limpar Seleção
                            </button>
                        </div>
                        
                        <button type="submit" class="btn btn-primary" id="btnAjustarSelecionados">
                            <i class="ri-equalizer-line"></i> Ajustar Selecionados
                        </button>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkTodos">
                                        </div>
                                    </th>
                                    <th>ID</th>
                                    <th>Código de Barras</th>
                                    <th>Produto</th>
                                    <th>Estoque Atual</th>
                                    <th>Quantidade Contada</th>
                                    <th>Divergência</th>
                                    <th>% Diferença</th>
                                    <th>Observação</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($analise as $item)
                                <tr class="@if($item['divergencia'] > 0) table-success @elseif($item['divergencia'] < 0) table-danger @else table-light @endif">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input item-check" type="checkbox" name="itens_selecionados[]" 
                                                value="{{ $item['item_id'] }}" @if($item['divergencia'] != 0) data-divergente="1" @endif>
                                        </div>
                                    </td>
                                    <td>{{ $item['produto_id'] }}</td>
                                    <td>{{ $item['codigo_barras'] }}</td>
                                    <td>{{ $item['produto_nome'] }}</td>
                                    <td class="text-end">{{ number_format($item['estoque_atual'], 2, ',', '.') }}</td>
                                    <td class="text-end">{{ number_format($item['quantidade_contada'], 2, ',', '.') }}</td>
                                    <td class="text-end @if($item['divergencia'] > 0) text-success fw-bold @elseif($item['divergencia'] < 0) text-danger fw-bold @endif">
                                        {{ number_format($item['divergencia'], 2, ',', '.') }}
                                    </td>
                                    <td class="text-end">{{ $item['percentual'] }}%</td>
                                    <td>{{ $item['observacao'] }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        <div class="alert alert-warning">
                            <i class="ri-error-warning-line me-2"></i>
                            <strong>Atenção!</strong> Ao ajustar o estoque, as quantidades contadas substituirão o estoque atual dos produtos selecionados.
                            Esta operação não pode ser desfeita. Certifique-se de selecionar apenas os produtos que deseja ajustar.
                        </div>
                    </div>
                    
                    <div class="mt-3 d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="ri-equalizer-line"></i> Ajustar Selecionados
                        </button>
                        <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar
                        </a>
                    </div>
                </form>
                
                <div class="mt-4">
                    <div class="card border-danger">
                        <div class="card-body">
                            <h5 class="card-title text-danger"><i class="ri-check-double-line"></i> Finalizar Inventário</h5>
                            <p>
                                Quando todos os produtos estiverem contados e os ajustes necessários feitos, você pode finalizar o inventário.
                                <strong class="text-danger">ATENÇÃO: Esta operação irá zerar o estoque de todos os produtos e aplicar as quantidades contadas.</strong>
                                Este processo não pode ser desfeito.
                            </p>
                            <div class="d-flex justify-content-end">
                                <a href="{{ route('processo-inventario.confirmar-finalizacao', $inventario->id) }}" class="btn btn-danger">
                                    <i class="ri-check-double-line"></i> Finalizar Inventário
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @else
                <div class="alert alert-info">
                    <i class="ri-information-line me-2"></i>
                    Nenhum produto foi contado ainda ou não há divergências a serem analisadas.
                    <a href="{{ route('processo-inventario.manual', $inventario->id) }}" class="alert-link">Clique aqui</a> para realizar a contagem.
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Marcar/desmarcar todos os checkboxes
        $('#checkTodos').change(function() {
            $('.item-check').prop('checked', $(this).prop('checked'));
            updateButtonStatus();
        });
        
        // Marcar apenas os produtos com divergência
        $('#btnSelecionarDivergentes').click(function() {
            $('.item-check').prop('checked', false);
            $('.item-check[data-divergente="1"]').prop('checked', true);
            updateButtonStatus();
        });
        
        // Selecionar todos
        $('#btnSelecionarTodos').click(function() {
            $('.item-check').prop('checked', true);
            updateButtonStatus();
        });
        
        // Limpar seleção
        $('#btnLimparSelecao').click(function() {
            $('.item-check').prop('checked', false);
            updateButtonStatus();
        });
        
        // Atualizar status do botão quando um checkbox é alterado
        $('.item-check').change(function() {
            updateButtonStatus();
        });
        
        // Função para atualizar o status do botão
        function updateButtonStatus() {
            if ($('.item-check:checked').length > 0) {
                $('#btnAjustarSelecionados').prop('disabled', false);
            } else {
                $('#btnAjustarSelecionados').prop('disabled', true);
            }
        }
        
        // Inicializar o status do botão
        updateButtonStatus();
    });
</script>
@endsection

@section('css')
<style>
    .table-success {
        background-color: #d1e7dd !important;
    }
    .table-danger {
        background-color: #f8d7da !important;
    }
    .text-success {
        color: #198754 !important;
    }
    .text-danger {
        color: #dc3545 !important;
    }
</style>
@endsection 