@extends('relatorios.default')
@section('content')

<div class="cabecalho">
    <h3 style="text-align: center;">Relatório de Taxas de Pagamento</h3>
    <p style="text-align: center; margin-bottom: 10px;">
        Período: {{ isset($dataInicial) ? __data_pt($dataInicial) : '--' }} a {{ isset($dataFinal) ? __data_pt($dataFinal) : '--' }}
    </p>
    <div style="text-align: center; padding: 10px; background-color: #e6f3ff; border: 1px solid #cce5ff; border-radius: 4px; margin-bottom: 20px; font-size: 12px;">
        <span style="font-weight: bold;">Informação importante:</span> Este relatório mostra os valores calculados usando as taxas registradas no momento da venda, não as taxas atuais.
        @if(isset($dados['vendasSemTaxa']) && $dados['vendasSemTaxa'] > 0)
            <br><span style="font-weight: bold;">{{ $dados['vendasSemTaxa'] }}</span> vendas não possuem taxas registradas e são exibidas com taxa 0%.
        @endif
    </div>
</div>

<div class="resumo" style="margin-bottom: 20px;">
    <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <tr>
            <td style="width: 33%; padding: 10px; text-align: center; border: 1px solid #ccc; background-color: #f8f9fa;">
                <strong>Total de Vendas:</strong><br>
                {{ __moeda($dados['totalVendas']) }}
            </td>
            <td style="width: 33%; padding: 10px; text-align: center; border: 1px solid #ccc; background-color: #f8f9fa;">
                <strong>Total de Taxas:</strong><br>
                {{ __moeda($dados['totalTaxas']) }} ({{ number_format(($dados['totalVendas'] > 0 ? $dados['totalTaxas'] / $dados['totalVendas'] * 100 : 0), 2) }}%)
            </td>
            <td style="width: 33%; padding: 10px; text-align: center; border: 1px solid #ccc; background-color: #f8f9fa;">
                <strong>Valor Líquido:</strong><br>
                {{ __moeda($dados['totalLiquido']) }} ({{ number_format(($dados['totalVendas'] > 0 ? $dados['totalLiquido'] / $dados['totalVendas'] * 100 : 0), 2) }}%)
            </td>
        </tr>
    </table>
</div>

<div class="detalhamento">
    <h4 style="border-bottom: 1px solid #ccc; padding-bottom: 5px; margin-bottom: 10px;">Detalhamento por Venda</h4>
    
    <table style="width: 100%; border-collapse: collapse; font-size: 10px;">
        <thead>
            <tr style="background-color: #f1f1f1;">
                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #ccc;">Cliente</th>
                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #ccc;">Forma de Pagamento</th>
                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #ccc;">Bandeira</th>
                <th style="padding: 5px; text-align: center; border-bottom: 1px solid #ccc;">Data</th>
                <th style="padding: 5px; text-align: right; border-bottom: 1px solid #ccc;">Valor Total</th>
                <th style="padding: 5px; text-align: center; border-bottom: 1px solid #ccc;">Taxa %</th>
                <th style="padding: 5px; text-align: right; border-bottom: 1px solid #ccc;">Valor Taxa</th>
                <th style="padding: 5px; text-align: right; border-bottom: 1px solid #ccc;">Valor Líquido</th>
                <th style="padding: 5px; text-align: center; border-bottom: 1px solid #ccc;">Tipo</th>
            </tr>
        </thead>
        <tbody>
            @forelse($dados['vendas'] as $key => $venda)
                <tr style="background-color: {{ $key % 2 == 0 ? '#fff' : '#f9f9f9' }}">
                    <td style="padding: 5px; text-align: left; border-bottom: 1px solid #eee;">{{ $venda['cliente'] }}</td>
                    <td style="padding: 5px; text-align: left; border-bottom: 1px solid #eee;">{{ $venda['tipo_pagamento'] }}</td>
                    <td style="padding: 5px; text-align: left; border-bottom: 1px solid #eee;">{{ $venda['bandeira'] }}</td>
                    <td style="padding: 5px; text-align: center; border-bottom: 1px solid #eee;">{{ $venda['data'] }}</td>
                    <td style="padding: 5px; text-align: right; border-bottom: 1px solid #eee;">{{ __moeda($venda['total']) }}</td>
                    <td style="padding: 5px; text-align: center; border-bottom: 1px solid #eee;">{{ __moeda($venda['taxa_perc']) }}%</td>
                    <td style="padding: 5px; text-align: right; border-bottom: 1px solid #eee;">{{ __moeda($venda['valor_taxa']) }}</td>
                    <td style="padding: 5px; text-align: right; border-bottom: 1px solid #eee;">{{ __moeda($venda['valor_liquido']) }}</td>
                    <td style="padding: 5px; text-align: center; border-bottom: 1px solid #eee;">{{ $venda['tipo'] }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="9" style="padding: 15px; text-align: center; border-bottom: 1px solid #eee;">Nenhum dado encontrado para o período selecionado.</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr style="background-color: #f1f1f1; font-weight: bold;">
                <td colspan="4" style="padding: 8px; text-align: right; border-top: 2px solid #ccc;">Total:</td>
                <td style="padding: 8px; text-align: right; border-top: 2px solid #ccc;">{{ __moeda($dados['totalVendas']) }}</td>
                <td style="padding: 8px; text-align: center; border-top: 2px solid #ccc;"></td>
                <td style="padding: 8px; text-align: right; border-top: 2px solid #ccc;">{{ __moeda($dados['totalTaxas']) }}</td>
                <td style="padding: 8px; text-align: right; border-top: 2px solid #ccc;">{{ __moeda($dados['totalLiquido']) }}</td>
                <td style="padding: 8px; text-align: center; border-top: 2px solid #ccc;"></td>
            </tr>
        </tfoot>
    </table>
</div>

@endsection 