// Funções para gerenciar tema claro/escuro
document.addEventListener('DOMContentLoaded', function() {
    // Verifica se já existe uma preferência salva
    const savedTheme = localStorage.getItem('pdv_theme') || 'light';
    setTheme(savedTheme);
    
    // Inicializa o botão de toggle se ele existir
    initThemeToggle();
});

// Define o tema atual
window.setTheme = function(themeName) {
    document.documentElement.setAttribute('data-theme', themeName);
    localStorage.setItem('pdv_theme', themeName);
}

// Alterna entre temas
defaultToggleTheme = function() {
    const currentTheme = localStorage.getItem('pdv_theme') || 'light';
    if (currentTheme === 'light') {
        window.setTheme('dark');
    } else {
        window.setTheme('light');
    }
    updateToggleButton();
}
window.toggleTheme = defaultToggleTheme;

// Inicializa o botão de toggle
function initThemeToggle() {
    // Se o botão de toggle não existe, cria-o (DESATIVADO)
    /*
    if (!document.querySelector('.theme-toggle')) {
        const toggleDiv = document.createElement('div');
        toggleDiv.className = 'theme-toggle';
        
        const toggleButton = document.createElement('button');
        toggleButton.className = 'theme-toggle-btn';
        toggleButton.id = 'theme-toggle-btn';
        toggleButton.setAttribute('aria-label', 'Alternar tema claro/escuro');
        toggleButton.onclick = toggleTheme;
        
        // Adiciona o ícone correspondente ao tema atual
        updateToggleButtonIcon(toggleButton);
        
        toggleDiv.appendChild(toggleButton);
        document.body.appendChild(toggleDiv);
    }
    */
    
    // Atualiza o ícone do botão existente
    updateToggleButton();
}

// Atualiza o ícone do botão baseado no tema atual
function updateToggleButton() {
    const button = document.getElementById('theme-toggle-btn');
    if (button) {
        updateToggleButtonIcon(button);
    }
}

// Define o ícone correto para o botão
function updateToggleButtonIcon(button) {
    const currentTheme = localStorage.getItem('pdv_theme') || 'light';
    
    if (currentTheme === 'dark') {
        button.innerHTML = '<i class="ri-sun-line"></i>';
        button.title = 'Mudar para tema claro';
    } else {
        button.innerHTML = '<i class="ri-moon-line"></i>';
        button.title = 'Mudar para tema escuro';
    }
} 