<?php
// Definir timezone para Brasília (ou timezone correto do Brasil)
date_default_timezone_set('America/Sao_Paulo');

// Checar configurações atuais
echo "Timezone atual: " . date_default_timezone_get() . "\n";
echo "Data/hora atual: " . date('Y-m-d H:i:s') . "\n";
echo "Data/hora formatada para XML: " . date('Y-m-d\TH:i:sP') . "\n";

// Verificar diferença com servidor NTP
echo "\nVerificando sincronização de hora com servidor NTP...\n";
try {
    $ntp_time = json_decode(file_get_contents('http://worldtimeapi.org/api/timezone/America/Sao_Paulo'));
    echo "Horário NTP: " . date('Y-m-d H:i:s', $ntp_time->unixtime) . "\n";
    $diff = abs(time() - $ntp_time->unixtime);
    echo "Diferença: " . $diff . " segundos\n";
    
    if ($diff > 60) {
        echo "ALERTA: Diferença maior que 1 minuto detectada!\n";
    }
} catch (Exception $e) {
    echo "Erro ao verificar horário NTP: " . $e->getMessage() . "\n";
} 