<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Criar tabela de alocações de centro de custo para contas a receber
        Schema::create('alocacao_conta_receber', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conta_receber_id')->nullable()->constrained('conta_recebers');
            $table->foreignId('centro_custo_id')->nullable()->constrained('centro_custos');
            $table->decimal('valor', 16, 7);
            $table->decimal('porcentagem', 5, 2);
            $table->text('observacao')->nullable();
            $table->timestamps();
        });
        
        // Modificar modelo AlocacaoCentroCusto para permitir uso em contas a receber
        Schema::table('alocacao_centro_custos', function (Blueprint $table) {
            $table->foreignId('conta_receber_id')->nullable()->constrained('conta_recebers')->after('conta_pagar_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remover coluna da tabela existente
        Schema::table('alocacao_centro_custos', function (Blueprint $table) {
            $table->dropForeign(['conta_receber_id']);
            $table->dropColumn('conta_receber_id');
        });
        
        // Remover tabela criada
        Schema::dropIfExists('alocacao_conta_receber');
    }
};
