<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddValorDiferencaToDevolucoes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            // Verificar se o campo is_troca não existe antes de criar
            if (!Schema::hasColumn('devolucoes', 'is_troca')) {
                $table->boolean('is_troca')->default(false)->comment('True para troca, False para devolução simples');
            }
            
            // Verificar se o campo valor_diferenca não existe antes de criar
            if (!Schema::hasColumn('devolucoes', 'valor_diferenca')) {
                $table->decimal('valor_diferenca', 10, 2)->nullable()->comment('Diferença entre valores na troca. Positivo: cliente recebe, Negativo: cliente paga');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('devolucoes', function (Blueprint $table) {
            if (Schema::hasColumn('devolucoes', 'is_troca')) {
                $table->dropColumn('is_troca');
            }
            if (Schema::hasColumn('devolucoes', 'valor_diferenca')) {
                $table->dropColumn('valor_diferenca');
            }
        });
    }
} 