<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;

class NotificacaoService
{
    /**
     * Obtém a lista de destinatários de email a partir da variável de ambiente
     * 
     * @param string $envVar Nome da variável de ambiente (padrão: MAIL_NOVAEMPRESA)
     * @param string $default Email padrão caso a variável não esteja definida
     * @return array Lista de emails para envio
     */
    public static function getDestinatarios($envVar = 'MAIL_NOVAEMPRESA', $default = 'admin@exemplo.com')
    {
        $emails = env($envVar, $default);
        $lista = explode(';', $emails);
        
        // Remove espaços e emails vazios
        $lista = array_map('trim', $lista);
        $lista = array_filter($lista, function($email) {
            return !empty($email) && filter_var($email, FILTER_VALIDATE_EMAIL);
        });
        
        // Adiciona email master se configurado
        if (env('MAILMASTER')) {
            $lista[] = env('MAILMASTER');
        }
        
        Log::debug('Destinatários para notificação:', ['lista' => $lista, 'fonte' => $envVar]);
        
        return $lista;
    }
} 