<?php

namespace App\Observers;

use App\Models\FaturaNfce;
use App\Models\TaxaPagamento;

class FaturaNfceTaxaObserver
{
    /**
     * Handle the FaturaNfce "created" event.
     */
    public function created(FaturaNfce $fatura)
    {
        if (!empty($fatura->tipo_pagamento) && !empty($fatura->nfce) && !empty($fatura->nfce->empresa_id)) {
            $bandeira_cartao = $fatura->nfce->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $fatura->nfce->empresa_id)
                ->where('tipo_pagamento', $fatura->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $fatura->taxa_percentual = $taxa->taxa;
                $fatura->save();
            }
        }
    }
} 