<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaxaHistorico extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'taxa_historico';

    /**
     * Os atributos que são atribuíveis em massa
     */
    protected $fillable = [
        'empresa_id',
        'taxa_pagamento_id',
        'taxa_anterior',
        'taxa_nova',
        'tipo_pagamento',
        'bandeira_cartao',
        'usuario_id'
    ];

    /**
     * Relacionamento com a empresa
     */
    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    /**
     * Relacionamento com a taxa de pagamento
     */
    public function taxaPagamento()
    {
        return $this->belongsTo(TaxaPagamento::class);
    }

    /**
     * Relacionamento com o usuário que fez a alteração
     */
    public function usuario()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Retorna o nome do tipo de pagamento
     */
    public function getTipoPagamentoNome()
    {
        $tipos = TaxaPagamento::tiposPagamento();
        return $tipos[$this->tipo_pagamento] ?? 'Desconhecido';
    }

    /**
     * Retorna o nome da bandeira de cartão
     */
    public function getBandeiraNome()
    {
        if (empty($this->bandeira_cartao)) {
            return '--';
        }
        
        $bandeiras = TaxaPagamento::bandeiras();
        return $bandeiras[$this->bandeira_cartao] ?? 'Desconhecida';
    }
} 