<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItemNfe extends Model
{
    use HasFactory;

    protected $fillable = [
        'nfe_id', 'produto_id', 'quantidade', 'valor_unitario', 'sub_total', 'perc_icms', 'perc_pis',
        'perc_cofins', 'perc_ipi', 'cst_csosn', 'cst_pis', 'cst_cofins', 'cst_ipi', 'perc_red_bc', 'cfop',
        'ncm', 'origem', 'cEnq', 'pST', 'vBCSTRet', 'cest', 'codigo_beneficio_fiscal', 'numero_item',
        'status', 'quantidade_devolvida', 'item_substituto_id'
    ];

    public function produto(){
        return $this->belongsTo(Produto::class, 'produto_id');
    }

    public function nfe(){
        return $this->belongsTo(Nfe::class, 'nfe_id');
    }

    public function itemSubstituto(){
        return $this->belongsTo(ItemNfe::class, 'item_substituto_id');
    }

    /**
     * Retorna se o item foi totalmente devolvido ou trocado
     */
    public function isDevolvido(){
        return $this->status == 1;
    }

    /**
     * Retorna se o item foi totalmente ou parcialmente trocado
     */
    public function isTrocado(){
        return $this->status == 2;
    }

    /**
     * Retorna a quantidade disponível para devolução
     */
    public function getQuantidadeDisponivel(){
        return $this->quantidade - $this->quantidade_devolvida;
    }

    public function produtoVariacao(){
        return $this->belongsTo(ProdutoVariacao::class, 'variacao_id');
    }

    public function itensDimensao(){
        return $this->hasMany(ItemDimensaoNfe::class, 'item_nfe_id');
    }

    public function descricao(){
        if($this->variacao_id == null){
            return $this->produto->nome;
        }
        if($this->produtoVariacao){
            return $this->produto->nome . " - " . $this->produtoVariacao->descricao;
        }

        return $this->produto->nome;
    }
}
