<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResumoSemanalNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $estatisticas;

    /**
     * Create a new message instance.
     *
     * @param array $estatisticas
     * @return void
     */
    public function __construct(array $estatisticas)
    {
        $this->estatisticas = $estatisticas;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Resumo Semanal NGBPrime - ' . $this->estatisticas['periodo']['inicio'] . ' a ' . $this->estatisticas['periodo']['fim'])
            ->markdown('emails.sistema.resumo-semanal')
            ->with([
                'estatisticas' => $this->estatisticas
            ]);
    }
} 