<?php

namespace App\Mail;

use App\Models\Empresa;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NovaEmpresaNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $empresa;

    /**
     * Create a new message instance.
     *
     * @param Empresa $empresa
     * @return void
     */
    public function __construct(Empresa $empresa)
    {
        $this->empresa = $empresa;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Nova Empresa Cadastrada: ' . $this->empresa->razao_social)
            ->markdown('emails.empresas.nova-empresa')
            ->with([
                'empresa' => $this->empresa,
                'dataRegistro' => now()->format('d/m/Y H:i:s'),
                'linkAdmin' => url('/empresas/' . $this->empresa->id)
            ]);
    }
} 