<?php

namespace App\Http\Controllers\API\PDV;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Produto;
use App\Models\ListaPreco;
use App\Models\CategoriaProduto;
use App\Models\Estoque;
use App\Utils\EstoqueUtil;

class ProdutoController extends Controller
{
    protected $estoqueUtil;

    public function __construct(EstoqueUtil $estoqueUtil)
    {
        $this->estoqueUtil = $estoqueUtil;
    }

    public function produtos(Request $request){
        $updated_at = $request->updated_at;
        $data = Produto::where('empresa_id', $request->empresa_id)
        ->select('id', 'nome', 'valor_unitario', 'categoria_id', 'codigo_barras', 'imagem', 'gerenciar_estoque')
        ->with(['categoria', 'estoque'])
        ->where('status', 1)
        ->get();
        return response()->json($data, 200);
    }

    public function categorias(Request $request){
        $data = CategoriaProduto::where('empresa_id', $request->empresa_id)
        ->get();
        return response()->json($data, 200);
    }

    public function listaPreco(Request $request){
        $data = ListaPreco::where('empresa_id', $request->empresa_id)
        ->with('itens')
        ->get();
        return response()->json($data, 200);
    }

    // Busca um produto por ID ou código de barras para adicionar ao PDV
    public function find(Request $request)
    {
        $termo = $request->input('termo');
        
        $produto = Produto::where('empresa_id', $request->empresa_id)
        ->where(function($query) use ($termo) {
            $query->where('codigo_barras', $termo)
            ->orWhere('codigo_barras2', $termo)
            ->orWhere('codigo_barras3', $termo)
            ->orWhere('id', $termo);
        })
        ->where('status', 1)
        ->first();
        
        if($produto){
            // Verifica se o produto tem estoque suficiente antes de permitir a adição
            $quantidade = $request->input('quantidade', 1);
            $local_id = $request->input('local_id');
            
            if($produto->gerenciar_estoque){
                $mensagem = $this->estoqueUtil->verificaEstoque($produto->id, $quantidade, null, $local_id);
                if($mensagem != ""){
                    return response()->json(['erro' => $mensagem], 422);
                }
            }
            
            return response()->json($produto);
        }
        
        return response()->json(['erro' => 'Produto não encontrado'], 404);
    }
}
