@extends('relatorios.default', ['title' => 'Relatório de Fornecedores'])
@section('content')

@section('css')
<style type="text/css">
    .summary-box {
        background-color: #f8f9fa;
        border-radius: 4px;
        padding: 8px 10px;
        margin-bottom: 10px;
        border-left: 3px solid #3366cc;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .summary-title {
        font-size: 11px;
        color: #2c3e50;
        font-weight: bold;
    }
    
    .summary-value {
        font-size: 13px;
        color: #3366cc;
        font-weight: bold;
    }
    
    .suppliers-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 10px;
        font-size: 8px;
    }
    
    .suppliers-table th {
        background: linear-gradient(to bottom, #f8f9fa, #e9ecef);
        color: #2c3e50;
        padding: 4px 5px;
        text-align: left;
        font-weight: bold;
        font-size: 8px;
        border-bottom: 1px solid #dee2e6;
    }
    
    .suppliers-table td {
        padding: 3px 5px;
        border-bottom: 1px solid #e9ecef;
        font-size: 8px;
        vertical-align: top;
    }
    
    .suppliers-table tr:nth-child(even) {
        background-color: #f8f9fa;
    }
    
    .document {
        font-family: 'Courier New', monospace;
        font-size: 8px;
        color: #555;
    }
    
    .city-info {
        font-size: 8px;
        color: #3366cc;
    }
    
    .text-right {
        text-align: right;
    }
    
    .text-center {
        text-align: center;
    }
</style>
@endsection

@if($tipo != '')
<div class="summary-box">
    <div class="summary-title">Total comprado:</div>
    <div class="summary-value">{{ __moeda($data->sum('total')) }}</div>
</div>
@endif

<table class="suppliers-table">
    <thead>
        <tr>
            <th style="width: 20%">Razão social</th>
            <th style="width: 15%">Nome fantasia</th>
            <th style="width: 12%">CPF/CNPJ</th>
            <th style="width: 10%">IE</th>
            <th style="width: 18%">Endereço</th>
            <th style="width: 10%">Cidade</th>
            <th style="width: 7%">Data cadast.</th>
            @if($tipo != '')
            <th style="width: 8%" class="text-right">Total comprado</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @foreach($data as $key => $item)
        <tr>
            <td>{{ $item->razao_social ?: 'Não informado' }}</td>
            <td>{{ $item->nome_fantasia ?: 'Não informado' }}</td>
            <td><span class="document">{{ $item->cpf_cnpj ?: 'Não informado' }}</span></td>
            <td><span class="document">{{ $item->ie ?: 'Não informado' }}</span></td>
            <td>{{ $item->endereco ?: 'Não informado' }}</td>
            <td><span class="city-info">{{ $item->cidade ? $item->cidade->info : 'Não informado' }}</span></td>
            <td class="text-center">{{ __data_pt($item->created_at) }}</td>
            @if($tipo != '')
            <td class="text-right">{{ __moeda($item->total) }}</td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@endsection
