<!-- Modal da Pesquisa NPS -->
<div class="modal fade" id="modal-nps" tabindex="-1" aria-labelledby="modal-nps-label" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modal-nps-label">{{ isset($titulo_nps) ? $titulo_nps : 'Pesquisa de Satisfação' }}</h5>
            </div>
            <div class="modal-body">
                <form id="form-nps">
                    <!-- Descrição personalizada (se existir) -->
                    <div class="mb-3" id="nps-descricao-container">
                        <!-- Será preenchido dinamicamente pelo JS -->
                    </div>
                    
                    <!-- Pergunta principal (obrigatória) -->
                    <div class="mb-4">
                        <h6 class="fw-bold">
                            <span class="badge bg-success">✅</span> 
                            Em uma escala de 0 a 10, o quanto você recomendaria nosso sistema para um amigo ou colega de trabalho?
                            <span class="text-danger">*</span>
                        </h6>
                        <div class="nps-scale my-3 text-center">
                            <!-- Escala de notas de 0 a 10 -->
                            <div class="btn-group" role="group" aria-label="Escala NPS">
                                @for($i = 0; $i <= 10; $i++)
                                <input type="radio" class="btn-check" name="nota" id="nota-{{ $i }}" value="{{ $i }}" required>
                                <label class="btn btn-outline-secondary nps-btn" for="nota-{{ $i }}">{{ $i }}</label>
                                @endfor
                            </div>
                            <div class="d-flex justify-content-between mt-2 text-muted small">
                                <div>Pouco provável</div>
                                <div>Muito provável</div>
                            </div>
                        </div>
                        <div class="invalid-feedback" id="nota-error">
                            Por favor, selecione uma nota.
                        </div>
                    </div>

                    <!-- Pergunta secundária (condicional) -->
                    <div id="feedback-container" class="mb-4 d-none">
                        <h6 class="fw-bold">
                            <span class="badge bg-primary">💬</span> 
                            O que poderíamos fazer para melhorar sua nota?
                        </h6>
                        <textarea class="form-control mt-2" id="feedback" name="feedback" rows="3" placeholder="Seu feedback é muito importante para nós..."></textarea>
                    </div>

                    <!-- Opção de ignorar pesquisa -->
                    <div class="form-check mt-4">
                        <input class="form-check-input" type="checkbox" value="1" id="ignorar" name="ignorar">
                        <label class="form-check-label text-muted" for="ignorar">
                            Não desejo responder a esta pesquisa (será exibida novamente no próximo mês)
                        </label>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-enviar-nps">Enviar resposta</button>
            </div>
        </div>
    </div>
</div>

<!-- Estilo para o modal de NPS -->
<style>
    .nps-btn {
        width: 36px;
        padding: 6px 0;
        border-radius: 0;
    }
    .nps-btn:first-child {
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
    .nps-btn:last-child {
        border-top-right-radius: 4px;
        border-bottom-right-radius: 4px;
    }
    .btn-check:checked + .nps-btn {
        background-color: #0d6efd;
        border-color: #0d6efd;
        color: white;
        font-weight: bold;
    }
    .btn-check:focus + .nps-btn {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }
    
    /* Cores de classificação NPS */
    .btn-check[value="0"]:checked + .nps-btn, 
    .btn-check[value="1"]:checked + .nps-btn,
    .btn-check[value="2"]:checked + .nps-btn,
    .btn-check[value="3"]:checked + .nps-btn,
    .btn-check[value="4"]:checked + .nps-btn,
    .btn-check[value="5"]:checked + .nps-btn,
    .btn-check[value="6"]:checked + .nps-btn {
        background-color: #dc3545;
        border-color: #dc3545;
    }
    
    .btn-check[value="7"]:checked + .nps-btn,
    .btn-check[value="8"]:checked + .nps-btn {
        background-color: #ffc107;
        border-color: #ffc107;
        color: #212529;
    }
    
    .btn-check[value="9"]:checked + .nps-btn,
    .btn-check[value="10"]:checked + .nps-btn {
        background-color: #198754;
        border-color: #198754;
    }
</style>

<!-- Script para o modal de NPS -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Verificar se deve exibir a pesquisa NPS (apenas uma vez por dia/sessão)
        function verificarExibicaoNPS() {
            // Verificar se já exibimos hoje
            const hoje = new Date().toDateString();
            const jaExibidoHoje = localStorage.getItem('nps_exibido_data') === hoje;
            
            // Se já exibimos hoje, não exibe novamente
            if (jaExibidoHoje) {
                return;
            }
            
            fetch('{{ route("nps.verificar-exibicao") }}')
                .then(response => response.json())
                .then(data => {
                    if (data.exibir) {
                        // Atualizar título e descrição se fornecidos
                        if (data.titulo) {
                            document.getElementById('modal-nps-label').textContent = data.titulo;
                        }
                        
                        if (data.descricao) {
                            document.getElementById('nps-descricao-container').innerHTML = `
                                <div class="alert alert-info mb-3">
                                    <i class="ri-information-line"></i> ${data.descricao}
                                </div>
                            `;
                        } else {
                            document.getElementById('nps-descricao-container').innerHTML = '';
                        }
                        
                        // Marcar como exibido hoje
                        localStorage.setItem('nps_exibido_data', hoje);
                        
                        // Exibir após um segundo
                        setTimeout(() => {
                            $('#modal-nps').modal('show');
                        }, 1000);
                    }
                })
                .catch(error => console.error('Erro ao verificar exibição da pesquisa:', error));
        }
        
        // Mostrar feedback apenas se a nota for menor que 9
        $('input[name="nota"]').on('change', function() {
            const nota = parseInt($(this).val());
            if (nota < 9) {
                $('#feedback-container').removeClass('d-none');
            } else {
                $('#feedback-container').addClass('d-none');
            }
        });
        
        // Desabilitar botão de enviar se o checkbox de ignorar estiver marcado (e vice-versa)
        $('#ignorar').on('change', function() {
            const ignorar = $(this).is(':checked');
            if (ignorar) {
                // Se ignorar, desabilitar os campos de nota
                $('input[name="nota"]').prop('required', false);
                // Limpar as validações
                $('#nota-error').hide();
                $('.is-invalid').removeClass('is-invalid');
            } else {
                // Se não ignorar, habilitar os campos de nota novamente
                $('input[name="nota"]').prop('required', true);
            }
        });
        
        // Enviar o formulário
        $('#btn-enviar-nps').on('click', function() {
            const form = document.getElementById('form-nps');
            const ignorar = $('#ignorar').is(':checked');
            let valido = true;
            
            // Validar o formulário se não estiver ignorando
            if (!ignorar) {
                // Verificar se uma nota foi selecionada
                if (!$('input[name="nota"]:checked').length) {
                    $('#nota-error').show();
                    valido = false;
                } else {
                    $('#nota-error').hide();
                }
            }
            
            if (valido) {
                // Preparar os dados para envio
                const formData = {
                    nota: ignorar ? null : $('input[name="nota"]:checked').val(),
                    feedback: $('#feedback').val(),
                    ignorar: ignorar
                };
                
                // Enviar para o servidor
                fetch('{{ route("nps.salvar-resposta") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Fechar o modal
                        $('#modal-nps').modal('hide');
                        
                        // Mostrar mensagem de agradecimento
                        if (!ignorar) {
                            Swal.fire({
                                title: 'Obrigado pelo feedback!',
                                text: 'Sua opinião é muito importante para nós.',
                                icon: 'success',
                                confirmButtonText: 'Fechar'
                            });
                        }
                    } else {
                        // Tratar erro
                        Swal.fire({
                            title: 'Erro',
                            text: data.message || 'Ocorreu um erro ao enviar sua resposta.',
                            icon: 'error',
                            confirmButtonText: 'Fechar'
                        });
                    }
                })
                .catch(error => {
                    console.error('Erro ao enviar resposta:', error);
                    Swal.fire({
                        title: 'Erro',
                        text: 'Não foi possível enviar sua resposta. Tente novamente mais tarde.',
                        icon: 'error',
                        confirmButtonText: 'Fechar'
                    });
                });
            }
        });
        
        // Executar apenas uma vez ao carregar a página
        verificarExibicaoNPS();
    });
</script> 