@extends('layouts.app', ['title' => 'Importar NCM'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4 class="mb-4">Importar Tabela NCM</h4>
                
                <div class="alert alert-info">
                    <i class="ri-information-line me-2"></i>
                    <strong>Atenção!</strong> A importação substituirá todos os NCMs existentes. Certifique-se de que o arquivo está no formato correto.
                    <div>
                        <strong>Formato esperado:</strong> 
                        <br>Código | Descrição
                        <br>Os dados devem estar nas colunas A e B, respectivamente.
                    </div>
                </div>

                <form action="{{ route('ncm.import.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="mb-3">
                        <label for="arquivo_excel" class="form-label">Selecione o arquivo Excel (.xlsx)</label>
                        <input type="file" class="form-control" id="arquivo_excel" name="arquivo_excel" accept=".xlsx" required>
                    </div>
                    
                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-upload-2-line me-1"></i>
                            Importar
                        </button>
                        <a href="{{ route('ncm.index') }}" class="btn btn-secondary ms-2">
                            <i class="ri-arrow-left-line me-1"></i>
                            Voltar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 