@php
function padRight(
    $string,
    $length,
    $pad = ' '
) {
    return mb_strimwidth(str_pad($string, $length, $pad), 0, $length);
}
@endphp
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Conferência Comanda #{{ str_pad($mesa->numero, 3, '0', STR_PAD_LEFT) }}</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 13px;
            width: 300px;
            margin: 0 auto;
        }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .line { border-bottom: 1px dashed #000; margin: 4px 0; }
        .item-row { display: flex; justify-content: space-between; }
        .item-col { white-space: pre; }
        @media print {
            body { width: 100%; margin: 0; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="center bold">*** CONFERÊNCIA DE COMANDA ***</div>
    <div class="center">Comanda: <span class="bold">{{ str_pad($mesa->numero, 3, '0', STR_PAD_LEFT) }}</span></div>
    <div class="center">Atendente: <span class="bold">{{ $usuario->name ?? '-' }}</span></div>
    <div class="center">Data/Hora: {{ now()->format('d/m/Y H:i') }}</div>
    <div class="line"></div>
    <div class="item-row bold">
        <span class="item-col">QTD</span>
        <span class="item-col">PRODUTO</span>
        <span class="item-col">UNIT</span>
        <span class="item-col">SUBT</span>
    </div>
    <div class="line"></div>
    @php $total = 0; @endphp
    @foreach($mesa->itens as $item)
        @php
            $nome = padRight($item->produto->nome ?? 'Produto', 16);
            $qtd = padRight($item->quantidade, 3);
            $unit = padRight(number_format($item->valor_unitario, 2, ',', '.'), 6);
            $subt = padRight(number_format($item->subtotal, 2, ',', '.'), 6);
            $total += $item->subtotal;
        @endphp
        <div class="item-row">
            <span class="item-col">{{ $qtd }}</span>
            <span class="item-col">{{ $nome }}</span>
            <span class="item-col">{{ $unit }}</span>
            <span class="item-col">{{ $subt }}</span>
        </div>
    @endforeach
    <div class="line"></div>
    <div class="item-row bold">
        <span class="item-col">TOTAL COMANDA:</span>
        <span class="item-col">{{ number_format($total, 2, ',', '.') }}</span>
    </div>
    <div class="item-row bold">
        <span class="item-col">TOTAL GERAL:</span>
        <span class="item-col">{{ number_format($total, 2, ',', '.') }}</span>
    </div>
    <div class="center" style="margin-top: 10px;">*** FIM ***</div>
</body>
</html> 