@extends('layouts.app', ['title' => 'Receber Pagamento'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-header">
                <h4>Receber Pagamento</h4>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="{{ route('financeiro-plano.index') }}" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h5>Detalhes do Plano</h5>
                        <table class="table table-bordered">
                            <tr>
                                <th>Empresa</th>
                                <td>{{ $item->empresa->info }}</td>
                            </tr>
                            <tr>
                                <th>Plano</th>
                                <td>{{ $item->plano->nome }}</td>
                            </tr>
                            <tr>
                                <th>Valor Total</th>
                                <td>{{ __moeda($item->valor) }}</td>
                            </tr>
                            @if($item->valor_repasse)
                            <tr>
                                <th>Valor Repasse</th>
                                <td>{{ __moeda($item->valor_repasse) }}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($item->status_pagamento == 'pendente')
                                        <span class="badge bg-warning">{{ strtoupper($item->status_pagamento) }}</span>
                                    @elseif($item->status_pagamento == 'recebido')
                                        <span class="badge bg-success">{{ strtoupper($item->status_pagamento) }}</span>
                                    @else
                                        <span class="badge bg-danger">{{ strtoupper($item->status_pagamento) }}</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <h5>Registrar Recebimento</h5>
                <hr>

                {!!Form::open()
                ->post()
                ->route('financeiro-plano.receber-store', [$item->id])
                !!}
                <div class="row g-2">
                    <div class="col-md-3">
                        {!!Form::date('data_pagamento', 'Data de Pagamento')
                        ->required()
                        ->value(date('Y-m-d'))
                        !!}
                    </div>

                    <div class="col-md-3">
                        {!!Form::select('forma_pagamento', 'Forma de Pagamento', $formasPagamento)
                        ->required()
                        ->attrs(['class' => 'select2'])
                        !!}
                    </div>
                    
                    <div class="col-md-3">
                        {!!Form::text('valor_pago', 'Valor Pago')->attrs(['class' => 'moeda'])->required()
                        ->value(__moeda($item->valor))
                        !!}
                    </div>
                    
                    <div class="col-md-3">
                        {!!Form::text('valor_repasse', 'Valor Repasse')->attrs(['class' => 'moeda'])
                        ->value($item->valor_repasse ? __moeda($item->valor_repasse) : '')
                        !!}
                    </div>
                    
                    <div class="col-md-12 mt-2">
                        {!!Form::textarea('observacao', 'Observação')
                        ->attrs(['rows' => 3])
                        !!}
                    </div>
                    
                    <div class="col-12 mt-3" style="text-align: right;">
                        <button type="submit" class="btn btn-success px-5">Registrar Pagamento</button>
                    </div>
                </div>
                {!!Form::close()!!}
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function(){
        $('.moeda').mask("#.##0,00", {reverse: true});
    });
</script>
@endsection 