@extends('layouts.app', ['title' => 'Caixa'])
@section('content')
<style>
    .pagamentos-compactos {
        display: flex;
        flex-direction: column;
        gap: 0.3rem;
    }
    
    .pagamentos-compactos .badge {
        min-width: 80px;
        display: inline-block;
        width: auto;
        white-space: normal;
        text-align: left;
        padding: 0.4em 0.65em;
        line-height: 1.2;
    }
    
    .pagamentos-compactos .mb-1 {
        display: flex;
        align-items: center;
        margin-bottom: 0 !important;
    }
    
    .pagamentos-compactos .parcelamento {
        color: #6c757d;
        font-size: 0.9em;
        white-space: nowrap;
    }
    
    /* Estilo personalizado para zebra striping com cinza claro */
    .table-striped-light tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.02);
    }
    
    /* Alinhar valores à esquerda */
    .table-centered td {
        vertical-align: middle;
    }
    
    .text-end.text-success,
    .text-end.text-warning,
    .text-end {
        text-align: left !important;
    }
    
    /* Melhorar exibição de pagamentos */
    .pagamento-info {
        display: block;
        margin-bottom: 4px;
    }
</style>
<div class="mt-3">
    <div class="row">
        <div class="card">
            @if($item->status == 0)
            <a href="{{ route('caixa.create') }}" class="btn btn-success">
                <i class="ri-add-circle-fill"></i>
                Abrir Caixa
            </a>
            @else
            <div class="card-body">
                @php
                // Inicialização antecipada das variáveis para evitar erro
                $somaSuprimento = 0;
                $somaSangria = 0;
                
                if (isset($suprimentos) && sizeof($suprimentos) > 0) {
                    foreach ($suprimentos as $s) {
                        $somaSuprimento += $s->valor;
                    }
                }
                
                if (isset($sangrias) && sizeof($sangrias) > 0) {
                    foreach ($sangrias as $s) {
                        $somaSangria += $s->valor;
                    }
                }
                @endphp
                
                <div class="card-body mt-1">
                    <div class="bg-light-subtle border-top border-bottom border-light">
                        <div class="row text-center">

                            @if(__countLocalAtivo() > 1)
                            <h5 class="mt-2">Local: <strong class="text-danger">{{ $item->localizacao ? $item->localizacao->descricao : '' }}</strong></h5>
                            @endif
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-shield-user-fill"></i> Usuário</p>
                                <h3 class="fw-normal mb-3">
                                    <span>{{ $item->usuario->name }}</span>
                                </h3>
                            </div>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-file-list-2-line"></i> Data de Abertura</p>
                                <h3 class="fw-normal mb-3">
                                    <span>{{ __data_pt($item->created_at, 1) }}</span>
                                </h3>
                            </div>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-money-dollar-circle-line"></i> Valor de Abertura</p>
                                <h3 class="fw-normal mb-3">
                                    <span>{{ __moeda($item->valor_abertura) }}</span>
                                </h3>
                            </div>
                            @if($item->contaEmpresa)
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-money-dollar-circle-line"></i> Conta</p>
                                <h3 class="fw-normal mb-3">
                                    <span>{{ $item->contaEmpresa->nome }}</span>
                                </h3>
                            </div>
                            @endif
                        </div>

                        @if($item->observacao)
                        <div class="row">
                            <div class="col-12 m-3 text-primary">
                                {{ $item->observacao }}
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card border-primary shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-money-dollar-box-line me-2"></i>Total por Tipo de Pagamento Vendas</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                    @foreach($somaTiposPagamento as $key => $tp)
                    @if($tp > 0)
                    <div class="col-sm-4 col-lg-3 col-md-6 mb-3">
                                        <div class="card h-100 {{ ($key == '05' || $key == '06' || $key == '15') ? 'border-warning' : 'border-success' }}">
                                            <div class="card-header {{ ($key == '05' || $key == '06' || $key == '15') ? 'bg-warning text-dark' : 'bg-success text-white' }}" style="min-height: 70px;">
                                                <h4 class="mb-1">
                                    {{App\Models\Nfce::getTipoPagamento($key)}}
                                                </h4>
                                @if($key == '05' || $key == '06' || $key == '15')
                                <small class="text-muted d-block">(não soma no valor do caixa)</small>
                                @endif
                            </div>
                            @php
                            if($key == '01') $somaDinheiro = $tp;
                            @endphp
                                            <div class="card-body text-center">
                                                <h3 class="{{ ($key == '05' || $key == '06' || $key == '15') ? 'text-warning' : 'text-success' }}">R$ {{ __moeda($tp) }}</h3>
                            </div>
                        </div>
                    </div>
                    @endif
                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Movimentações de Vendas -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-primary shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-shopping-cart-line me-2"></i>Movimentações de Vendas</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                            <thead class="table-dark">
                                <tr>
                                                <th>ID</th>
                                    <th>Tipo</th>
                                    <th>Cliente</th>
                                    <th>Data</th>
                                                <th>Forma(s) de Pagamento</th>
                                    <th>À Vista</th>
                                    <th>A Prazo</th>
                                    <th>Valor Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php 
                                $somaReceita = 0; 
                                $somaDespesa = 0; 
                                @endphp
                                
                                            @forelse ($vendasAgrupadas as $venda)
                                                @if(!isset($venda->estado) || $venda->estado != 'cancelado')
                                                <tr>
                                                    @php
                                                    // Calcular quanto da venda é à vista vs a prazo
                                                    $valorAVista = 0;
                                                    $valorAPrazo = 0;
                                                    
                                                    foreach($venda->pagamentos as $pagamento) {
                                                        if($pagamento->a_prazo) {
                                                            $valorAPrazo += $pagamento->valor_pagamento;
                                                        } else {
                                                            $valorAVista += $pagamento->valor_pagamento;
                                                        }
                                                    }
                                                    @endphp
                                                    <td>{{ $venda->doc_id }}</td>
                                                    <td>{{ $venda->tipo }}</td>
                                                    <td>{{ $venda->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}</td>
                                                    <td>{{ __data_pt($venda->created_at, 1) }}</td>
                                                    <td>
                                                        @php
                                                        // Agrupar pagamentos por tipo para economizar espaço
                                                        $pagamentosAgrupados = [];
                                                        foreach($venda->pagamentos as $pag) {
                                                            $tipo = $pag->pagamento_nome;
                                                            if (!isset($pagamentosAgrupados[$tipo])) {
                                                                $pagamentosAgrupados[$tipo] = [
                                                                    'a_prazo' => $pag->a_prazo,
                                                                    'valor' => 0,
                                                                    'info_parcela' => '',
                                                                    'num_parcelas' => $pag->num_parcelas ?? 1,
                                                                    'valor_parcela' => $pag->valor_parcela ?? 0,
                                                                    'parcelado' => $pag->parcelado ?? false
                                                                ];
                                                            }

                                                            $pagamentosAgrupados[$tipo]['valor'] += $pag->valor_pagamento;
                                                            
                                                            if (isset($pag->parcelado) && $pag->parcelado && $pag->num_parcelas > 1) {
                                                                $pagamentosAgrupados[$tipo]['info_parcela'] = "{$pag->num_parcelas}x R$ " . __moeda($pag->valor_parcela);
                                                            }
                                                        }
                                                        @endphp
                                                        
                                                        <div class="pagamentos-compactos">
                                                            @foreach($pagamentosAgrupados as $tipo => $info)
                                                                <div class="mb-1">
                                                                    <span class="badge {{ $info['a_prazo'] ? 'bg-warning text-dark' : 'bg-success' }}">
                                                                        @if($info['parcelado'] && $info['num_parcelas'] > 1)
                                                                            {{ $tipo }} {{ $info['num_parcelas'] }}x R$ {{ __moeda($info['valor_parcela']) }}
                                                                        @else
                                                                            {{ $tipo }}
                                                                        @endif
                                                                    </span>
                                                                    <div class="ms-1">
                                                                        <strong>R$ {{ __moeda($info['valor']) }}</strong>
                                                                        @if($info['a_prazo'])
                                                                            <span class="text-warning small ms-1">(Futuro)</span>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                    <td class="text-end {{ $valorAVista > 0 ? 'text-success' : '' }}">
                                                        @if($valorAVista > 0)
                                                            R$ {{ __moeda($valorAVista) }}
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td class="text-end {{ $valorAPrazo > 0 ? 'text-warning' : '' }}">
                                                        @if($valorAPrazo > 0)
                                                            R$ {{ __moeda($valorAPrazo) }}
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td class="text-end">
                                                        R$ {{ __moeda($valorAVista + $valorAPrazo) }}
                                                    </td>
                                                </tr>
                                                @endif
                                            @empty
                                                <tr>
                                                    <td colspan="8" class="text-center">Nenhuma venda registrada neste caixa.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Movimentações de Trocas -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-info shadow-sm">
                            <div class="card-header bg-info text-white">
                                <h3 class="mb-0"><i class="ri-exchange-line me-2"></i>Movimentações de Trocas</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>ID</th>
                                                <th>Cliente</th>
                                                <th>Data</th>
                                                <th>Forma de Pagamento</th>
                                                <th>Valor Devolvido</th>
                                                <th>Valor Trocado</th>
                                                <th>Diferença</th>
                                                <th>Tipo</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php 
                                            $somaDevolucoesDinheiro = 0; 
                                            $somaTrocasDiferenca = 0; 
                                            @endphp
                                            
                                            @forelse ($trocas as $troca)
                                                @php
                                                // Calcular o valor da troca (valor devolvido - diferença)
                                                $valorTrocado = $troca->valor_total - $troca->valor_diferenca;
                                                
                                                // Se for troca com diferença em dinheiro ou PIX, adicionar ao total
                                                if (($troca->tipo_pagamento == '01' || $troca->tipo_pagamento == '17') && $troca->valor_diferenca != 0) {
                                                    if ($troca->valor_diferenca > 0) {
                                                        // Se diferença é positiva, cliente recebeu: sai do caixa
                                                        $somaDevolucoesDinheiro += $troca->valor_diferenca;
                                                    } else {
                                                        // Se diferença é negativa, cliente pagou: entra no caixa
                                                        $somaTrocasDiferenca += abs($troca->valor_diferenca);
                                                    }
                                                }
                                                @endphp
                                                <tr>
                                                    <td>{{ $troca->id }}</td>
                                                    <td>{{ $troca->cliente ? $troca->cliente->razao_social : 'NÃO IDENTIFICADO' }}</td>
                                                    <td>{{ __data_pt($troca->data_devolucao, 1) }}</td>
                                                    <td>
                                                        <span class="badge {{ in_array($troca->tipo_pagamento, ['05', '06', '15']) ? 'bg-warning text-dark' : 'bg-success' }}">
                                                            {{ App\Models\Nfce::getTipoPagamento($troca->tipo_pagamento) }}
                                                        </span>
                                                    </td>
                                                    <td class="text-end">
                                                        R$ {{ __moeda($troca->valor_total) }}
                                                    </td>
                                                    <td class="text-end">
                                                        R$ {{ __moeda($valorTrocado) }}
                                                    </td>
                                                    <td class="text-end {{ $troca->valor_diferenca > 0 ? 'text-danger' : ($troca->valor_diferenca < 0 ? 'text-success' : '') }}">
                                                        @if($troca->valor_diferenca != 0)
                                                            R$ {{ __moeda(abs($troca->valor_diferenca)) }}
                                                            @if($troca->valor_diferenca > 0)
                                                                <small>(Cliente recebeu)</small>
                                                            @else
                                                                <small>(Cliente pagou)</small>
                                                            @endif
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <span class="badge {{ $troca->valor_diferenca > 0 ? 'bg-danger' : ($troca->valor_diferenca < 0 ? 'bg-success' : 'bg-secondary') }}">
                                                            @if($troca->valor_diferenca > 0)
                                                                Saída
                                                            @elseif($troca->valor_diferenca < 0)
                                                                Entrada
                                                            @else
                                                                Neutra
                                                            @endif
                                                        </span>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="8" class="text-center">Nenhuma troca registrada neste caixa.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        <tfoot class="table-light">
                                            <tr>
                                                <td colspan="6" class="text-end"><strong>Total de Saídas (Diferenças pagas ao cliente):</strong></td>
                                                <td class="text-end text-danger"><strong>R$ {{ __moeda($trocas->totalSaidas) }}</strong></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td colspan="6" class="text-end"><strong>Total de Entradas (Diferenças pagas pelo cliente):</strong></td>
                                                <td class="text-end text-success"><strong>R$ {{ __moeda($trocas->totalEntradas) }}</strong></td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Movimentações de Recebimentos -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-success shadow-sm">
                            <div class="card-header bg-success text-white">
                                <h3 class="mb-0"><i class="ri-money-dollar-circle-line me-2"></i>Movimentações de Recebimentos</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-success">
                                            <tr>
                                                <th>ID</th>
                                                <th>Tipo</th>
                                                <th>Cliente</th>
                                                <th>Descrição</th>
                                                <th>Data</th>
                                                <th>Forma(s) de Pagamento</th>
                                                <th>Valor Total</th>
                                                <th>Valor Pago</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $totalRecebimentos = 0; @endphp
                                            @forelse($recebimentosAgrupados as $conta)
                                            <tr>
                                                <td>{{ $conta->doc_id }}</td>
                                                <td>{{ $conta->tipo }}</td>
                                                <td>
                                                    @if(isset($conta->cliente) && $conta->cliente)
                                                        {{ $conta->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}
                                                    @else
                                                        Não identificado
                                                    @endif
                                                </td>
                                                <td>{{ $conta->descricao }}</td>
                                                <td>{{ __data_pt($conta->created_at, 0) }}</td>
                                                <td>
                                                    <div class="pagamentos-compactos">
                                                        @foreach($conta->pagamentos as $pagamento)
                                                            <div class="mb-1">
                                                                <span class="badge bg-success">{{ $pagamento->pagamento_nome }}</span>
                                                                <strong>R$ {{ __moeda($pagamento->valor_pagamento) }}</strong>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </td>
                                                <td>
                                                    <strong>R$ {{ __moeda($conta->valor_integral) }}</strong>
                                                    @if($conta->status == 2)
                                                        <span class="badge bg-warning text-dark">Parcial</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong>R$ {{ __moeda($conta->valor_total_pago) }}</strong>
                                                    @if($conta->status == 1)
                                                        <span class="badge bg-success">Completo</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @php 
                                                $totalRecebimentos += $conta->valor_total_pago; 
                                            @endphp
                                            @empty
                                            <tr>
                                                <td colspan="8" class="text-center">Nenhum registro</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                        @if(count($recebimentosAgrupados) > 0)
                                        <tfoot class="table-success">
                                            <tr>
                                                <td colspan="7" class="text-end"><strong>TOTAL</strong></td>
                                                <td><strong>R$ {{ __moeda($totalRecebimentos) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Lista de Operações de Devolução -->
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card border-danger shadow-sm">
                            <div class="card-header bg-danger text-white">
                                <h3 class="mb-0"><i class="ri-refund-2-line me-2"></i>Devoluções de Vendas</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover">
                                        <thead class="table-danger">
                                            <tr>
                                                <th>#</th>
                                                <th>Venda</th>
                                                <th>Cliente</th>
                                                <th>Data</th>
                                                <th>Forma de Pagamento</th>
                                                <th>Valor</th>
                                                <th>Tipo</th>
                                                <th>Itens</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $totalDevolucoesMostrado = 0; @endphp
                                            @forelse ($devolucoes as $devolucao)
                                            <tr>
                                                <td>{{ $devolucao->id }}</td>
                                                <td>
                                                    @if($devolucao->tipo_venda == 'nfe')
                                                        NFe #{{ $devolucao->venda_id }}
                                                    @elseif($devolucao->tipo_venda == 'nfce')
                                                        NFCe #{{ $devolucao->venda_id }}
                                                    @endif
                                                </td>
                                                <td>{{ $devolucao->cliente ? $devolucao->cliente->razao_social : 'Cliente não informado' }}</td>
                                                <td>{{ __data_pt($devolucao->data_devolucao, 1) }}</td>
                                                <td>
                                                    @if($devolucao->tipo_pagamento == '00')
                                                        <span class="badge bg-info">Vale Crédito</span>
                                                    @elseif($devolucao->tipo_pagamento == '01')
                                                        <span class="badge bg-success">Dinheiro</span>
                                                    @elseif($devolucao->tipo_pagamento == '03')
                                                        <span class="badge bg-primary">Cartão de Crédito</span>
                                                    @elseif($devolucao->tipo_pagamento == '04')
                                                        <span class="badge bg-primary">Cartão de Débito</span>
                                                    @else
                                                        <span class="badge bg-secondary">{{ \App\Models\Nfe::getTipoPagamentoByTipo($devolucao->tipo_pagamento) }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong>R$ {{ __moeda($devolucao->valor_total) }}</strong>
                                                </td>
                                                <td>
                                                    @php
                                                        $totalItens = count($devolucao->itens);
                                                        $venda_total_itens = 0;
                                                        
                                                        if($devolucao->tipo_venda == 'nfe') {
                                                            $venda = \App\Models\Nfe::find($devolucao->venda_id);
                                                            if($venda) {
                                                                $venda_total_itens = count($venda->itens);
                                                            }
                                                        } elseif($devolucao->tipo_venda == 'nfce') {
                                                            $venda = \App\Models\Nfce::find($devolucao->venda_id);
                                                            if($venda) {
                                                                $venda_total_itens = count($venda->itens);
                                                            }
                                                        }
                                                        
                                                        $status = $totalItens == $venda_total_itens ? 'Total' : 'Parcial';
                                                    @endphp
                                                    
                                                    @if($status == 'Total')
                                                        <span class="badge bg-danger">Devolução Total</span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">Devolução Parcial</span>
                                                    @endif
                                                </td>
                                                <td>{{ $totalItens }} item(ns)</td>
                                            </tr>
                                            @php $totalDevolucoesMostrado += $devolucao->valor_total; @endphp
                                            @empty
                                            <tr>
                                                <td colspan="8" class="text-center">Nenhuma devolução encontrada.</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                        @if(count($devolucoes) > 0)
                                        <tfoot class="table-warning text-dark">
                                            <tr>
                                                <td colspan="5" class="text-end"><strong>TOTAL DE DEVOLUÇÕES</strong></td>
                                                <td colspan="3"><strong>R$ {{ __moeda($totalDevolucoesMostrado) }}</strong></td>
                                            </tr>
                                            <tr>
                                                <td colspan="5" class="text-end"><strong>DETALHAMENTO POR TIPO</strong></td>
                                                <td colspan="3">
                                                    <span class="badge bg-success me-1">Dinheiro: R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</span>
                                                    <span class="badge bg-primary me-1">Cartão: R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                                                    <span class="badge bg-info me-1">Crédito Loja: R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                                                    <span class="badge bg-secondary me-1">PIX: R$ {{ __moeda($devolucoesPorTipo['pix']) }}</span>
                                                </td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-file-chart-line me-2"></i>Demonstrativo Financeiro do Caixa</h3>
                            </div>
                            <div class="card-body">
                                @php
                                    // --- Centralized Calculations for the Financial Statement ---
                                    
                                    // 1. Calculate Gross Sales (all sales, including cancelled)
                                    $vendasBrutas = 0;
                                    foreach($data as $v) {
                                        $valor = isset($v->valor) && $v->valor > 0 ? $v->valor : $v->total;
                                        $vendasBrutas += $valor;
                                    }

                                    // 2. Calculate values of pending and cancelled sales
                                    $valorCancelamentos = collect($data)->where('estado', 'cancelado')->sum('total');
                                    $vendasPendentes = ($somaTiposPagamento['05'] ?? 0) + ($somaTiposPagamento['06'] ?? 0) + ($somaTiposPagamento['15'] ?? 0) + ($somaTiposPagamento['16'] ?? 0);
                                    
                                    // 3. Define total exits
                                    $totalSaidas = ($somaSangria ?? 0) + ($pagar->sum('valor_integral') ?? 0) + ($devolucoesPorTipo['dinheiro'] ?? 0) + ($devolucoesPorTipo['pix'] ?? 0) + ($devolucoesPorTipo['cartao'] ?? 0) + ($devolucoesPorTipo['credito'] ?? 0) + ($trocas->totalSaidas ?? 0) + $valorCancelamentos;
                                    
                                    // 4. Calculate actual cash entries
                                    $vendasRecebidas = $vendasBrutas - $vendasPendentes; // Based on Gross Sales
                                    $entradasReais = $vendasRecebidas + ($totalRecebidoEfetivo ?? 0) + ($somaSuprimento ?? 0) + ($trocas->totalEntradas ?? 0);
                                    
                                    // 5. Final Balance Calculation
                                    $saldoFinalCaixa = ($item->valor_abertura ?? 0) + $entradasReais - $totalSaidas;
                                    $parcial = ($item->valor_abertura ?? 0) + $entradasReais;
                                    
                                @endphp
                                <div class="row">
                                    <!-- Coluna de Entradas -->
                                    <div class="col-md-4">
                                        <div class="card border-success h-100">
                                            <div class="card-header bg-success text-white">
                                                <h4 class="mb-0"><i class="ri-arrow-down-circle-line me-2"></i>Entradas</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Valor de Abertura
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($item->valor_abertura) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Vendas Recebidas
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($vendasRecebidas) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Contas Recebidas
                                                        @php
                                                            $totalRecebidoEfetivo = 0;
                                                            foreach($receber as $r) {
                                                                if($r->valor_recebido > 0 && $r->valor_recebido < $r->valor_integral) {
                                                                    $totalRecebidoEfetivo += $r->valor_recebido;
                                                                } else {
                                                                    $totalRecebidoEfetivo += $r->valor_integral;
                                                                }
                                                            }
                                                        @endphp
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($totalRecebidoEfetivo) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Suprimentos
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($somaSuprimento) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Trocas - Entradas (Diferenças pagas pelo cliente)
                                                        <span class="badge bg-success rounded-pill" data-bs-toggle="tooltip" data-bs-placement="top" title="Trocas - Entradas (R$ {{ __moeda($trocas->totalEntradas ?? 0) }})">R$ {{ __moeda($trocas->totalEntradas) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total de Entradas</strong>
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda(($item->valor_abertura ?? 0) + $entradasReais) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Coluna de Saídas -->
                                    <div class="col-md-4">
                                        <div class="card border-danger h-100">
                                            <div class="card-header bg-danger text-white">
                                                <h4 class="mb-0"><i class="ri-arrow-up-circle-line me-2"></i>Saídas</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Sangrias
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($somaSangria) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Contas Pagas
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($pagar->sum('valor_integral')) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Dinheiro/PIX
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda(($devolucoesPorTipo['dinheiro'] ?? 0) + ($devolucoesPorTipo['pix'] ?? 0)) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Cartão
                                                        <span class="badge bg-primary rounded-pill">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Vale Crédito
                                                        <span class="badge bg-info rounded-pill">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Trocas - Saídas (Diferenças pagas ao cliente)
                                                        <span class="badge bg-danger rounded-pill" data-bs-toggle="tooltip" data-bs-placement="top" title="Trocas - Saídas (R$ {{ __moeda($trocas->totalSaidas ?? 0) }})">R$ {{ __moeda($trocas->totalSaidas) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Cancelamentos de Vendas
                                                        <span class="badge bg-danger">R$ {{ __moeda($valorCancelamentos) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total de Saídas</strong>
                                                        <span class="badge bg-danger">R$ {{ __moeda($totalSaidas) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Coluna de Saldo e Pendente -->
                                    <div class="col-md-4">
                                        <div class="card border-info h-100">
                                            <div class="card-header bg-info text-white">
                                                <h4 class="mb-0"><i class="ri-funds-box-line me-2"></i>Saldos e Pendências</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Saldo em Caixa</strong>
                                                        <span class="badge bg-primary rounded-pill">R$ {{ __moeda($valorEmCaixa) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Crediário)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['06'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Boleto)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['15'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Crédito Loja)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['05'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total Vendas Pendentes</strong>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda(($somaTiposPagamento['05'] ?? 0) + ($somaTiposPagamento['06'] ?? 0) + ($somaTiposPagamento['15'] ?? 0) + ($somaTiposPagamento['16'] ?? 0)) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Resumo Visual Final -->
                                <div class="card border-primary mt-4">
                                    <div class="card-header bg-primary text-white">
                                        <h4 class="mb-0"><i class="ri-bank-card-line me-2"></i>Resumo Geral</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Vendas Brutas</h5>
                                                    <h3 class="text-primary">R$ {{ __moeda($vendasBrutas) }}</h3>
                                                    <small class="text-muted">(Total de todas as vendas)</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Vendas Recebidas</h5>
                                                    <h3 class="text-success">R$ {{ __moeda($vendasRecebidas) }}</h3>
                                                    <small class="text-muted">(Dinheiro, Cartão, PIX, etc.)</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Vendas Pendentes</h5>
                                                    <h3 class="text-warning">R$ {{ __moeda($vendasPendentes) }}</h3>
                                                    <small class="text-muted">(Crediário, Boleto, Crédito Loja)</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center border border-success rounded p-3 bg-light">
                                                    <h5>Saldo Final em Caixa</h5>
                                                    <small class="text-muted d-block mb-1">(Entradas - Saídas = Saldo Final)</small>
                                                    <h2 class="{{ $saldoFinalCaixa < 0 ? 'text-danger' : 'text-success' }}">
  R$ {{ __moeda(
    $item->valor_abertura
    + $vendasRecebidas
    + ($totalRecebidoEfetivo ?? 0)
    + ($somaSuprimento ?? 0)
    + ($trocas->totalEntradas ?? 0)
    - ($somaSangria ?? 0)
    - (($devolucoesPorTipo['dinheiro'] ?? 0) + ($devolucoesPorTipo['pix'] ?? 0))
    - ($trocas->totalSaidas ?? 0)
    - ($pagar->sum('valor_integral') ?? 0)
    - $valorCancelamentos
  ) }}
</h2>
                                                    <div class="mt-2 text-start small">
                                                        <button class="btn btn-sm btn-outline-info w-100" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFormula" aria-expanded="false" aria-controls="collapseFormula">
                                                            <i class="ri-information-line me-1"></i>Ver detalhes do cálculo
                                                        </button>
                                                        <div class="collapse" id="collapseFormula">
                                                            <div class="alert alert-info p-2 mt-2">
                                                                <strong>Fórmula:</strong>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-corner-right-down-line"></i></span><span class="formula-description">Valor Abertura (R$ {{ __moeda($item->valor_abertura) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-add-line"></i></span><span class="formula-description">Vendas Recebidas (R$ {{ __moeda($vendasRecebidas) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-add-line"></i></span><span class="formula-description">Contas Recebidas (R$ {{ __moeda($totalRecebidoEfetivo ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-add-line"></i></span><span class="formula-description">Suprimentos (R$ {{ __moeda($somaSuprimento ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-add-line"></i></span><span class="formula-description">Trocas - Entradas (R$ {{ __moeda($trocas->totalEntradas ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-subtract-line"></i></span><span class="formula-description">Sangrias (R$ {{ __moeda($somaSangria ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-subtract-line"></i></span><span class="formula-description">Devoluções em Dinheiro (R$ {{ __moeda($devolucoesPorTipo['dinheiro'] ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-subtract-line"></i></span><span class="formula-description">Devoluções em PIX (R$ {{ __moeda($devolucoesPorTipo['pix'] ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-information-line text-secondary" title="Não abate do caixa"></i></span><span class="formula-description">Devoluções em Cartão (R$ {{ __moeda($devolucoesPorTipo['cartao'] ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-information-line text-secondary" title="Não abate do caixa"></i></span><span class="formula-description">Devoluções em Vale Crédito (R$ {{ __moeda($devolucoesPorTipo['credito'] ?? 0) }})</span></div>
                                                                <!-- <div class="mt-1 small text-muted">
                                                                    <span class="formula-icon"><i class="ri-information-line text-secondary"></i></span> Itens com este ícone não abatem o saldo do caixa.
                                                                </div> -->
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-subtract-line"></i></span><span class="formula-description">Contas Pagas (R$ {{ __moeda($pagar->sum('valor_integral') ?? 0) }})</span></div>
                                                                <div class="formula-item"><span class="formula-icon"><i class="ri-subtract-line"></i></span><span class="formula-description">Cancelamentos de Vendas (R$ {{ __moeda($valorCancelamentos) }})</span></div>
                                                                <div class="formula-result"><span class="formula-icon"><i class="ri-equals-line"></i></span><span class="formula-description"><strong>Valor em Caixa: R$ {{ __moeda($saldoFinalCaixa) }}</strong></span></div>
                                                                <div class="mt-1 small text-muted">
                                                                    <span class="formula-icon"><i class="ri-information-line text-secondary"></i></span> Itens com este ícone não abatem o saldo do caixa.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row align-items-center mt-4">
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Valor de Abertura</h5>
                                                    <h3 class="text-primary">R$ {{ __moeda($item->valor_abertura) }}</h3>
                                                    <small class="text-muted">(Saldo inicial do caixa)</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Contas Recebidas</h5>
                                                    <h3 class="text-info">R$ {{ __moeda($totalRecebidoEfetivo ?? 0) }}</h3>
                                                    <small class="text-muted">(Valor efetivo recebido)</small>
                                                    <small class="text-muted d-block">(Valor total das contas: R$ {{ __moeda($receber->sum('valor_integral') ?? 0) }})</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Suprimentos</h5>
                                                    <h3 class="text-success">R$ {{ __moeda($somaSuprimento ?? 0) }}</h3>
                                                    <small class="text-muted">(Entradas de dinheiro no caixa)</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center mb-3">
                                                    <h5>Sangrias</h5>
                                                    <h3 class="text-danger">R$ {{ __moeda($somaSangria ?? 0) }}</h3>
                                                    <small class="text-muted">(Saídas de dinheiro do caixa)</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3 m-3">
                @if(sizeof($data) == 0)
                <h3>Caixa sem movimentação!</h3>
                @else

                <div class="d-flex gap-2 mb-3">
                    @if($item->status == 1)
                        <a class="btn btn-info d-flex align-items-center justify-content-center" style="min-width: 48px; height: 48px;" target="_blank" href="{{ route('caixa.imprimir80' , $item) }}"><i class="ri-printer-fill"></i></a>
                        <a class="btn btn-primary d-flex align-items-center justify-content-center" style="min-width: 120px; height: 48px; white-space: nowrap;" data-bs-toggle="modal" data-bs-target="#sangria"><i class="ri-arrow-up-line me-1"></i> Sangria</a>
                        <a class="btn btn-success d-flex align-items-center justify-content-center" style="min-width: 140px; height: 48px; white-space: nowrap;" data-bs-toggle="modal" data-bs-target="#suprimento"><i class="ri-arrow-down-line me-1"></i> Suprimento</a>
                        <button class="btn btn-danger d-flex align-items-center justify-content-center" style="min-width: 150px; height: 48px; white-space: nowrap;" data-bs-toggle="modal" data-bs-target="#fechamento_caixa">
                            <i class="ri-add-circle-fill me-1"></i> Fechar Caixa
                        </button>
                    @endif
                </div>

                @endif
            </div>
            @endif
        </div>
    </div>
</div>

@if(isset($sangrias) && count($sangrias) > 0)
    <div class="card mt-3">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0"><i class="ri-subtract-line"></i> Sangrias Realizadas</h5>
        </div>
        <div class="card-body p-0">
            <table class="table table-sm mb-0">
                <thead>
                    <tr>
                        <th>Data/Hora</th>
                        <th>Valor</th>
                        <th>Observação</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sangrias as $s)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($s->created_at)->format('d/m/Y H:i:s') }}</td>
                            <td>R$ {{ number_format($s->valor, 2, ',', '.') }}</td>
                            <td>{{ $s->observacao }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endif

@include('modals._fechamento_caixa', ['not_submit' => true])
@include('modals._sangria')
@include('modals._suprimento')

@endsection
