/**
 * Correção para o preenchimento automático dos dados do cliente/fornecedor
 * Este script corrige o problema onde os dados não são preenchidos
 * automaticamente após a seleção no campo select.
 */

$(document).ready(function() {
    // Função para preencher os dados do cliente
    function preencherDadosCliente(cliente) {
        if (!cliente) return;
        
        $.get(path_url + "api/clientes/find/" + cliente)
        .done(function(res) {
            console.log("Preenchendo dados do cliente:", res);
            
            // Campos comuns em telas de cliente (NFe/NFCe)
            $('[id$=cliente_nome], [id$=nome]').val(res.razao_social);
            $('[id$=nome_fantasia]').val(res.nome_fantasia);
            $('[id$=cliente_cpf_cnpj], [id$=cpf_cnpj]').val(res.cpf_cnpj);
            $('[id$=ie]').val(res.ie);
            $('[id$=telefone]').val(res.telefone);
            $('[id$=contribuinte]').val(res.contribuinte).trigger('change');
            $('[id$=consumidor_final]').val(res.consumidor_final).trigger('change');
            $('[id$=email]').val(res.email);
            $('[id$=cidade_cliente], [id$=cliente_cidade]').val(res.cidade_id).trigger('change');
            $('[id$=cliente_rua], [id$=rua]').val(res.rua);
            $('[id$=cliente_numero], [id$=numero]').val(res.numero);
            $('[id$=cep]').val(res.cep);
            $('[id$=cliente_bairro], [id$=bairro]').val(res.bairro);
            $('[id$=complemento]').val(res.complemento);
        })
        .fail(function(err) {
            console.error("Erro ao buscar dados do cliente:", err);
        });
    }
    
    // Função para preencher os dados do fornecedor
    function preencherDadosFornecedor(fornecedor) {
        if (!fornecedor) return;
        
        $.get(path_url + "api/fornecedores/find/" + fornecedor)
        .done(function(res) {
            console.log("Preenchendo dados do fornecedor:", res);
            
            // Campos específicos para fornecedores (Compras)
            $('#inp-fornecedor_nome').val(res.razao_social);
            $('#inp-nome_fantasia').val(res.nome_fantasia);
            $('#inp-fornecedor_cpf_cnpj').val(res.cpf_cnpj);
            $('#inp-ie').val(res.ie);
            $('#inp-telefone').val(res.telefone);
            $('#inp-contribuinte').val(res.contribuinte).trigger('change');
            $('#inp-consumidor_final').val(res.consumidor_final).trigger('change');
            $('#inp-email').val(res.email);
            $('#inp-fornecedor_cidade').val(res.cidade_id).trigger('change');
            $('#inp-fornecedor_rua').val(res.rua);
            $('#inp-fornecedor_numero').val(res.numero);
            $('#inp-cep').val(res.cep);
            $('#inp-fornecedor_bairro').val(res.bairro);
            $('#inp-complemento').val(res.complemento);
        })
        .fail(function(err) {
            console.error("Erro ao buscar dados do fornecedor:", err);
        });
    }

    // Monitorar mudanças no select de cliente
    $(document).on('change', '#inp-cliente_id, .cliente_id', function() {
        var clienteId = $(this).val();
        if (clienteId) {
            preencherDadosCliente(clienteId);
        }
    });

    // Monitorar quando um cliente é selecionado via Select2
    $(document).on('select2:select', '#inp-cliente_id, .cliente_id', function(e) {
        var clienteId = e.params.data.id;
        if (clienteId) {
            preencherDadosCliente(clienteId);
        }
    });
    
    // Monitorar mudanças no select de fornecedor
    $(document).on('change', '#inp-fornecedor_id, .fornecedor_id', function() {
        var fornecedorId = $(this).val();
        if (fornecedorId) {
            preencherDadosFornecedor(fornecedorId);
        }
    });

    // Monitorar quando um fornecedor é selecionado via Select2
    $(document).on('select2:select', '#inp-fornecedor_id, .fornecedor_id', function(e) {
        var fornecedorId = e.params.data.id;
        if (fornecedorId) {
            preencherDadosFornecedor(fornecedorId);
        }
    });
}); 