<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Adicionar campo taxa_percentual na tabela fatura_nves se não existir
        if (!Schema::hasColumn('fatura_nves', 'taxa_percentual')) {
            Schema::table('fatura_nves', function (Blueprint $table) {
                $table->decimal('taxa_percentual', 10, 2)->nullable()->after('valor');
            });
        }

        // Adicionar campo taxa_percentual na tabela fatura_nfces se não existir
        if (!Schema::hasColumn('fatura_nfces', 'taxa_percentual')) {
            Schema::table('fatura_nfces', function (Blueprint $table) {
                $table->decimal('taxa_percentual', 10, 2)->nullable()->after('valor');
            });
        }

        // Migrar dados existentes de nfes para fatura_nves para vendas com pagamento único
        DB::statement("
            UPDATE fatura_nves fn
            JOIN nfes n ON fn.nfe_id = n.id
            SET fn.taxa_percentual = n.taxa_percentual
            WHERE n.taxa_percentual IS NOT NULL
            AND fn.taxa_percentual IS NULL
        ");

        // Migrar dados existentes de nfces para fatura_nfces para vendas com pagamento único
        DB::statement("
            UPDATE fatura_nfces fn
            JOIN nfces n ON fn.nfce_id = n.id
            SET fn.taxa_percentual = n.taxa_percentual
            WHERE n.taxa_percentual IS NOT NULL
            AND fn.taxa_percentual IS NULL
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('fatura_nves', 'taxa_percentual')) {
            Schema::table('fatura_nves', function (Blueprint $table) {
                $table->dropColumn('taxa_percentual');
            });
        }

        if (Schema::hasColumn('fatura_nfces', 'taxa_percentual')) {
            Schema::table('fatura_nfces', function (Blueprint $table) {
                $table->dropColumn('taxa_percentual');
            });
        }
    }
}; 